/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.web.pages.domain.purification;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import nc.ird.cantharella.data.exceptions.DataNotFoundException;
import nc.ird.cantharella.data.exceptions.UnexpectedException;
import nc.ird.cantharella.data.model.Fraction;
import nc.ird.cantharella.data.model.MethodePurification;
import nc.ird.cantharella.data.model.Personne;
import nc.ird.cantharella.data.model.Produit;
import nc.ird.cantharella.data.model.Purification;
import nc.ird.cantharella.data.validation.utils.ModelValidator;
import nc.ird.cantharella.service.services.PersonneService;
import nc.ird.cantharella.service.services.ProduitService;
import nc.ird.cantharella.service.services.PurificationService;
import nc.ird.cantharella.utils.BeanTools;
import nc.ird.cantharella.utils.CollectionTools;
import nc.ird.cantharella.web.pages.TemplatePage;
import nc.ird.cantharella.web.pages.domain.document.panel.ManageListDocumentsPanel;
import nc.ird.cantharella.web.pages.renderers.PersonneRenderer;
import nc.ird.cantharella.web.utils.CallerPage;
import nc.ird.cantharella.web.utils.behaviors.JSConfirmationBehavior;
import nc.ird.cantharella.web.utils.forms.SubmittableButton;
import nc.ird.cantharella.web.utils.forms.SubmittableButtonEvents;
import nc.ird.cantharella.web.utils.security.AuthRole;
import nc.ird.cantharella.web.utils.security.AuthRoles;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Page;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.markup.html.form.DateTextField;
import org.apache.wicket.extensions.yui.calendar.DatePicker;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.MultiLineLabel;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.IFormSubmittingComponent;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.apache.wicket.util.string.StringValueConversionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AuthRoles(value={AuthRole.ADMIN, AuthRole.USER})
public final class ManagePurificationPage
extends TemplatePage {
    private static final Logger LOG = LoggerFactory.getLogger(ManagePurificationPage.class);
    private static final String ACTION_CREATE = "Create";
    private static final String ACTION_UPDATE = "Update";
    private static final String ACTION_DELETE = "Delete";
    private final IModel<Purification> purificationModel;
    private Model<Fraction> newFractionModel;
    @SpringBean
    private PurificationService purificationService;
    @SpringBean
    private PersonneService personneService;
    @SpringBean
    private ProduitService produitService;
    private final List<Personne> personnes;
    private final List<MethodePurification> methodes;
    private final List<Produit> produits;
    @SpringBean(name="webModelValidator")
    private ModelValidator validator;
    private final CallerPage callerPage;
    private boolean multipleEntry;
    private boolean createMode;
    private HashMap<String, Integer> fractionsDeleted;
    Button addPurificationButton;
    MarkupContainer descriptionMethoContainer;
    MarkupContainer paramsMethoContainer;

    public ManagePurificationPage(CallerPage callerPage, boolean multipleEntry) {
        this(null, null, callerPage, multipleEntry);
    }

    public ManagePurificationPage(Integer idManip, CallerPage callerPage) {
        this(idManip, null, callerPage, false);
    }

    public ManagePurificationPage(Purification manip, CallerPage callerPage) {
        this(null, manip, callerPage, true);
    }

    private ManagePurificationPage(Integer idManip, Purification manip, CallerPage callerPage, boolean multipleEntry) {
        super(ManagePurificationPage.class);
        assert (idManip == null || manip == null);
        this.callerPage = callerPage;
        CallerPage currentPage = new CallerPage((TemplatePage)this);
        this.multipleEntry = multipleEntry;
        this.fractionsDeleted = new HashMap();
        this.newFractionModel = new Model((Serializable)new Fraction());
        try {
            this.purificationModel = new Model((Serializable)(idManip == null && manip == null ? new Purification() : (manip != null ? manip : this.purificationService.loadPurification(idManip))));
        }
        catch (DataNotFoundException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new UnexpectedException((Exception)((Object)e));
        }
        boolean bl = this.createMode = idManip == null;
        if (this.createMode) {
            ((Purification)this.purificationModel.getObject()).setCreateur((Personne)this.getSession().getUtilisateur());
        }
        this.personnes = this.personneService.listPersonnes();
        this.methodes = this.purificationService.listMethodesPurification();
        this.produits = this.produitService.listProduits(this.getSession().getUtilisateur());
        if (manip != null) {
            ((Purification)this.purificationModel.getObject()).setManipulateur((Personne)CollectionTools.findWithValue((List)this.personnes, (String)"idPersonne", (BeanTools.AccessType)BeanTools.AccessType.GETTER, (Object)((Purification)this.purificationModel.getObject()).getManipulateur().getIdPersonne()));
        }
        Form formView = new Form("Form");
        this.initPrincipalFields(formView);
        this.initMethodeFields(formView);
        this.initFractionsFields(formView);
        ManageListDocumentsPanel manageListDocumentsPanel = new ManageListDocumentsPanel("ManageListDocumentsPanel", this.purificationModel, currentPage);
        formView.add(new Component[]{manageListDocumentsPanel});
        SubmittableButton createButton = new SubmittableButton(ACTION_CREATE, (SubmittableButtonEvents)new /* Unavailable Anonymous Inner Class!! */);
        createButton.setVisibilityAllowed(this.createMode);
        formView.add(new Component[]{createButton});
        SubmittableButton updateButton = new SubmittableButton(ACTION_UPDATE, (SubmittableButtonEvents)new /* Unavailable Anonymous Inner Class!! */);
        updateButton.setVisibilityAllowed(!this.createMode);
        formView.add(new Component[]{updateButton});
        SubmittableButton deleteButton = new SubmittableButton(ACTION_DELETE, ManagePurificationPage.class, (SubmittableButtonEvents)new /* Unavailable Anonymous Inner Class!! */);
        deleteButton.setVisibilityAllowed(!this.createMode);
        deleteButton.setDefaultFormProcessing(false);
        deleteButton.add(new Behavior[]{new JSConfirmationBehavior(this.getStringModel("Confirm", new Object[0]))});
        formView.add(new Component[]{deleteButton});
        formView.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
        formView.setDefaultButton((IFormSubmittingComponent)this.addPurificationButton);
        this.add(new Component[]{formView});
    }

    private void initPrincipalFields(Form<Void> formView) {
        formView.add(new Component[]{new TextField("Purification.ref", (IModel)new PropertyModel((Object)this.purificationModel, "ref"))});
        formView.add(new Component[]{new DropDownChoice("Purification.manipulateur", (IModel)new PropertyModel((Object)this.purificationModel, "manipulateur"), this.personnes, (IChoiceRenderer)new PersonneRenderer()).setNullValid(false)});
        formView.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
        formView.add(new Component[]{new DateTextField("Purification.date", (IModel)new PropertyModel((Object)this.purificationModel, "date")).add(new Behavior[]{new DatePicker()})});
        DropDownChoice produitsChoice = new DropDownChoice("Purification.produit", (IModel)new PropertyModel((Object)this.purificationModel, "produit"), this.produits);
        produitsChoice.setNullValid(false);
        produitsChoice.setEnabled(this.createMode);
        formView.add(new Component[]{produitsChoice});
        TextField masseDepartInput = new TextField("Purification.masseDepart", (IModel)new PropertyModel((Object)this.purificationModel, "masseDepart"));
        masseDepartInput.add(new Behavior[]{new /* Unavailable Anonymous Inner Class!! */});
        formView.add(new Component[]{masseDepartInput});
        formView.add(new Component[]{new TextArea("Purification.complement", (IModel)new PropertyModel((Object)this.purificationModel, "complement"))});
        formView.add(new Component[]{new TextField("Purification.createur", (IModel)new PropertyModel((Object)this.purificationModel, "createur")).setEnabled(false)});
    }

    private void initMethodeFields(Form<Void> formView) {
        WebMarkupContainer methodeCont = new WebMarkupContainer("Purification.methode");
        methodeCont.setOutputMarkupId(true);
        formView.add(new Component[]{methodeCont});
        this.descriptionMethoContainer = new /* Unavailable Anonymous Inner Class!! */;
        this.descriptionMethoContainer.setOutputMarkupId(true);
        this.descriptionMethoContainer.setOutputMarkupPlaceholderTag(true);
        methodeCont.add(new Component[]{this.descriptionMethoContainer});
        MultiLineLabel methodeDesc = new MultiLineLabel("Purification.descriptionMethode", (IModel)new PropertyModel((Object)this.purificationModel, "methode.description"));
        methodeDesc.setOutputMarkupId(true);
        this.descriptionMethoContainer.add(new Component[]{methodeDesc});
        this.paramsMethoContainer = new /* Unavailable Anonymous Inner Class!! */;
        WebMarkupContainer paramsMethoTable = new WebMarkupContainer("Purification.paramsMethode.Table");
        this.paramsMethoContainer.add(new Component[]{paramsMethoTable});
        this.paramsMethoContainer.setOutputMarkupId(true);
        this.paramsMethoContainer.setOutputMarkupPlaceholderTag(true);
        paramsMethoTable.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
        methodeCont.add(new Component[]{this.paramsMethoContainer});
        DropDownChoice methodeChoice = new DropDownChoice("Purification.nomMethode", (IModel)new PropertyModel((Object)this.purificationModel, "methode"), this.methodes);
        methodeChoice.setNullValid(false);
        methodeChoice.add(new Behavior[]{new /* Unavailable Anonymous Inner Class!! */});
        methodeCont.add(new Component[]{methodeChoice});
    }

    private void initFractionsFields(Form<Void> formView) {
        WebMarkupContainer purificationsTable = new WebMarkupContainer("Purification.fractions.Table");
        purificationsTable.setOutputMarkupId(true);
        purificationsTable.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
        TextField indiceInput = new TextField("Purification.fractions.indice", (IModel)new PropertyModel((Object)this.newFractionModel, "indice"));
        purificationsTable.add(new Component[]{indiceInput});
        TextField refInput = new TextField("Purification.fractions.ref", (IModel)new PropertyModel((Object)this.newFractionModel, "ref"));
        purificationsTable.add(new Component[]{refInput});
        TextField masseObtenueInput = new TextField("Purification.fractions.masseObtenue", (IModel)new PropertyModel((Object)this.newFractionModel, "masseObtenue"));
        purificationsTable.add(new Component[]{masseObtenueInput});
        this.addPurificationButton = new /* Unavailable Anonymous Inner Class!! */;
        purificationsTable.add(new Component[]{this.addPurificationButton});
        formView.add(new Component[]{purificationsTable});
    }

    protected void onBeforeRender() {
        this.refreshModel();
        super.onBeforeRender();
    }

    private void redirect() {
        if (this.multipleEntry) {
            Purification nextManip = new Purification();
            nextManip.setManipulateur(((Purification)this.purificationModel.getObject()).getManipulateur());
            this.setResponsePage((Page)new ManagePurificationPage(nextManip, this.callerPage));
        } else if (this.callerPage != null) {
            this.callerPage.addPageParameter(Purification.class.getSimpleName(), (Object)((Purification)this.purificationModel.getObject()).getIdPurification());
            this.callerPage.responsePage((TemplatePage)this);
        }
    }

    private void refreshModel() {
        String key = Personne.class.getSimpleName();
        if (this.getPageParameters().getNamedKeys().contains(key)) {
            CollectionTools.setter((Collection)this.personnes, (Collection)this.personneService.listPersonnes());
            try {
                Personne createdPersonne = this.personneService.loadPersonne(Integer.valueOf(this.getPageParameters().get(key).toInt()));
                ((Purification)this.purificationModel.getObject()).setManipulateur(createdPersonne);
            }
            catch (StringValueConversionException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                throw new UnexpectedException((Exception)((Object)e));
            }
            catch (DataNotFoundException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                throw new UnexpectedException((Exception)((Object)e));
            }
            this.getPageParameters().remove(key, new String[0]);
        }
    }

    private void validateModel() {
        this.addValidationErrors((Collection)this.validator.validate(this.purificationModel.getObject(), this.getSession().getLocale(), new String[0]));
        if (!this.purificationService.isPurificationUnique((Purification)this.purificationModel.getObject())) {
            this.error((Serializable)((Object)this.getString("Purification.notUnique")));
        }
    }

    static /* synthetic */ IModel access$000(ManagePurificationPage x0) {
        return x0.purificationModel;
    }

    static /* synthetic */ PurificationService access$100(ManagePurificationPage x0) {
        return x0.purificationService;
    }

    static /* synthetic */ void access$200(ManagePurificationPage x0) {
        x0.redirect();
    }

    static /* synthetic */ void access$300(ManagePurificationPage x0) {
        x0.validateModel();
    }

    static /* synthetic */ ProduitService access$400(ManagePurificationPage x0) {
        return x0.produitService;
    }

    static /* synthetic */ HashMap access$500(ManagePurificationPage x0) {
        return x0.fractionsDeleted;
    }

    static /* synthetic */ Model access$600(ManagePurificationPage x0) {
        return x0.newFractionModel;
    }

    static /* synthetic */ ModelValidator access$700(ManagePurificationPage x0) {
        return x0.validator;
    }

    static /* synthetic */ Logger access$800() {
        return LOG;
    }
}

