/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.web.pages.domain.personne;

import java.io.Serializable;
import nc.ird.cantharella.data.exceptions.DataNotFoundException;
import nc.ird.cantharella.data.exceptions.UnexpectedException;
import nc.ird.cantharella.data.model.Personne;
import nc.ird.cantharella.data.model.Utilisateur;
import nc.ird.cantharella.service.services.PersonneService;
import nc.ird.cantharella.web.pages.TemplatePage;
import nc.ird.cantharella.web.pages.domain.document.panel.ManageListDocumentsPanel;
import nc.ird.cantharella.web.pages.domain.personne.panels.ManagePersonnePanel;
import nc.ird.cantharella.web.utils.CallerPage;
import nc.ird.cantharella.web.utils.behaviors.JSConfirmationBehavior;
import nc.ird.cantharella.web.utils.forms.SubmittableButton;
import nc.ird.cantharella.web.utils.forms.SubmittableButtonEvents;
import nc.ird.cantharella.web.utils.security.AuthRole;
import nc.ird.cantharella.web.utils.security.AuthRoles;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AuthRoles(value={AuthRole.ADMIN, AuthRole.USER})
public final class ManagePersonnePage
extends TemplatePage {
    private static final String ACTION_CREATE = "Create";
    private static final String ACTION_CREATE_UTILISATEUR = "CreateUtilisateur";
    private static final String ACTION_DELETE = "Delete";
    private static final String ACTION_UPDATE = "Update";
    private static final Logger LOG = LoggerFactory.getLogger(ManagePersonnePage.class);
    private final CallerPage callerPage;
    private boolean multipleEntry;
    private final IModel<Personne> personneModel;
    @SpringBean
    private PersonneService personneService;

    public ManagePersonnePage(CallerPage callerPage, boolean multipleEntry) {
        this(null, null, callerPage, multipleEntry);
    }

    public ManagePersonnePage(Integer idPersonne, CallerPage callerPage) {
        this(idPersonne, null, callerPage, false);
    }

    public ManagePersonnePage(Personne personne, CallerPage callerPage) {
        this(null, personne, callerPage, true);
    }

    private ManagePersonnePage(Integer idPersonne, Personne personne, CallerPage callerPage, boolean multipleEntry) {
        super(ManagePersonnePage.class);
        assert (idPersonne == null || personne == null);
        this.callerPage = callerPage;
        CallerPage currentPage = new CallerPage((TemplatePage)this);
        this.multipleEntry = multipleEntry;
        try {
            this.personneModel = new Model((Serializable)(idPersonne == null && personne == null ? new Personne() : (personne != null ? personne : this.personneService.loadPersonne(idPersonne))));
        }
        catch (DataNotFoundException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new UnexpectedException((Exception)((Object)e));
        }
        boolean createMode = idPersonne == null;
        Form formView = new Form("Form", this.personneModel);
        ManagePersonnePanel personnePanel = new ManagePersonnePanel("ManagePersonnePanel", this.personneModel);
        formView.add(new Component[]{personnePanel});
        ManageListDocumentsPanel manageListDocumentsPanel = new ManageListDocumentsPanel("ManageListDocumentsPanel", this.personneModel, currentPage);
        manageListDocumentsPanel.setUpdateOrDeleteEnabled(createMode || this.getSession().getUtilisateur().getTypeDroit() == Utilisateur.TypeDroit.ADMINISTRATEUR);
        formView.add(new Component[]{manageListDocumentsPanel});
        SubmittableButton createButton = new SubmittableButton(ACTION_CREATE, (SubmittableButtonEvents)new /* Unavailable Anonymous Inner Class!! */);
        createButton.setVisibilityAllowed(createMode);
        formView.add(new Component[]{createButton});
        SubmittableButton updateButton = new SubmittableButton(ACTION_UPDATE, (SubmittableButtonEvents)new /* Unavailable Anonymous Inner Class!! */);
        updateButton.setVisibilityAllowed(!createMode);
        formView.add(new Component[]{updateButton});
        SubmittableButton createUtilisateurButton = new SubmittableButton(ACTION_CREATE_UTILISATEUR, (SubmittableButtonEvents)new /* Unavailable Anonymous Inner Class!! */);
        createUtilisateurButton.setVisibilityAllowed(!createMode && this.getSession().getUtilisateur().getTypeDroit() == Utilisateur.TypeDroit.ADMINISTRATEUR);
        formView.add(new Component[]{createUtilisateurButton});
        SubmittableButton deleteButton = new SubmittableButton(ACTION_DELETE, (SubmittableButtonEvents)new /* Unavailable Anonymous Inner Class!! */);
        deleteButton.setVisibilityAllowed(!createMode);
        deleteButton.setDefaultFormProcessing(false);
        deleteButton.add(new Behavior[]{new JSConfirmationBehavior(this.getStringModel("Confirm", new Object[0]))});
        formView.add(new Component[]{deleteButton});
        formView.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
        this.add(new Component[]{formView});
    }

    private void redirect() {
        if (this.multipleEntry) {
            Personne nextPersonne = new Personne();
            nextPersonne.setOrganisme(((Personne)this.personneModel.getObject()).getOrganisme());
            nextPersonne.setAdressePostale(((Personne)this.personneModel.getObject()).getAdressePostale());
            nextPersonne.setCodePostal(((Personne)this.personneModel.getObject()).getCodePostal());
            nextPersonne.setVille(((Personne)this.personneModel.getObject()).getVille());
            nextPersonne.setCodePays(((Personne)this.personneModel.getObject()).getCodePays());
            this.setResponsePage((Page)new ManagePersonnePage(nextPersonne, this.callerPage));
        } else if (this.callerPage != null) {
            this.callerPage.addPageParameter(Personne.class.getSimpleName(), (Object)((Personne)this.personneModel.getObject()).getIdPersonne());
            this.callerPage.responsePage((TemplatePage)this);
        }
    }

    static /* synthetic */ IModel access$000(ManagePersonnePage x0) {
        return x0.personneModel;
    }

    static /* synthetic */ PersonneService access$100(ManagePersonnePage x0) {
        return x0.personneService;
    }

    static /* synthetic */ void access$200(ManagePersonnePage x0) {
        x0.redirect();
    }
}

