/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.web.pages.domain.config;

import java.io.Serializable;
import java.util.Collection;
import nc.ird.cantharella.data.exceptions.DataNotFoundException;
import nc.ird.cantharella.data.exceptions.UnexpectedException;
import nc.ird.cantharella.data.model.TypeDocument;
import nc.ird.cantharella.data.validation.utils.ModelValidator;
import nc.ird.cantharella.service.services.DocumentService;
import nc.ird.cantharella.web.pages.TemplatePage;
import nc.ird.cantharella.web.utils.behaviors.JSConfirmationBehavior;
import nc.ird.cantharella.web.utils.forms.SubmittableButton;
import nc.ird.cantharella.web.utils.forms.SubmittableButtonEvents;
import nc.ird.cantharella.web.utils.security.AuthRole;
import nc.ird.cantharella.web.utils.security.AuthRoles;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AuthRoles(value={AuthRole.ADMIN})
public final class ManageTypeDocumentPage
extends TemplatePage {
    private static final String ACTION_CREATE = "Create";
    private static final String ACTION_UPDATE = "Update";
    public static final String ACTION_DELETE = "Delete";
    private final String[] RETURN_PARAM = new String[]{"typeDocument", "opened"};
    private static final Logger LOG = LoggerFactory.getLogger(ManageTypeDocumentPage.class);
    private final IModel<TypeDocument> typeDocumentModel;
    @SpringBean
    private DocumentService documentService;
    @SpringBean(name="webModelValidator")
    private ModelValidator validator;

    public ManageTypeDocumentPage() {
        this(null);
    }

    public ManageTypeDocumentPage(Integer idTypeDocument) {
        super(ManageTypeDocumentPage.class);
        boolean createMode;
        if (idTypeDocument == null) {
            this.typeDocumentModel = new Model((Serializable)new TypeDocument());
            createMode = true;
        } else {
            try {
                this.typeDocumentModel = new Model((Serializable)this.documentService.loadTypeDocument(idTypeDocument));
            }
            catch (DataNotFoundException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                throw new UnexpectedException((Exception)((Object)e));
            }
            createMode = false;
        }
        Form formView = new Form("Form");
        formView.add(new Component[]{new TextField("TypeDocument.nom", (IModel)new PropertyModel((Object)this.typeDocumentModel, "nom"))});
        formView.add(new Component[]{new TextField("TypeDocument.domaine", (IModel)new PropertyModel((Object)this.typeDocumentModel, "domaine"))});
        formView.add(new Component[]{new TextArea("TypeDocument.description", (IModel)new PropertyModel((Object)this.typeDocumentModel, "description"))});
        SubmittableButton createButton = new SubmittableButton(ACTION_CREATE, (SubmittableButtonEvents)new /* Unavailable Anonymous Inner Class!! */);
        createButton.setVisibilityAllowed(createMode);
        formView.add(new Component[]{createButton});
        SubmittableButton updateButton = new SubmittableButton(ACTION_UPDATE, (SubmittableButtonEvents)new /* Unavailable Anonymous Inner Class!! */);
        updateButton.setVisibilityAllowed(!createMode);
        formView.add(new Component[]{updateButton});
        SubmittableButton deleteButton = new SubmittableButton(ACTION_DELETE, (SubmittableButtonEvents)new /* Unavailable Anonymous Inner Class!! */);
        deleteButton.setVisibilityAllowed(!createMode);
        deleteButton.setDefaultFormProcessing(false);
        deleteButton.add(new Behavior[]{new JSConfirmationBehavior(this.getStringModel("Confirm", new Object[0]))});
        formView.add(new Component[]{deleteButton});
        formView.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
        this.add(new Component[]{formView});
    }

    private void validateModel() {
        this.addValidationErrors((Collection)this.validator.validate(this.typeDocumentModel.getObject(), this.getSession().getLocale(), new String[0]));
    }

    static /* synthetic */ IModel access$000(ManageTypeDocumentPage x0) {
        return x0.typeDocumentModel;
    }

    static /* synthetic */ DocumentService access$100(ManageTypeDocumentPage x0) {
        return x0.documentService;
    }

    static /* synthetic */ String[] access$200(ManageTypeDocumentPage x0) {
        return x0.RETURN_PARAM;
    }

    static /* synthetic */ void access$300(ManageTypeDocumentPage x0) {
        x0.validateModel();
    }
}

