/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.web.pages.domain.config;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import nc.ird.cantharella.data.exceptions.DataNotFoundException;
import nc.ird.cantharella.data.exceptions.UnexpectedException;
import nc.ird.cantharella.data.model.MethodeTestBio;
import nc.ird.cantharella.data.validation.utils.ModelValidator;
import nc.ird.cantharella.service.services.TestBioService;
import nc.ird.cantharella.web.pages.TemplatePage;
import nc.ird.cantharella.web.utils.behaviors.JSConfirmationBehavior;
import nc.ird.cantharella.web.utils.forms.AutoCompleteTextFieldString;
import nc.ird.cantharella.web.utils.forms.SubmittableButton;
import nc.ird.cantharella.web.utils.forms.SubmittableButtonEvents;
import nc.ird.cantharella.web.utils.security.AuthRole;
import nc.ird.cantharella.web.utils.security.AuthRoles;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AuthRoles(value={AuthRole.ADMIN})
public final class ManageMethodeTestBioPage
extends TemplatePage {
    private static final String ACTION_CREATE = "Create";
    private static final String ACTION_UPDATE = "Update";
    public static final String ACTION_DELETE = "Delete";
    private final String[] RETURN_PARAM = new String[]{"methodeTestBio", "opened"};
    private static final Logger LOG = LoggerFactory.getLogger(ManageMethodeTestBioPage.class);
    private final IModel<MethodeTestBio> methodeTestModel;
    @SpringBean
    private TestBioService testService;
    @SpringBean(name="webModelValidator")
    private ModelValidator validator;

    public ManageMethodeTestBioPage() {
        this(null);
    }

    public ManageMethodeTestBioPage(Integer idMethodeTest) {
        super(ManageMethodeTestBioPage.class);
        boolean createMode;
        if (idMethodeTest == null) {
            this.methodeTestModel = new Model((Serializable)new MethodeTestBio());
            createMode = true;
        } else {
            try {
                this.methodeTestModel = new Model((Serializable)this.testService.loadMethodeTest(idMethodeTest));
            }
            catch (DataNotFoundException e) {
                LOG.error(e.getMessage(), (Throwable)e);
                throw new UnexpectedException((Exception)((Object)e));
            }
            createMode = false;
        }
        List domaines = this.testService.listDomainesMethodes();
        List unites = this.testService.listUnitesResultatMethodes();
        Form formView = new Form("Form");
        formView.add(new Component[]{new TextField("MethodeTestBio.nom", (IModel)new PropertyModel((Object)this.methodeTestModel, "nom"))});
        formView.add(new Component[]{new TextField("MethodeTestBio.cible", (IModel)new PropertyModel((Object)this.methodeTestModel, "cible"))});
        formView.add(new Component[]{new AutoCompleteTextFieldString("MethodeTestBio.domaine", (IModel)new PropertyModel((Object)this.methodeTestModel, "domaine"), domaines, AutoCompleteTextFieldString.ComparisonMode.CONTAINS)});
        formView.add(new Component[]{new TextArea("MethodeTestBio.description", (IModel)new PropertyModel((Object)this.methodeTestModel, "description"))});
        formView.add(new Component[]{new TextField("MethodeTestBio.valeurMesuree", (IModel)new PropertyModel((Object)this.methodeTestModel, "valeurMesuree"))});
        formView.add(new Component[]{new AutoCompleteTextFieldString("MethodeTestBio.uniteResultat", (IModel)new PropertyModel((Object)this.methodeTestModel, "uniteResultat"), unites, AutoCompleteTextFieldString.ComparisonMode.STARTS_WITH)});
        formView.add(new Component[]{new TextField("MethodeTestBio.critereActivite", (IModel)new PropertyModel((Object)this.methodeTestModel, "critereActivite"))});
        SubmittableButton createButton = new SubmittableButton(ACTION_CREATE, (SubmittableButtonEvents)new /* Unavailable Anonymous Inner Class!! */);
        createButton.setVisibilityAllowed(createMode);
        formView.add(new Component[]{createButton});
        SubmittableButton updateButton = new SubmittableButton(ACTION_UPDATE, (SubmittableButtonEvents)new /* Unavailable Anonymous Inner Class!! */);
        updateButton.setVisibilityAllowed(!createMode);
        formView.add(new Component[]{updateButton});
        SubmittableButton deleteButton = new SubmittableButton(ACTION_DELETE, (SubmittableButtonEvents)new /* Unavailable Anonymous Inner Class!! */);
        deleteButton.setVisibilityAllowed(!createMode);
        deleteButton.setDefaultFormProcessing(false);
        deleteButton.add(new Behavior[]{new JSConfirmationBehavior(this.getStringModel("Confirm", new Object[0]))});
        formView.add(new Component[]{deleteButton});
        formView.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
        this.add(new Component[]{formView});
    }

    private void validateModel() {
        this.addValidationErrors((Collection)this.validator.validate(this.methodeTestModel.getObject(), this.getSession().getLocale(), new String[0]));
    }

    static /* synthetic */ IModel access$000(ManageMethodeTestBioPage x0) {
        return x0.methodeTestModel;
    }

    static /* synthetic */ TestBioService access$100(ManageMethodeTestBioPage x0) {
        return x0.testService;
    }

    static /* synthetic */ String[] access$200(ManageMethodeTestBioPage x0) {
        return x0.RETURN_PARAM;
    }

    static /* synthetic */ void access$300(ManageMethodeTestBioPage x0) {
        x0.validateModel();
    }
}

