/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.web.pages;

import java.io.Serializable;
import nc.ird.cantharella.data.validation.utils.ModelValidator;
import nc.ird.cantharella.service.services.PersonneService;
import nc.ird.cantharella.utils.CaptchaTools;
import nc.ird.cantharella.web.pages.TemplatePage;
import nc.ird.cantharella.web.pages.model.CaptchaModel;
import nc.ird.cantharella.web.pages.model.ContactModel;
import nc.ird.cantharella.web.utils.forms.SubmittableButton;
import nc.ird.cantharella.web.utils.forms.SubmittableButtonEvents;
import nc.ird.cantharella.web.utils.security.AuthRole;
import org.apache.wicket.Component;
import org.apache.wicket.extensions.markup.html.captcha.CaptchaImageResource;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.image.NonCachingImage;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.spring.injection.annot.SpringBean;

public class ContactPage
extends TemplatePage {
    private static final String ACTION_SEND = "Send";
    @SpringBean
    private PersonneService personneService;
    @SpringBean(name="webModelValidator")
    private ModelValidator validator;

    public ContactPage() {
        super(ContactPage.class);
        boolean authMode = this.getSession().getRole() != AuthRole.VISITOR;
        Model contactModel = new Model((Serializable)new ContactModel());
        Model captchaModel = new Model((Serializable)new CaptchaModel());
        if (!authMode) {
            ((CaptchaModel)captchaModel.getObject()).setCaptchaTextGenerated(CaptchaTools.random());
        }
        Form formView = new Form("Form");
        formView.add(new Component[]{new TextField("ContactModel.mail", (IModel)(authMode ? new Model((Serializable)((Object)this.getSession().getUtilisateur().getCourriel())) : new PropertyModel((Object)contactModel, "mail"))).setEnabled(!authMode)});
        formView.add(new Component[]{new TextField("ContactModel.subject", (IModel)new PropertyModel((Object)contactModel, "subject"))});
        formView.add(new Component[]{new TextArea("ContactModel.message", (IModel)new PropertyModel((Object)contactModel, "message"))});
        WebMarkupContainer captcha = new WebMarkupContainer("captcha");
        captcha.setVisibilityAllowed(!authMode);
        captcha.add(new Component[]{new NonCachingImage("CaptchaModel.captchaImage", (IResource)new CaptchaImageResource(((CaptchaModel)captchaModel.getObject()).getCaptchaTextGenerated()))});
        TextField captchaTextView = new TextField("CaptchaModel.captchaText", (IModel)new PropertyModel((Object)captchaModel, "captchaText"));
        captcha.add(new Component[]{captchaTextView});
        formView.add(new Component[]{captcha});
        formView.add(new Component[]{new SubmittableButton(ACTION_SEND, (SubmittableButtonEvents)new /* Unavailable Anonymous Inner Class!! */)});
        this.add(new Component[]{formView});
    }

    static /* synthetic */ PersonneService access$000(ContactPage x0) {
        return x0.personneService;
    }

    static /* synthetic */ ModelValidator access$100(ContactPage x0) {
        return x0.validator;
    }
}

