/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.web.utils.forms;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import nc.ird.cantharella.utils.AssertTools;
import nc.ird.cantharella.utils.Pair;
import nc.ird.cantharella.utils.StringTools;
import nc.ird.cantharella.utils.StringTransformer;
import nc.ird.cantharella.web.utils.forms.AutoCompleteTextFieldString;
import org.apache.wicket.extensions.ajax.markup.html.autocomplete.AutoCompleteTextField;
import org.apache.wicket.extensions.ajax.markup.html.autocomplete.StringAutoCompleteRenderer;
import org.apache.wicket.model.IModel;

/*
 * Exception performing whole class analysis ignored.
 */
public class AutoCompleteTextFieldString
extends AutoCompleteTextField<String> {
    private final List<Pair<String, String>> choices;
    private final int maxChoices;
    private final int minLength;
    private final ComparisonMode mode;

    private static String purgeString(String string) {
        return new StringTransformer(string).trimToNull().replaceAccents().toLowerCase().toString();
    }

    public AutoCompleteTextFieldString(String id, IModel<String> model, List<String> choices, ComparisonMode mode) {
        this(id, model, choices, mode, 0, Integer.MAX_VALUE);
    }

    public AutoCompleteTextFieldString(String id, IModel<String> model, List<String> choices, ComparisonMode mode, int minLength, int maxChoices) {
        super(id, model, StringAutoCompleteRenderer.INSTANCE);
        AssertTools.assertNotNull(choices);
        AssertTools.assertNotNull((Object)mode);
        AssertTools.assertNotNegative((Number)minLength);
        AssertTools.assertPositive((Number)maxChoices);
        this.choices = new ArrayList();
        for (String choice : choices) {
            String purgeChoice = AutoCompleteTextFieldString.purgeString((String)choice);
            if (purgeChoice == null || purgeChoice.length() < minLength) continue;
            this.choices.add(new Pair((Object)purgeChoice, (Object)choice));
        }
        this.mode = mode;
        this.minLength = minLength;
        this.maxChoices = maxChoices;
    }

    protected Iterator<String> getChoices(String input) {
        TreeSet<Object> choicesList = new TreeSet<Object>();
        String purgeInput = AutoCompleteTextFieldString.purgeString((String)input);
        if (StringTools.length((String)purgeInput) >= this.minLength) {
            Iterator i = this.choices.iterator();
            while (i.hasNext() && choicesList.size() < this.maxChoices) {
                Pair choice = (Pair)i.next();
                if (!(this.mode == ComparisonMode.STARTS_WITH && ((String)choice.getKey()).startsWith(purgeInput) || this.mode == ComparisonMode.CONTAINS && ((String)choice.getKey()).contains(purgeInput) || this.mode == ComparisonMode.ENDS_WITH && ((String)choice.getKey()).endsWith(purgeInput)) && (this.mode != ComparisonMode.EQUALS || !((String)choice.getKey()).equals(purgeInput))) continue;
                choicesList.add(choice.getValue());
            }
        }
        return choicesList.iterator();
    }

    public void addChoice(String choice) {
        String purgeChoice = AutoCompleteTextFieldString.purgeString((String)choice);
        if (purgeChoice != null && purgeChoice.length() >= this.minLength) {
            this.choices.add(new Pair((Object)purgeChoice, (Object)choice));
        }
    }
}

