/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.web.pages.domain.campagne;

import java.io.Serializable;
import java.util.Map;
import nc.ird.cantharella.data.model.Campagne;
import nc.ird.cantharella.service.services.CampagneService;
import nc.ird.cantharella.service.services.StationService;
import nc.ird.cantharella.web.config.WebContext;
import nc.ird.cantharella.web.pages.TemplatePage;
import nc.ird.cantharella.web.pages.domain.campagne.ManageCampagnePage;
import nc.ird.cantharella.web.pages.domain.campagne.ReadCampagnePage;
import nc.ird.cantharella.web.pages.domain.document.panel.ReadListDocumentsPanel;
import nc.ird.cantharella.web.utils.CallerPage;
import nc.ird.cantharella.web.utils.behaviors.JSConfirmationBehavior;
import nc.ird.cantharella.web.utils.behaviors.ReplaceEmptyLabelBehavior;
import nc.ird.cantharella.web.utils.forms.SubmittableButton;
import nc.ird.cantharella.web.utils.forms.SubmittableButtonEvents;
import nc.ird.cantharella.web.utils.models.DisplayMapValuePropertyModel;
import nc.ird.cantharella.web.utils.models.GenericLoadableDetachableModel;
import nc.ird.cantharella.web.utils.panels.SimpleTooltipPanel;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.basic.MultiLineLabel;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.spring.injection.annot.SpringBean;

public final class ReadCampagnePage
extends TemplatePage {
    public static final String ACTION_DELETE = "Delete";
    private final CallerPage callerPage;
    private final IModel<Campagne> campagneModel;
    @SpringBean
    private CampagneService campagneService;
    @SpringBean
    private StationService stationService;

    public ReadCampagnePage(Integer idCampagne, CallerPage callerPage) {
        super(ReadCampagnePage.class);
        CallerPage currentPage = new CallerPage((TemplatePage)this.getPage());
        this.callerPage = callerPage;
        this.campagneModel = new GenericLoadableDetachableModel(Campagne.class, (Serializable)idCampagne);
        Campagne campagne = (Campagne)this.campagneModel.getObject();
        this.add(new Component[]{new Label("Campagne.nom", (IModel)new PropertyModel((Object)this.campagneModel, "nom")).add(new Behavior[]{new ReplaceEmptyLabelBehavior()})});
        this.add(new Component[]{new Label("Campagne.codePays", (IModel)new DisplayMapValuePropertyModel((Object)this.campagneModel, "codePays", (Map)WebContext.COUNTRIES.get(this.getSession().getLocale()))).add(new Behavior[]{new ReplaceEmptyLabelBehavior()})});
        this.add(new Component[]{new Label("Campagne.dateDeb", (IModel)new PropertyModel((Object)this.campagneModel, "dateDeb")).add(new Behavior[]{new ReplaceEmptyLabelBehavior()})});
        this.add(new Component[]{new Label("Campagne.dateFin", (IModel)new PropertyModel((Object)this.campagneModel, "dateFin")).add(new Behavior[]{new ReplaceEmptyLabelBehavior()})});
        this.add(new Component[]{new Label("Campagne.programme", (IModel)new PropertyModel((Object)this.campagneModel, "programme")).add(new Behavior[]{new ReplaceEmptyLabelBehavior()})});
        this.add(new Component[]{new MultiLineLabel("Campagne.mentionLegale", (IModel)new PropertyModel((Object)this.campagneModel, "mentionLegale")).add(new Behavior[]{new ReplaceEmptyLabelBehavior()})});
        this.add(new Component[]{new SimpleTooltipPanel("Campagne.mentionLegale.info", this.getStringModel("Campagne.mentionLegale.info2", new Object[0]))});
        this.add(new Component[]{new MultiLineLabel("Campagne.complement", (IModel)new PropertyModel((Object)this.campagneModel, "complement")).add(new Behavior[]{new ReplaceEmptyLabelBehavior()})});
        this.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
        this.initParticipantsFields(currentPage);
        this.initStationsFields(currentPage);
        ReadListDocumentsPanel readListDocumentsPanel = new ReadListDocumentsPanel("ReadListDocumentsPanel", this.campagneModel, currentPage);
        this.add(new Component[]{readListDocumentsPanel});
        Form formView = new Form("Form");
        2 updateLink = new /* Unavailable Anonymous Inner Class!! */;
        updateLink.setVisibilityAllowed(this.campagneService.updateOrdeleteCampagneEnabled(campagne, this.getSession().getUtilisateur()));
        formView.add(new Component[]{updateLink});
        formView.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
        SubmittableButton deleteButton = new SubmittableButton(ACTION_DELETE, ManageCampagnePage.class, (SubmittableButtonEvents)new /* Unavailable Anonymous Inner Class!! */);
        deleteButton.setVisibilityAllowed(this.campagneService.updateOrdeleteCampagneEnabled(campagne, this.getSession().getUtilisateur()));
        deleteButton.add(new Behavior[]{new JSConfirmationBehavior(this.getStringModel("Confirm", new Object[0]))});
        formView.add(new Component[]{deleteButton});
        this.add(new Component[]{formView});
    }

    private void initParticipantsFields(CallerPage currentPage) {
        5 campagneParticipants = new /* Unavailable Anonymous Inner Class!! */;
        6 tableParticipants = new /* Unavailable Anonymous Inner Class!! */;
        tableParticipants.add(new Component[]{campagneParticipants});
        this.add(new Component[]{tableParticipants});
        7 noTableParticipants = new /* Unavailable Anonymous Inner Class!! */;
        this.add(new Component[]{noTableParticipants});
    }

    private void initStationsFields(CallerPage currentPage) {
        8 tableStations = new /* Unavailable Anonymous Inner Class!! */;
        this.add(new Component[]{tableStations});
        WebMarkupContainer stationsNotAccessiblesCont = new WebMarkupContainer("Campagne.stations.stationsNotAccessibles");
        stationsNotAccessiblesCont.setOutputMarkupPlaceholderTag(true);
        tableStations.add(new Component[]{stationsNotAccessiblesCont});
        9 listStationsModel = new /* Unavailable Anonymous Inner Class!! */;
        10 stationsListView = new /* Unavailable Anonymous Inner Class!! */;
        tableStations.add(new Component[]{stationsListView});
        11 noTableStations = new /* Unavailable Anonymous Inner Class!! */;
        this.add(new Component[]{noTableStations});
    }

    private void redirect() {
        this.callerPage.responsePage((TemplatePage)this);
    }

    static /* synthetic */ void access$000(ReadCampagnePage x0) {
        x0.redirect();
    }

    static /* synthetic */ CampagneService access$100(ReadCampagnePage x0) {
        return x0.campagneService;
    }

    static /* synthetic */ IModel access$200(ReadCampagnePage x0) {
        return x0.campagneModel;
    }

    static /* synthetic */ StationService access$300(ReadCampagnePage x0) {
        return x0.stationService;
    }
}

