/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.web.utils.security;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Locale;
import nc.ird.cantharella.data.config.DataContext;
import nc.ird.cantharella.data.exceptions.DataNotFoundException;
import nc.ird.cantharella.data.model.Utilisateur;
import nc.ird.cantharella.service.services.PersonneService;
import nc.ird.cantharella.web.config.WebApplicationImpl;
import nc.ird.cantharella.web.utils.security.AuthRole;
import nc.ird.module.utils.LogTools;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.protocol.http.WebSession;
import org.apache.wicket.request.Request;
import org.apache.wicket.spring.injection.annot.SpringBean;

public final class AuthSession
extends WebSession
implements Serializable {
    private static final Log LOG = LogTools.getLog();
    private static final String ATTRIBUTE_REMEMBER_ME = "rememberMe";
    private static final String ATTRIBUTE_ROLE = "role";
    private static final String ATTRIBUTE_UTILISATEUR = "utilisateur";
    @SpringBean
    private PersonneService personneService;

    public AuthSession(Request request) {
        super(request);
        WebApplicationImpl.injectSpringBeans((Object)this);
        if (!DataContext.LOCALES.contains(this.getLocale())) {
            this.setLocale(Locale.getDefault());
        }
        this.setAttribute(ATTRIBUTE_ROLE, new HashSet());
        this.setUtilisateur(null);
        if (!this.autologin()) {
            this.logout();
        }
        this.bind();
    }

    private boolean autologin() {
        String[] stringArray = WebApplication.get().getSecuritySettings().getAuthenticationStrategy().load();
        if (stringArray != null && stringArray.length == 2 && !StringUtils.isEmpty((String)stringArray[0]) && !StringUtils.isEmpty((String)stringArray[1]) && this.authenticate(stringArray[0], stringArray[1])) {
            try {
                this.connectUser(this.personneService.loadUtilisateur(stringArray[0]), false);
            }
            catch (DataNotFoundException dataNotFoundException) {
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean authenticate(String string, String string2) {
        LOG.debug((Object)this.personneService.authenticateUtilisateur(string, string2));
        return this.personneService.authenticateUtilisateur(string, string2);
    }

    public Boolean getRememberMe() {
        return (Boolean)this.getAttribute(ATTRIBUTE_REMEMBER_ME);
    }

    public AuthRole getRole() {
        return (AuthRole)this.getAttribute(ATTRIBUTE_ROLE);
    }

    public Utilisateur getUtilisateur() {
        Integer n = (Integer)this.getAttribute(ATTRIBUTE_UTILISATEUR);
        Utilisateur utilisateur = null;
        if (n != null) {
            try {
                utilisateur = this.personneService.loadUtilisateur(n);
            }
            catch (DataNotFoundException dataNotFoundException) {
                this.logout();
            }
            catch (Exception exception) {
                LOG.debug((Object)(exception.getClass() + exception.getMessage()));
                return null;
            }
        }
        return utilisateur;
    }

    public void connectUser(Utilisateur utilisateur, boolean bl) {
        this.setUtilisateur(utilisateur);
        this.setRole(utilisateur.getTypeDroit() == Utilisateur.TypeDroit.UTILISATEUR ? AuthRole.USER : AuthRole.ADMIN);
        this.setRememberMe(Boolean.valueOf(bl));
        if (bl) {
            WebApplication.get().getSecuritySettings().getAuthenticationStrategy().save(utilisateur.getCourriel(), utilisateur.getPasswordHash());
        }
    }

    public void logout() {
        this.setUtilisateur(null);
        this.setRememberMe(Boolean.valueOf(false));
        this.setRole(AuthRole.VISITOR);
        WebApplication.get().getSecuritySettings().getAuthenticationStrategy().remove();
    }

    private void setRememberMe(Boolean bl) {
        this.setAttribute(ATTRIBUTE_REMEMBER_ME, (Serializable)bl);
    }

    private void setRole(AuthRole authRole) {
        this.setAttribute(ATTRIBUTE_ROLE, (Serializable)authRole);
    }

    private void setUtilisateur(Utilisateur utilisateur) {
        this.setAttribute(ATTRIBUTE_UTILISATEUR, (Serializable)(utilisateur != null ? utilisateur.getIdPersonne() : null));
    }

    public void update(Utilisateur utilisateur) {
        this.connectUser(utilisateur, this.getRememberMe().booleanValue());
    }
}

