/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.web.utils.models;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import nc.ird.cantharella.data.config.DataContext;
import nc.ird.cantharella.data.model.utils.AbstractModel;
import nc.ird.cantharella.web.utils.models.GenericLoadableDetachableModel;
import nc.ird.module.utils.AssertTools;
import nc.ird.module.utils.LogTools;
import org.apache.commons.collections.comparators.NullComparator;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.wicket.extensions.markup.html.repeater.util.SortableDataProvider;

public final class LoadableDetachableSortableListDataProvider<M extends AbstractModel>
extends SortableDataProvider<M> {
    private static final Log LOG = LogTools.getLog();
    private final Comparator<Object> comparator;
    private List<M> list;
    private final Locale locale;
    static final String CODE_PAYS_PROPERTY = "codePays";

    public LoadableDetachableSortableListDataProvider(List<M> list, Locale locale) {
        AssertTools.assertNotNull(list);
        AssertTools.assertIn((Object)locale, (Collection)DataContext.LOCALES);
        this.list = list;
        this.locale = locale;
        this.comparator = new NullComparator(true);
    }

    public Iterator<? extends M> iterator(int n, int n2) {
        if (this.getSort() != null && !StringUtils.isEmpty((String)this.getSort().getProperty())) {
            Collections.sort(this.list, new /* Unavailable Anonymous Inner Class!! */);
        }
        return this.list.subList(n, Math.min(n + n2, this.size())).iterator();
    }

    public GenericLoadableDetachableModel<M> model(M m) {
        return new GenericLoadableDetachableModel(m);
    }

    public int size() {
        return this.list.size();
    }

    public List<M> getList() {
        return this.list;
    }

    public void setList(List<M> list) {
        this.list = list;
    }

    static /* synthetic */ Locale access$000(LoadableDetachableSortableListDataProvider loadableDetachableSortableListDataProvider) {
        return loadableDetachableSortableListDataProvider.locale;
    }

    static /* synthetic */ Comparator access$100(LoadableDetachableSortableListDataProvider loadableDetachableSortableListDataProvider) {
        return loadableDetachableSortableListDataProvider.comparator;
    }

    static /* synthetic */ Log access$200() {
        return LOG;
    }
}

