/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.web.utils.models;

import java.io.Serializable;
import nc.ird.cantharella.data.dao.GenericDao;
import nc.ird.cantharella.data.exceptions.UnexpectedException;
import nc.ird.cantharella.data.model.utils.AbstractModel;
import nc.ird.cantharella.web.config.WebApplicationImpl;
import nc.ird.module.utils.AssertTools;
import nc.ird.module.utils.LogTools;
import org.apache.commons.logging.Log;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.spring.injection.annot.SpringBean;

public final class GenericLoadableDetachableModel<M extends AbstractModel>
extends LoadableDetachableModel<M> {
    private static final Log LOG = LogTools.getLog();
    @SpringBean
    private GenericDao dao;
    private final Class<M> modelClass;
    private final Serializable modelID;

    public GenericLoadableDetachableModel(Class<M> clazz, Serializable serializable) {
        AssertTools.assertNotNull(clazz);
        AssertTools.assertNotNull((Object)serializable);
        this.modelClass = clazz;
        this.modelID = serializable;
        WebApplicationImpl.injectSpringBeans((Object)this);
    }

    public GenericLoadableDetachableModel(M m) {
        this(m.getClass(), m.getIdValue());
        this.setObject(m);
    }

    protected M load() {
        try {
            return (M)this.dao.read(this.modelClass, this.modelID);
        }
        catch (Exception exception) {
            LOG.error((Object)exception.getMessage(), (Throwable)exception);
            throw new UnexpectedException(exception);
        }
    }
}

