/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.web.utils.models;

import java.math.RoundingMode;
import java.text.NumberFormat;
import java.util.Locale;
import nc.ird.cantharella.web.utils.models.DisplayDecimalPropertyModel;
import org.apache.wicket.model.PropertyModel;

public class DisplayDecimalPropertyModel
extends PropertyModel<Object> {
    private int NB_DECIMAL_SMALL = 2;
    private Locale locale;
    private DecimalDisplFormat format;

    public DisplayDecimalPropertyModel(Object object, String string, DecimalDisplFormat decimalDisplFormat, Locale locale) {
        super(object, string);
        this.format = decimalDisplFormat;
        this.locale = locale;
    }

    public Object getObject() {
        return this.formatDecimalValue((Number)super.getObject());
    }

    private final NumberFormat getDecimalFormat() {
        int n = this.format == DecimalDisplFormat.SMALL ? this.NB_DECIMAL_SMALL : 4;
        NumberFormat numberFormat = NumberFormat.getNumberInstance(this.locale);
        numberFormat.setMaximumIntegerDigits(5);
        numberFormat.setMaximumFractionDigits(n);
        numberFormat.setMinimumFractionDigits(n);
        numberFormat.setRoundingMode(RoundingMode.HALF_UP);
        return numberFormat;
    }

    private final String formatDecimalValue(Number number) {
        if (number == null) {
            return null;
        }
        return this.getDecimalFormat().format(number);
    }
}

