/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.web.utils.forms;

import nc.ird.cantharella.data.exceptions.UnexpectedException;
import nc.ird.cantharella.web.pages.TemplatePage;
import nc.ird.cantharella.web.utils.forms.SubmittableButtonEvents;
import nc.ird.module.utils.LogTools;
import org.apache.commons.logging.Log;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.model.IModel;

public final class SubmittableButton
extends Button {
    private static final Log LOG = LogTools.getLog();
    private final SubmittableButtonEvents submittable;
    private Class<? extends TemplatePage> specificMsgPage = null;

    public SubmittableButton(String string, Class<? extends TemplatePage> clazz, SubmittableButtonEvents submittableButtonEvents) {
        super(string);
        this.submittable = submittableButtonEvents;
        this.specificMsgPage = clazz;
    }

    public SubmittableButton(String string, IModel<String> iModel, SubmittableButtonEvents submittableButtonEvents) {
        super(string, iModel);
        this.submittable = submittableButtonEvents;
    }

    public SubmittableButton(String string, SubmittableButtonEvents submittableButtonEvents) {
        super(string);
        this.submittable = submittableButtonEvents;
    }

    public void onSubmit() {
        this.submittable.onValidate();
        if (!this.getPage().hasErrorMessage()) {
            try {
                this.submittable.onProcess();
            }
            catch (UnexpectedException unexpectedException) {
                throw unexpectedException;
            }
            catch (RuntimeException runtimeException) {
                LOG.error((Object)runtimeException.getMessage(), (Throwable)runtimeException);
                throw runtimeException;
            }
            catch (Exception exception) {
                if (this.specificMsgPage == null) {
                    ((TemplatePage)this.getPage()).errorCurrentPage(this.getId(), exception);
                }
                ((TemplatePage)this.getPage()).errorCurrentPage(this.specificMsgPage, this.getId(), exception);
            }
        }
        if (this.getPage().hasErrorMessage()) {
            this.submittable.onError();
        } else {
            this.submittable.onSuccess();
        }
    }
}

