/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.web.pages.domain.utilisateur;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import nc.ird.cantharella.data.exceptions.DataNotFoundException;
import nc.ird.cantharella.data.exceptions.UnexpectedException;
import nc.ird.cantharella.data.model.Campagne;
import nc.ird.cantharella.data.model.CampagnePersonneDroits;
import nc.ird.cantharella.data.model.Lot;
import nc.ird.cantharella.data.model.LotPersonneDroits;
import nc.ird.cantharella.data.model.Utilisateur;
import nc.ird.cantharella.data.model.utils.AbstractModel;
import nc.ird.cantharella.data.validation.utils.ModelValidator;
import nc.ird.cantharella.service.services.CampagneService;
import nc.ird.cantharella.service.services.PersonneService;
import nc.ird.cantharella.web.pages.TemplatePage;
import nc.ird.cantharella.web.pages.domain.personne.panels.ManagePersonnePanel;
import nc.ird.cantharella.web.pages.model.ManageUtilisateurModel;
import nc.ird.cantharella.web.utils.CallerPage;
import nc.ird.cantharella.web.utils.behaviors.JSConfirmationBehavior;
import nc.ird.cantharella.web.utils.forms.SubmittableButton;
import nc.ird.cantharella.web.utils.forms.SubmittableButtonEvents;
import nc.ird.cantharella.web.utils.renderers.EnumChoiceRenderer;
import nc.ird.cantharella.web.utils.security.AuthRole;
import nc.ird.cantharella.web.utils.security.AuthRoles;
import nc.ird.module.utils.BeanTools;
import nc.ird.module.utils.CollectionTools;
import nc.ird.module.utils.LogTools;
import org.apache.commons.collections.comparators.ComparatorChain;
import org.apache.commons.logging.Log;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.AbstractSingleSelectChoice;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.RadioChoice;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.spring.injection.annot.SpringBean;

@AuthRoles(value={AuthRole.ADMIN})
public final class ManageUtilisateurPage
extends TemplatePage {
    public static final String ACTION_DELETE = "Delete";
    public static final String ACTION_REJECT = "Reject";
    private static final String ACTION_UPDATE = "Update";
    public static final String ACTION_VALID = "Valid";
    private static final Log LOG = LogTools.getLog();
    private final Button addAuthorization;
    private final AbstractSingleSelectChoice<Campagne> availableCampagnes;
    private final AbstractSingleSelectChoice<Lot> availableLots;
    private final IModel<CampagnePersonneDroits> campagnePersonneDroitsModel;
    private final List<Campagne> campagnes;
    @SpringBean
    private CampagneService campagneService;
    private final IModel<LotPersonneDroits> lotsPersonneDroitsModel;
    private final IModel<ManageUtilisateurModel> manageUtilisateurModel;
    @SpringBean
    private PersonneService personneService;
    private final IModel<Utilisateur> utilisateurModel;
    @SpringBean(name="webModelValidator")
    private ModelValidator validator;

    public ManageUtilisateurPage(Integer n, CallerPage callerPage) {
        super(ManageUtilisateurPage.class);
        try {
            this.utilisateurModel = new Model((Serializable)this.personneService.loadUtilisateur(n));
        }
        catch (DataNotFoundException dataNotFoundException) {
            LOG.error((Object)dataNotFoundException.getMessage(), (Throwable)dataNotFoundException);
            throw new UnexpectedException((Exception)((Object)dataNotFoundException));
        }
        this.manageUtilisateurModel = new Model((Serializable)new ManageUtilisateurModel());
        ((ManageUtilisateurModel)this.manageUtilisateurModel.getObject()).setCampagnesDroits(((Utilisateur)this.utilisateurModel.getObject()).getCampagnesDroits());
        ((ManageUtilisateurModel)this.manageUtilisateurModel.getObject()).getCampagnes().addAll(((Utilisateur)this.utilisateurModel.getObject()).getCampagnesDroits().keySet());
        ((ManageUtilisateurModel)this.manageUtilisateurModel.getObject()).setLotsDroits(((Utilisateur)this.utilisateurModel.getObject()).getLotsDroits());
        ((ManageUtilisateurModel)this.manageUtilisateurModel.getObject()).getLots().addAll(((Utilisateur)this.utilisateurModel.getObject()).getLotsDroits().keySet());
        this.campagnePersonneDroitsModel = new Model((Serializable)new CampagnePersonneDroits());
        ((CampagnePersonneDroits)this.campagnePersonneDroitsModel.getObject()).getId().setPk2((AbstractModel)this.utilisateurModel.getObject());
        ((CampagnePersonneDroits)this.campagnePersonneDroitsModel.getObject()).getDroits().setDroitExtrait(Boolean.TRUE);
        ((CampagnePersonneDroits)this.campagnePersonneDroitsModel.getObject()).getDroits().setDroitPuri(Boolean.TRUE);
        ((CampagnePersonneDroits)this.campagnePersonneDroitsModel.getObject()).getDroits().setDroitRecolte(Boolean.TRUE);
        ((CampagnePersonneDroits)this.campagnePersonneDroitsModel.getObject()).getDroits().setDroitTestBio(Boolean.TRUE);
        this.lotsPersonneDroitsModel = new Model((Serializable)new LotPersonneDroits());
        ((LotPersonneDroits)this.lotsPersonneDroitsModel.getObject()).getId().setPk2((AbstractModel)this.utilisateurModel.getObject());
        ((LotPersonneDroits)this.lotsPersonneDroitsModel.getObject()).getDroits().setDroitExtrait(Boolean.TRUE);
        ((LotPersonneDroits)this.lotsPersonneDroitsModel.getObject()).getDroits().setDroitPuri(Boolean.TRUE);
        ((LotPersonneDroits)this.lotsPersonneDroitsModel.getObject()).getDroits().setDroitRecolte(Boolean.TRUE);
        ((LotPersonneDroits)this.lotsPersonneDroitsModel.getObject()).getDroits().setDroitTestBio(Boolean.TRUE);
        this.campagnes = Collections.unmodifiableList(this.campagneService.listCampagnes(this.getSession().getUtilisateur()));
        Form form = new Form("Form");
        ManagePersonnePanel managePersonnePanel = new ManagePersonnePanel("ManagePersonnePanel", this.utilisateurModel);
        form.add(new Component[]{managePersonnePanel});
        form.add(new Component[]{new RadioChoice("Utilisateur.typeDroit", (IModel)new PropertyModel((Object)this.utilisateurModel, "typeDroit"), Arrays.asList(Utilisateur.TypeDroit.values()), (IChoiceRenderer)new EnumChoiceRenderer((TemplatePage)this))});
        WebMarkupContainer webMarkupContainer = new WebMarkupContainer(this.getResource() + ".Authorizations.Campagnes.Table");
        webMarkupContainer.setOutputMarkupId(true);
        webMarkupContainer.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
        webMarkupContainer.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
        this.availableCampagnes = new DropDownChoice(this.getResource() + ".Authorizations.Campagnes.Campagne", (IModel)new PropertyModel((Object)this.campagnePersonneDroitsModel, "id.pk1"), new ArrayList());
        this.availableCampagnes.add(new Behavior[]{new /* Unavailable Anonymous Inner Class!! */});
        webMarkupContainer.add(new Component[]{this.availableCampagnes});
        this.availableLots = new DropDownChoice(this.getResource() + ".Authorizations.Campagnes.Lot", (IModel)new PropertyModel((Object)this.lotsPersonneDroitsModel, "id.pk1"), new ArrayList());
        this.availableLots.setOutputMarkupId(true);
        webMarkupContainer.add(new Component[]{this.availableLots});
        this.addAuthorization = new /* Unavailable Anonymous Inner Class!! */;
        webMarkupContainer.add(new Component[]{this.addAuthorization});
        this.updateAvailableCampagnes();
        form.add(new Component[]{webMarkupContainer});
        SubmittableButton submittableButton = new SubmittableButton(ACTION_UPDATE, (SubmittableButtonEvents)new /* Unavailable Anonymous Inner Class!! */);
        submittableButton.setVisibilityAllowed(this.utilisateurEstValide());
        form.add(new Component[]{submittableButton});
        SubmittableButton submittableButton2 = new SubmittableButton(ACTION_VALID, (SubmittableButtonEvents)new /* Unavailable Anonymous Inner Class!! */);
        submittableButton2.setVisibilityAllowed(!this.utilisateurEstValide());
        form.add(new Component[]{submittableButton2});
        SubmittableButton submittableButton3 = new SubmittableButton(ACTION_DELETE, (SubmittableButtonEvents)new /* Unavailable Anonymous Inner Class!! */);
        submittableButton3.setVisibilityAllowed(this.utilisateurEstValide() && this.getSession().getUtilisateur().getIdPersonne() != ((Utilisateur)this.utilisateurModel.getObject()).getIdPersonne());
        submittableButton3.setDefaultFormProcessing(false);
        submittableButton3.add(new Behavior[]{new JSConfirmationBehavior(this.getString("Confirm"))});
        form.add(new Component[]{submittableButton3});
        SubmittableButton submittableButton4 = new SubmittableButton(ACTION_REJECT, (SubmittableButtonEvents)new /* Unavailable Anonymous Inner Class!! */);
        submittableButton4.setVisibilityAllowed(!this.utilisateurEstValide());
        submittableButton4.setDefaultFormProcessing(false);
        submittableButton4.add(new Behavior[]{new JSConfirmationBehavior(this.getString("Confirm"))});
        form.add(new Component[]{submittableButton4});
        form.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
        this.add(new Component[]{form});
    }

    private void updateAvailableCampagnes() {
        CollectionTools.setter((Collection)((ManageUtilisateurModel)this.manageUtilisateurModel.getObject()).getCampagnes(), ((ManageUtilisateurModel)this.manageUtilisateurModel.getObject()).getCampagnesDroits().keySet());
        Collections.sort(((ManageUtilisateurModel)this.manageUtilisateurModel.getObject()).getCampagnes(), BeanTools.createPropertyComparator((String)"nom"));
        CollectionTools.setter((Collection)((ManageUtilisateurModel)this.manageUtilisateurModel.getObject()).getLots(), ((ManageUtilisateurModel)this.manageUtilisateurModel.getObject()).getLotsDroits().keySet());
        ComparatorChain comparatorChain = new ComparatorChain(BeanTools.createPropertyComparator((String)"campagne.nom"));
        comparatorChain.addComparator(BeanTools.createPropertyComparator((String)"ref"));
        Collections.sort(((ManageUtilisateurModel)this.manageUtilisateurModel.getObject()).getLots(), comparatorChain);
        ArrayList arrayList = new ArrayList(this.campagnes);
        CollectionTools.removeAllWithValue(arrayList, (String)"nom", (BeanTools.AccessType)BeanTools.AccessType.GETTER, (Collection)CollectionTools.valuesFromList((Collection)((ManageUtilisateurModel)this.manageUtilisateurModel.getObject()).getCampagnes(), (String)"nom", (BeanTools.AccessType)BeanTools.AccessType.GETTER));
        this.availableCampagnes.setChoices(arrayList);
        ((CampagnePersonneDroits)this.campagnePersonneDroitsModel.getObject()).getId().setPk1(arrayList.isEmpty() ? null : (Campagne)this.availableCampagnes.getModelObject());
        this.availableCampagnes.setEnabled(!arrayList.isEmpty());
        ArrayList arrayList2 = new ArrayList();
        this.availableLots.setEnabled(((CampagnePersonneDroits)this.campagnePersonneDroitsModel.getObject()).getId().getPk1() != null);
        if (this.availableLots.isEnabled()) {
            this.campagneService.refreshCampagne((Campagne)((CampagnePersonneDroits)this.campagnePersonneDroitsModel.getObject()).getId().getPk1());
            arrayList2.addAll(((Campagne)((CampagnePersonneDroits)this.campagnePersonneDroitsModel.getObject()).getId().getPk1()).getLots());
            CollectionTools.removeAllWithValue(arrayList2, (String)"ref", (BeanTools.AccessType)BeanTools.AccessType.GETTER, (Collection)CollectionTools.valuesFromList((Collection)((ManageUtilisateurModel)this.manageUtilisateurModel.getObject()).getLots(), (String)"ref", (BeanTools.AccessType)BeanTools.AccessType.GETTER));
            this.availableLots.setChoices(arrayList2);
        }
        ((LotPersonneDroits)this.lotsPersonneDroitsModel.getObject()).getId().setPk1(null);
        this.addAuthorization.setEnabled(!arrayList.isEmpty());
    }

    private boolean utilisateurEstValide() {
        return ((Utilisateur)this.utilisateurModel.getObject()).isValide();
    }

    static /* synthetic */ String access$000(ManageUtilisateurPage manageUtilisateurPage) {
        return manageUtilisateurPage.getResource();
    }

    static /* synthetic */ IModel access$100(ManageUtilisateurPage manageUtilisateurPage) {
        return manageUtilisateurPage.manageUtilisateurModel;
    }

    static /* synthetic */ void access$200(ManageUtilisateurPage manageUtilisateurPage) {
        manageUtilisateurPage.updateAvailableCampagnes();
    }

    static /* synthetic */ String access$300(ManageUtilisateurPage manageUtilisateurPage) {
        return manageUtilisateurPage.getResource();
    }

    static /* synthetic */ String access$400(ManageUtilisateurPage manageUtilisateurPage) {
        return manageUtilisateurPage.getResource();
    }

    static /* synthetic */ AbstractSingleSelectChoice access$500(ManageUtilisateurPage manageUtilisateurPage) {
        return manageUtilisateurPage.availableLots;
    }

    static /* synthetic */ IModel access$600(ManageUtilisateurPage manageUtilisateurPage) {
        return manageUtilisateurPage.campagnePersonneDroitsModel;
    }

    static /* synthetic */ IModel access$700(ManageUtilisateurPage manageUtilisateurPage) {
        return manageUtilisateurPage.lotsPersonneDroitsModel;
    }

    static /* synthetic */ Log access$800() {
        return LOG;
    }

    static /* synthetic */ CampagneService access$900(ManageUtilisateurPage manageUtilisateurPage) {
        return manageUtilisateurPage.campagneService;
    }

    static /* synthetic */ void access$1000(ManageUtilisateurPage manageUtilisateurPage, AjaxRequestTarget ajaxRequestTarget) {
        manageUtilisateurPage.refreshFeedbackPage(ajaxRequestTarget);
    }

    static /* synthetic */ IModel access$1100(ManageUtilisateurPage manageUtilisateurPage) {
        return manageUtilisateurPage.utilisateurModel;
    }

    static /* synthetic */ PersonneService access$1200(ManageUtilisateurPage manageUtilisateurPage) {
        return manageUtilisateurPage.personneService;
    }

    static /* synthetic */ ModelValidator access$1300(ManageUtilisateurPage manageUtilisateurPage) {
        return manageUtilisateurPage.validator;
    }
}

