/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.web.pages.domain.testBio;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import nc.ird.cantharella.data.exceptions.DataNotFoundException;
import nc.ird.cantharella.data.exceptions.UnexpectedException;
import nc.ird.cantharella.data.model.ErreurTestBio;
import nc.ird.cantharella.data.model.MethodeTestBio;
import nc.ird.cantharella.data.model.Personne;
import nc.ird.cantharella.data.model.Produit;
import nc.ird.cantharella.data.model.ResultatTestBio;
import nc.ird.cantharella.data.model.TestBio;
import nc.ird.cantharella.data.validation.utils.ModelValidator;
import nc.ird.cantharella.service.services.PersonneService;
import nc.ird.cantharella.service.services.ProduitService;
import nc.ird.cantharella.service.services.TestBioService;
import nc.ird.cantharella.web.pages.TemplatePage;
import nc.ird.cantharella.web.pages.domain.testBio.ManageTestBioPage;
import nc.ird.cantharella.web.pages.renderers.PersonneRenderer;
import nc.ird.cantharella.web.utils.CallerPage;
import nc.ird.cantharella.web.utils.behaviors.JSConfirmationBehavior;
import nc.ird.cantharella.web.utils.forms.AutoCompleteTextFieldString;
import nc.ird.cantharella.web.utils.forms.SubmittableButton;
import nc.ird.cantharella.web.utils.forms.SubmittableButtonEvents;
import nc.ird.cantharella.web.utils.panels.SimpleTooltipPanel;
import nc.ird.cantharella.web.utils.renderers.EnumChoiceRenderer;
import nc.ird.cantharella.web.utils.security.AuthRole;
import nc.ird.cantharella.web.utils.security.AuthRoles;
import nc.ird.module.utils.BeanTools;
import nc.ird.module.utils.CollectionTools;
import nc.ird.module.utils.LogTools;
import org.apache.commons.logging.Log;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Page;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.markup.html.form.DateTextField;
import org.apache.wicket.extensions.yui.calendar.DatePicker;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.basic.MultiLineLabel;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.IFormSubmittingComponent;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.apache.wicket.util.string.StringValueConversionException;

@AuthRoles(value={AuthRole.ADMIN, AuthRole.USER})
public final class ManageTestBioPage
extends TemplatePage {
    private static final Log LOG = LogTools.getLog();
    private static final String ACTION_CREATE = "Create";
    private static final String ACTION_UPDATE = "Update";
    public static final String ACTION_DELETE = "Delete";
    private final IModel<TestBio> testBioModel;
    private Model<ResultatTestBio> newResultatModel;
    @SpringBean
    private TestBioService testBioService;
    @SpringBean
    private PersonneService personneService;
    @SpringBean
    private ProduitService produitService;
    private final List<Personne> personnes;
    private final List<MethodeTestBio> methodes;
    private final List<String> organismes;
    private final List<String> produitsTemoins;
    private final List<Produit> produits;
    private final List<ErreurTestBio> erreurs;
    @SpringBean(name="webModelValidator")
    private ModelValidator validator;
    private final CallerPage callerPage;
    private boolean multipleEntry;
    Button addResultatButton;
    MarkupContainer descriptionMethoContainer;
    MarkupContainer paramsMethoContainer;
    TextField<BigDecimal> concMasseDefautInput;
    DropDownChoice<ResultatTestBio.UniteConcMasse> uniteConcMasseDefautInput;
    TextField<BigInteger> concMasseInput;
    DropDownChoice<ResultatTestBio.UniteConcMasse> uniteConcMasseInput;
    DropDownChoice<ResultatTestBio.Stade> stadeInput;

    public ManageTestBioPage(CallerPage callerPage, boolean bl) {
        this(null, null, callerPage, bl);
    }

    public ManageTestBioPage(Integer n, CallerPage callerPage) {
        this(n, null, callerPage, false);
    }

    public ManageTestBioPage(TestBio testBio, CallerPage callerPage) {
        this(null, testBio, callerPage, true);
    }

    private ManageTestBioPage(Integer n, TestBio testBio, CallerPage callerPage, boolean bl) {
        super(ManageTestBioPage.class);
        boolean bl2;
        assert (n == null || testBio == null);
        this.callerPage = callerPage;
        this.multipleEntry = bl;
        this.newResultatModel = new Model((Serializable)new ResultatTestBio());
        try {
            this.testBioModel = new Model((Serializable)(n == null && testBio == null ? new TestBio() : (testBio != null ? testBio : this.testBioService.loadTestBio(n))));
        }
        catch (DataNotFoundException dataNotFoundException) {
            LOG.error((Object)dataNotFoundException.getMessage(), (Throwable)dataNotFoundException);
            throw new UnexpectedException((Exception)((Object)dataNotFoundException));
        }
        boolean bl3 = bl2 = n == null;
        if (bl2) {
            ((TestBio)this.testBioModel.getObject()).setCreateur((Personne)this.getSession().getUtilisateur());
        }
        this.personnes = this.personneService.listPersonnes();
        this.methodes = this.testBioService.listMethodesTestBio();
        this.produits = this.produitService.listProduits(this.getSession().getUtilisateur());
        this.erreurs = this.testBioService.listErreursTestBio();
        if (testBio != null) {
            ((TestBio)this.testBioModel.getObject()).setManipulateur((Personne)CollectionTools.findWithValue((List)this.personnes, (String)"idPersonne", (BeanTools.AccessType)BeanTools.AccessType.GETTER, (Object)((TestBio)this.testBioModel.getObject()).getManipulateur().getIdPersonne()));
            ((TestBio)this.testBioModel.getObject()).setMethode((MethodeTestBio)CollectionTools.findWithValue((List)this.methodes, (String)"idMethodeTest", (BeanTools.AccessType)BeanTools.AccessType.GETTER, (Object)((TestBio)this.testBioModel.getObject()).getMethode().getIdMethodeTest()));
        }
        this.organismes = this.personneService.listPersonneOrganismes();
        this.produitsTemoins = this.testBioService.listProduitsTemoins();
        Form form = new Form("Form");
        this.initPrincipalFields(form);
        this.initMethodeFields(form);
        this.initResultatsFields(form);
        SubmittableButton submittableButton = new SubmittableButton(ACTION_CREATE, (SubmittableButtonEvents)new /* Unavailable Anonymous Inner Class!! */);
        submittableButton.setVisibilityAllowed(bl2);
        form.add(new Component[]{submittableButton});
        SubmittableButton submittableButton2 = new SubmittableButton(ACTION_UPDATE, (SubmittableButtonEvents)new /* Unavailable Anonymous Inner Class!! */);
        submittableButton2.setVisibilityAllowed(!bl2);
        form.add(new Component[]{submittableButton2});
        SubmittableButton submittableButton3 = new SubmittableButton(ACTION_DELETE, (SubmittableButtonEvents)new /* Unavailable Anonymous Inner Class!! */);
        submittableButton3.setVisibilityAllowed(!bl2);
        submittableButton3.setDefaultFormProcessing(false);
        submittableButton3.add(new Behavior[]{new JSConfirmationBehavior(this.getString("Confirm"))});
        form.add(new Component[]{submittableButton3});
        form.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
        form.setDefaultButton((IFormSubmittingComponent)this.addResultatButton);
        this.add(new Component[]{form});
    }

    private void initPrincipalFields(Form<Void> form) {
        form.add(new Component[]{new TextField("TestBio.ref", (IModel)new PropertyModel((Object)this.testBioModel, "ref"))});
        form.add(new Component[]{new DropDownChoice("TestBio.manipulateur", (IModel)new PropertyModel((Object)this.testBioModel, "manipulateur"), this.personnes, (IChoiceRenderer)new PersonneRenderer()).setNullValid(false)});
        form.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
        form.add(new Component[]{new AutoCompleteTextFieldString("TestBio.organismeTesteur", (IModel)new PropertyModel((Object)this.testBioModel, "organismeTesteur"), this.organismes, AutoCompleteTextFieldString.ComparisonMode.CONTAINS)});
        form.add(new Component[]{new DateTextField("TestBio.date", (IModel)new PropertyModel((Object)this.testBioModel, "date")).add(new Behavior[]{new DatePicker()})});
        this.concMasseDefautInput = new TextField("TestBio.concMasseDefaut", (IModel)new PropertyModel((Object)this.testBioModel, "concMasseDefaut"));
        this.concMasseDefautInput.add(new Behavior[]{new /* Unavailable Anonymous Inner Class!! */});
        form.add(new Component[]{this.concMasseDefautInput});
        this.uniteConcMasseDefautInput = new DropDownChoice("TestBio.uniteConcMasseDefaut", (IModel)new PropertyModel((Object)this.testBioModel, "uniteConcMasseDefaut"), Arrays.asList(ResultatTestBio.UniteConcMasse.values()), (IChoiceRenderer)new EnumChoiceRenderer((TemplatePage)this));
        this.uniteConcMasseDefautInput.setNullValid(true);
        this.uniteConcMasseDefautInput.add(new Behavior[]{new /* Unavailable Anonymous Inner Class!! */});
        form.add(new Component[]{this.uniteConcMasseDefautInput});
        DropDownChoice dropDownChoice = new DropDownChoice("TestBio.stadeDefaut", (IModel)new PropertyModel((Object)this.testBioModel, "stadeDefaut"), Arrays.asList(ResultatTestBio.Stade.values()), (IChoiceRenderer)new EnumChoiceRenderer((TemplatePage)this));
        dropDownChoice.setNullValid(true);
        dropDownChoice.add(new Behavior[]{new /* Unavailable Anonymous Inner Class!! */});
        form.add(new Component[]{dropDownChoice});
        form.add(new Component[]{new TextArea("TestBio.complement", (IModel)new PropertyModel((Object)this.testBioModel, "complement"))});
        form.add(new Component[]{new TextField("TestBio.createur", (IModel)new PropertyModel((Object)this.testBioModel, "createur")).setEnabled(false)});
    }

    private void initMethodeFields(Form<Void> form) {
        WebMarkupContainer webMarkupContainer = new WebMarkupContainer("TestBio.methode");
        webMarkupContainer.setOutputMarkupId(true);
        form.add(new Component[]{webMarkupContainer});
        this.descriptionMethoContainer = new /* Unavailable Anonymous Inner Class!! */;
        this.descriptionMethoContainer.setOutputMarkupId(true);
        this.descriptionMethoContainer.setOutputMarkupPlaceholderTag(true);
        webMarkupContainer.add(new Component[]{this.descriptionMethoContainer});
        Label label = new Label("TestBio.cibleMethode", (IModel)new PropertyModel((Object)this.testBioModel, "methode.cible"));
        this.descriptionMethoContainer.add(new Component[]{label});
        Label label2 = new Label("TestBio.domaineMethode", (IModel)new PropertyModel((Object)this.testBioModel, "methode.domaine"));
        this.descriptionMethoContainer.add(new Component[]{label2});
        MultiLineLabel multiLineLabel = new MultiLineLabel("TestBio.descriptionMethode", (IModel)new PropertyModel((Object)this.testBioModel, "methode.description"));
        this.descriptionMethoContainer.add(new Component[]{multiLineLabel});
        Label label3 = new Label("TestBio.valeurMesureeMethode", (IModel)new PropertyModel((Object)this.testBioModel, "methode.valeurMesuree"));
        this.descriptionMethoContainer.add(new Component[]{label3});
        Label label4 = new Label("TestBio.critereActiviteMethode", (IModel)new PropertyModel((Object)this.testBioModel, "methode.critereActivite"));
        this.descriptionMethoContainer.add(new Component[]{label4});
        Label label5 = new Label("TestBio.uniteResultatMethode", (IModel)new PropertyModel((Object)this.testBioModel, "methode.uniteResultat"));
        this.descriptionMethoContainer.add(new Component[]{label5});
        DropDownChoice dropDownChoice = new DropDownChoice("TestBio.nomMethode", (IModel)new PropertyModel((Object)this.testBioModel, "methode"), this.methodes);
        dropDownChoice.setNullValid(false);
        dropDownChoice.add(new Behavior[]{new /* Unavailable Anonymous Inner Class!! */});
        webMarkupContainer.add(new Component[]{dropDownChoice});
    }

    private void initResultatsFields(Form<Void> form) {
        WebMarkupContainer webMarkupContainer = new WebMarkupContainer("TestBio.resultats.Table");
        webMarkupContainer.setOutputMarkupId(true);
        webMarkupContainer.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
        webMarkupContainer.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
        13 var3_3 = new /* Unavailable Anonymous Inner Class!! */;
        var3_3.setNullValid(false);
        webMarkupContainer.add(new Component[]{var3_3});
        14 var4_4 = new /* Unavailable Anonymous Inner Class!! */;
        var4_4.setOutputMarkupId(true);
        var4_4.setOutputMarkupPlaceholderTag(true);
        webMarkupContainer.add(new Component[]{var4_4});
        15 var5_5 = new /* Unavailable Anonymous Inner Class!! */;
        var5_5.setOutputMarkupId(true);
        var5_5.setOutputMarkupPlaceholderTag(true);
        webMarkupContainer.add(new Component[]{var5_5});
        this.concMasseInput = new TextField("TestBio.resultats.concMasse", (IModel)new PropertyModel((Object)this.newResultatModel, "concMasse"));
        this.concMasseInput.setOutputMarkupId(true);
        this.concMasseInput.setOutputMarkupPlaceholderTag(true);
        webMarkupContainer.add(new Component[]{this.concMasseInput});
        this.uniteConcMasseInput = new DropDownChoice("TestBio.resultats.uniteConcMasse", (IModel)new PropertyModel((Object)this.newResultatModel, "uniteConcMasse"), Arrays.asList(ResultatTestBio.UniteConcMasse.values()), (IChoiceRenderer)new EnumChoiceRenderer((TemplatePage)this));
        this.uniteConcMasseInput.setOutputMarkupId(true);
        this.uniteConcMasseInput.setOutputMarkupPlaceholderTag(true);
        this.uniteConcMasseInput.setNullValid(true);
        webMarkupContainer.add(new Component[]{this.uniteConcMasseInput});
        this.stadeInput = new /* Unavailable Anonymous Inner Class!! */;
        this.stadeInput.setOutputMarkupId(true);
        this.stadeInput.setOutputMarkupPlaceholderTag(true);
        webMarkupContainer.add(new Component[]{this.stadeInput});
        webMarkupContainer.add(new Component[]{new CheckBox("TestBio.resultats.actif", (IModel)new PropertyModel((Object)this.newResultatModel, "actif"))});
        DropDownChoice dropDownChoice = new DropDownChoice("TestBio.resultats.erreur", (IModel)new PropertyModel((Object)this.newResultatModel, "erreur"), this.erreurs);
        dropDownChoice.setNullValid(true);
        webMarkupContainer.add(new Component[]{dropDownChoice});
        SimpleTooltipPanel simpleTooltipPanel = new SimpleTooltipPanel("TestBio.resultats.erreur.info", (IModel)new PropertyModel((Object)this.newResultatModel, "erreur.description"));
        simpleTooltipPanel.setVisibilityAllowed(false);
        simpleTooltipPanel.setOutputMarkupId(true);
        simpleTooltipPanel.setOutputMarkupPlaceholderTag(true);
        webMarkupContainer.add(new Component[]{simpleTooltipPanel});
        17 var8_8 = new /* Unavailable Anonymous Inner Class!! */;
        var8_8.setOutputMarkupId(true);
        var8_8.setOutputMarkupPlaceholderTag(true);
        webMarkupContainer.add(new Component[]{var8_8});
        var3_3.add(new Behavior[]{new /* Unavailable Anonymous Inner Class!! */});
        dropDownChoice.add(new Behavior[]{new /* Unavailable Anonymous Inner Class!! */});
        this.addResultatButton = new /* Unavailable Anonymous Inner Class!! */;
        webMarkupContainer.add(new Component[]{this.addResultatButton});
        form.add(new Component[]{webMarkupContainer});
        ((ResultatTestBio)this.newResultatModel.getObject()).setTypeResultat(ResultatTestBio.TypeResultat.PRODUIT);
        this.activeInputsForProduitType((DropDownChoice)var4_4, (TextField)var5_5, this.concMasseInput, this.uniteConcMasseInput, this.stadeInput, false, null);
    }

    protected void onBeforeRender() {
        this.refreshModel();
        super.onBeforeRender();
    }

    private void redirect() {
        if (this.multipleEntry) {
            TestBio testBio = new TestBio();
            testBio.setManipulateur(((TestBio)this.testBioModel.getObject()).getManipulateur());
            testBio.setOrganismeTesteur(((TestBio)this.testBioModel.getObject()).getOrganismeTesteur());
            testBio.setMethode(((TestBio)this.testBioModel.getObject()).getMethode());
            this.setResponsePage((Page)new ManageTestBioPage(testBio, this.callerPage));
        } else if (this.callerPage != null) {
            this.callerPage.addPageParameter(TestBio.class.getSimpleName(), this.testBioModel.getObject());
            this.callerPage.responsePage((TemplatePage)this);
        }
    }

    private void refreshModel() {
        String string = Personne.class.getSimpleName();
        if (this.getPageParameters().getNamedKeys().contains(string)) {
            CollectionTools.setter((Collection)this.personnes, (Collection)this.personneService.listPersonnes());
            try {
                Personne personne = this.personneService.loadPersonne(Integer.valueOf(this.getPageParameters().get(string).toInt()));
                ((TestBio)this.testBioModel.getObject()).setManipulateur(personne);
            }
            catch (StringValueConversionException stringValueConversionException) {
                LOG.error((Object)stringValueConversionException.getMessage(), (Throwable)stringValueConversionException);
                throw new UnexpectedException((Exception)((Object)stringValueConversionException));
            }
            catch (DataNotFoundException dataNotFoundException) {
                LOG.error((Object)dataNotFoundException.getMessage(), (Throwable)dataNotFoundException);
                throw new UnexpectedException((Exception)((Object)dataNotFoundException));
            }
            this.getPageParameters().remove(string);
        }
    }

    private void activeInputsForBlancType(DropDownChoice<Produit> dropDownChoice, TextField<String> textField, TextField<BigInteger> textField2, DropDownChoice<ResultatTestBio.UniteConcMasse> dropDownChoice2, DropDownChoice<ResultatTestBio.Stade> dropDownChoice3, AjaxRequestTarget ajaxRequestTarget) {
        dropDownChoice.setNullValid(true);
        ((ResultatTestBio)this.newResultatModel.getObject()).setProduit(null);
        dropDownChoice.setVisibilityAllowed(false);
        ((ResultatTestBio)this.newResultatModel.getObject()).setProduitTemoin(null);
        textField.setVisibilityAllowed(false);
        ((ResultatTestBio)this.newResultatModel.getObject()).setConcMasse(null);
        textField2.setVisibilityAllowed(false);
        ((ResultatTestBio)this.newResultatModel.getObject()).setUniteConcMasse(null);
        dropDownChoice2.setVisibilityAllowed(false);
        dropDownChoice3.setNullValid(true);
        ((ResultatTestBio)this.newResultatModel.getObject()).setStade(null);
        dropDownChoice3.setVisibilityAllowed(false);
        ajaxRequestTarget.add(new Component[]{dropDownChoice, textField, textField2, dropDownChoice2, dropDownChoice3});
    }

    private void activeInputsForTemoinType(DropDownChoice<Produit> dropDownChoice, TextField<String> textField, TextField<BigInteger> textField2, DropDownChoice<ResultatTestBio.UniteConcMasse> dropDownChoice2, DropDownChoice<ResultatTestBio.Stade> dropDownChoice3, AjaxRequestTarget ajaxRequestTarget) {
        dropDownChoice.setNullValid(true);
        ((ResultatTestBio)this.newResultatModel.getObject()).setProduit(null);
        dropDownChoice.setVisibilityAllowed(false);
        dropDownChoice3.setNullValid(true);
        ((ResultatTestBio)this.newResultatModel.getObject()).setStade(null);
        dropDownChoice3.setVisibilityAllowed(false);
        textField.setVisibilityAllowed(true);
        ((ResultatTestBio)this.newResultatModel.getObject()).setConcMasse((BigDecimal)this.concMasseDefautInput.getModelObject());
        textField2.setVisibilityAllowed(true);
        ((ResultatTestBio)this.newResultatModel.getObject()).setUniteConcMasse(((TestBio)this.testBioModel.getObject()).getUniteConcMasseDefaut());
        dropDownChoice2.setVisibilityAllowed(true);
        ajaxRequestTarget.add(new Component[]{dropDownChoice, textField, textField2, dropDownChoice2, dropDownChoice3});
    }

    private void activeInputsForProduitType(DropDownChoice<Produit> dropDownChoice, TextField<String> textField, TextField<BigInteger> textField2, DropDownChoice<ResultatTestBio.UniteConcMasse> dropDownChoice2, DropDownChoice<ResultatTestBio.Stade> dropDownChoice3, boolean bl, AjaxRequestTarget ajaxRequestTarget) {
        ((ResultatTestBio)this.newResultatModel.getObject()).setProduitTemoin(null);
        textField.setVisibilityAllowed(false);
        dropDownChoice.setNullValid(false);
        dropDownChoice.setVisibilityAllowed(true);
        ((ResultatTestBio)this.newResultatModel.getObject()).setConcMasse(((TestBio)this.testBioModel.getObject()).getConcMasseDefaut());
        textField2.setVisibilityAllowed(true);
        ((ResultatTestBio)this.newResultatModel.getObject()).setUniteConcMasse(((TestBio)this.testBioModel.getObject()).getUniteConcMasseDefaut());
        dropDownChoice2.setVisibilityAllowed(true);
        dropDownChoice3.setNullValid(false);
        ((ResultatTestBio)this.newResultatModel.getObject()).setStade(((TestBio)this.testBioModel.getObject()).getStadeDefaut());
        dropDownChoice3.setVisibilityAllowed(true);
        if (bl) {
            ajaxRequestTarget.add(new Component[]{dropDownChoice, textField, textField2, dropDownChoice2, dropDownChoice3});
        }
    }

    private void validateModel() {
        this.addValidationErrors((Collection)this.validator.validate(this.testBioModel.getObject(), this.getSession().getLocale(), new String[0]));
        if (!CollectionTools.containsWithValue((Collection)((TestBio)this.testBioModel.getObject()).getResultats(), (String)"typeResultat", (BeanTools.AccessType)BeanTools.AccessType.GETTER, (Object)ResultatTestBio.TypeResultat.PRODUIT)) {
            this.error((Serializable)((Object)this.getString("TestBio.resultats.noProduit")));
        }
        if (!this.testBioService.isTestBioUnique((TestBio)this.testBioModel.getObject())) {
            this.error((Serializable)((Object)this.getString("TestBio.notUnique")));
        }
    }

    static /* synthetic */ IModel access$000(ManageTestBioPage manageTestBioPage) {
        return manageTestBioPage.testBioModel;
    }

    static /* synthetic */ TestBioService access$100(ManageTestBioPage manageTestBioPage) {
        return manageTestBioPage.testBioService;
    }

    static /* synthetic */ void access$200(ManageTestBioPage manageTestBioPage) {
        manageTestBioPage.redirect();
    }

    static /* synthetic */ void access$300(ManageTestBioPage manageTestBioPage) {
        manageTestBioPage.validateModel();
    }

    static /* synthetic */ Model access$400(ManageTestBioPage manageTestBioPage) {
        return manageTestBioPage.newResultatModel;
    }

    static /* synthetic */ void access$500(ManageTestBioPage manageTestBioPage, AjaxRequestTarget ajaxRequestTarget) {
        manageTestBioPage.refreshFeedbackPage(ajaxRequestTarget);
    }

    static /* synthetic */ void access$600(ManageTestBioPage manageTestBioPage, DropDownChoice dropDownChoice, TextField textField, TextField textField2, DropDownChoice dropDownChoice2, DropDownChoice dropDownChoice3, AjaxRequestTarget ajaxRequestTarget) {
        manageTestBioPage.activeInputsForBlancType(dropDownChoice, textField, textField2, dropDownChoice2, dropDownChoice3, ajaxRequestTarget);
    }

    static /* synthetic */ void access$700(ManageTestBioPage manageTestBioPage, DropDownChoice dropDownChoice, TextField textField, TextField textField2, DropDownChoice dropDownChoice2, DropDownChoice dropDownChoice3, AjaxRequestTarget ajaxRequestTarget) {
        manageTestBioPage.activeInputsForTemoinType(dropDownChoice, textField, textField2, dropDownChoice2, dropDownChoice3, ajaxRequestTarget);
    }

    static /* synthetic */ void access$800(ManageTestBioPage manageTestBioPage, DropDownChoice dropDownChoice, TextField textField, TextField textField2, DropDownChoice dropDownChoice2, DropDownChoice dropDownChoice3, boolean bl, AjaxRequestTarget ajaxRequestTarget) {
        manageTestBioPage.activeInputsForProduitType(dropDownChoice, textField, textField2, dropDownChoice2, dropDownChoice3, bl, ajaxRequestTarget);
    }

    static /* synthetic */ ModelValidator access$900(ManageTestBioPage manageTestBioPage) {
        return manageTestBioPage.validator;
    }

    static /* synthetic */ Log access$1000() {
        return LOG;
    }

    static /* synthetic */ void access$1100(ManageTestBioPage manageTestBioPage, AjaxRequestTarget ajaxRequestTarget) {
        manageTestBioPage.refreshFeedbackPage(ajaxRequestTarget);
    }

    static /* synthetic */ void access$1200(ManageTestBioPage manageTestBioPage, AjaxRequestTarget ajaxRequestTarget) {
        manageTestBioPage.refreshFeedbackPage(ajaxRequestTarget);
    }
}

