/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.web.pages.domain.station;

import java.io.Serializable;
import java.util.Map;
import nc.ird.cantharella.data.config.DataContext;
import nc.ird.cantharella.data.model.Station;
import nc.ird.cantharella.service.services.StationService;
import nc.ird.cantharella.web.config.WebContext;
import nc.ird.cantharella.web.pages.TemplatePage;
import nc.ird.cantharella.web.pages.domain.station.ManageStationPage;
import nc.ird.cantharella.web.pages.domain.station.ReadStationPage;
import nc.ird.cantharella.web.utils.CallerPage;
import nc.ird.cantharella.web.utils.behaviors.JSConfirmationBehavior;
import nc.ird.cantharella.web.utils.behaviors.ReplaceEmptyLabelBehavior;
import nc.ird.cantharella.web.utils.forms.SubmittableButton;
import nc.ird.cantharella.web.utils.forms.SubmittableButtonEvents;
import nc.ird.cantharella.web.utils.models.DisplayMapValuePropertyModel;
import nc.ird.cantharella.web.utils.models.GenericLoadableDetachableModel;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.basic.MultiLineLabel;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.spring.injection.annot.SpringBean;

public final class ReadStationPage
extends TemplatePage {
    public static final String ACTION_DELETE = "Delete";
    private final CallerPage callerPage;
    private final IModel<Station> stationModel;
    @SpringBean
    private StationService stationService;

    public ReadStationPage(Integer n, CallerPage callerPage) {
        super(ReadStationPage.class);
        CallerPage callerPage2 = new CallerPage((TemplatePage)this.getPage());
        this.callerPage = callerPage;
        this.stationModel = new GenericLoadableDetachableModel(Station.class, (Serializable)n);
        Station station = (Station)this.stationModel.getObject();
        this.add(new Component[]{new Label("Station.nom", (IModel)new PropertyModel((Object)this.stationModel, "nom")).add(new Behavior[]{new ReplaceEmptyLabelBehavior()})});
        this.add(new Component[]{new Label("Station.codePays", (IModel)new DisplayMapValuePropertyModel((Object)this.stationModel, "codePays", (Map)WebContext.COUNTRIES.get(this.getSession().getLocale()))).add(new Behavior[]{new ReplaceEmptyLabelBehavior()})});
        this.add(new Component[]{new Label("Station.localite", (IModel)new PropertyModel((Object)this.stationModel, "localite")).add(new Behavior[]{new ReplaceEmptyLabelBehavior()})});
        this.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
        this.add(new Component[]{new MultiLineLabel("Station.complement", (IModel)new PropertyModel((Object)this.stationModel, "complement")).add(new Behavior[]{new ReplaceEmptyLabelBehavior()})});
        this.add(new Component[]{new Label("Station.latitude", (IModel)new PropertyModel((Object)this.stationModel, "latitude")).add(new Behavior[]{new ReplaceEmptyLabelBehavior()})});
        this.add(new Component[]{new Label("Station.longitude", (IModel)new PropertyModel((Object)this.stationModel, "longitude")).add(new Behavior[]{new ReplaceEmptyLabelBehavior()})});
        this.add(new Component[]{new Label("Station.referentiel", (IModel)new DisplayMapValuePropertyModel((Object)this.stationModel, "referentiel", DataContext.REFERENTIELS)).add(new Behavior[]{new ReplaceEmptyLabelBehavior()})});
        Form form = new Form("Form");
        2 var6_6 = new /* Unavailable Anonymous Inner Class!! */;
        var6_6.setVisibilityAllowed(this.stationService.updateOrdeleteStationEnabled(station, this.getSession().getUtilisateur()));
        form.add(new Component[]{var6_6});
        form.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
        SubmittableButton submittableButton = new SubmittableButton(ACTION_DELETE, ManageStationPage.class, (SubmittableButtonEvents)new /* Unavailable Anonymous Inner Class!! */);
        submittableButton.setVisibilityAllowed(this.stationService.updateOrdeleteStationEnabled(station, this.getSession().getUtilisateur()));
        submittableButton.add(new Behavior[]{new JSConfirmationBehavior(this.getString("Confirm"))});
        form.add(new Component[]{submittableButton});
        this.add(new Component[]{form});
    }

    private void redirect() {
        this.callerPage.responsePage((TemplatePage)this);
    }

    static /* synthetic */ void access$000(ReadStationPage readStationPage) {
        readStationPage.redirect();
    }

    static /* synthetic */ StationService access$100(ReadStationPage readStationPage) {
        return readStationPage.stationService;
    }
}

