/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.web.pages.domain.station;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import nc.ird.cantharella.data.config.DataContext;
import nc.ird.cantharella.data.exceptions.DataNotFoundException;
import nc.ird.cantharella.data.exceptions.UnexpectedException;
import nc.ird.cantharella.data.model.Personne;
import nc.ird.cantharella.data.model.Station;
import nc.ird.cantharella.data.validation.utils.ModelValidator;
import nc.ird.cantharella.service.services.StationService;
import nc.ird.cantharella.web.config.WebContext;
import nc.ird.cantharella.web.pages.TemplatePage;
import nc.ird.cantharella.web.pages.model.ManageStationModel;
import nc.ird.cantharella.web.utils.CallerPage;
import nc.ird.cantharella.web.utils.behaviors.JSConfirmationBehavior;
import nc.ird.cantharella.web.utils.forms.AutoCompleteTextFieldString;
import nc.ird.cantharella.web.utils.forms.SubmittableButton;
import nc.ird.cantharella.web.utils.forms.SubmittableButtonEvents;
import nc.ird.cantharella.web.utils.renderers.MapChoiceRenderer;
import nc.ird.cantharella.web.utils.security.AuthRole;
import nc.ird.cantharella.web.utils.security.AuthRoles;
import nc.ird.module.utils.CoordTools;
import nc.ird.module.utils.LogTools;
import org.apache.commons.logging.Log;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.spring.injection.annot.SpringBean;

@AuthRoles(value={AuthRole.ADMIN, AuthRole.USER})
public final class ManageStationPage
extends TemplatePage {
    private static final String ACTION_CREATE = "Create";
    public static final String ACTION_DELETE = "Delete";
    public static final String ACTION_UPDATE = "Update";
    private static final Log LOG = LogTools.getLog();
    private final CallerPage callerPage;
    private boolean multipleEntry;
    private final IModel<ManageStationModel> manageStationModel;
    private final IModel<Station> stationModel;
    @SpringBean
    private StationService stationService;
    @SpringBean(name="webModelValidator")
    private ModelValidator validator;

    public ManageStationPage(CallerPage callerPage, boolean bl) {
        this(null, null, callerPage, bl);
    }

    public ManageStationPage(Integer n, CallerPage callerPage) {
        this(n, null, callerPage, false);
    }

    public ManageStationPage(Station station, CallerPage callerPage) {
        this(null, station, callerPage, true);
    }

    private ManageStationPage(Integer n, Station station, CallerPage callerPage, boolean bl) {
        super(ManageStationPage.class);
        boolean bl2;
        assert (n == null || station == null);
        this.callerPage = callerPage;
        this.multipleEntry = bl;
        this.manageStationModel = new Model((Serializable)new ManageStationModel());
        try {
            this.stationModel = new Model((Serializable)(n == null && station == null ? new Station() : (station != null ? station : this.stationService.loadStation(n))));
        }
        catch (DataNotFoundException dataNotFoundException) {
            LOG.error((Object)dataNotFoundException.getMessage(), (Throwable)dataNotFoundException);
            throw new UnexpectedException((Exception)((Object)dataNotFoundException));
        }
        boolean bl3 = bl2 = n == null;
        if (bl2) {
            ((Station)this.stationModel.getObject()).setCreateur((Personne)this.getSession().getUtilisateur());
            if (station != null) {
                ((ManageStationModel)this.manageStationModel.getObject()).setLatitudeDegrees(CoordTools.latitudeDegrees((String)((Station)this.stationModel.getObject()).getLatitude()));
                ((ManageStationModel)this.manageStationModel.getObject()).setLatitudeOrientation(CoordTools.latitudeOrientation((String)((Station)this.stationModel.getObject()).getLatitude()));
                ((ManageStationModel)this.manageStationModel.getObject()).setLongitudeDegrees(CoordTools.longitudeDegrees((String)((Station)this.stationModel.getObject()).getLongitude()));
                ((ManageStationModel)this.manageStationModel.getObject()).setLongitudeOrientation(CoordTools.longitudeOrientation((String)((Station)this.stationModel.getObject()).getLongitude()));
            }
        } else {
            ((ManageStationModel)this.manageStationModel.getObject()).setLatitudeDegrees(CoordTools.latitudeDegrees((String)((Station)this.stationModel.getObject()).getLatitude()));
            ((ManageStationModel)this.manageStationModel.getObject()).setLatitudeMinutes(CoordTools.latitudeMinutes((String)((Station)this.stationModel.getObject()).getLatitude()));
            ((ManageStationModel)this.manageStationModel.getObject()).setLatitudeOrientation(CoordTools.latitudeOrientation((String)((Station)this.stationModel.getObject()).getLatitude()));
            ((ManageStationModel)this.manageStationModel.getObject()).setLongitudeDegrees(CoordTools.longitudeDegrees((String)((Station)this.stationModel.getObject()).getLongitude()));
            ((ManageStationModel)this.manageStationModel.getObject()).setLongitudeMinutes(CoordTools.longitudeMinutes((String)((Station)this.stationModel.getObject()).getLongitude()));
            ((ManageStationModel)this.manageStationModel.getObject()).setLongitudeOrientation(CoordTools.longitudeOrientation((String)((Station)this.stationModel.getObject()).getLongitude()));
        }
        List list = this.stationService.listStationLocalites();
        Form form = new Form("Form");
        form.add(new Component[]{new TextField("Station.nom", (IModel)new PropertyModel((Object)this.stationModel, "nom"))});
        form.add(new Component[]{new DropDownChoice("Station.codePays", (IModel)new PropertyModel((Object)this.stationModel, "codePays"), (List)WebContext.COUNTRY_CODES.get(this.getSession().getLocale()), (IChoiceRenderer)new MapChoiceRenderer((Map)WebContext.COUNTRIES.get(this.getSession().getLocale())))});
        form.add(new Component[]{new AutoCompleteTextFieldString("Station.localite", (IModel)new PropertyModel((Object)this.stationModel, "localite"), list, AutoCompleteTextFieldString.ComparisonMode.CONTAINS)});
        form.add(new Component[]{new TextArea("Station.complement", (IModel)new PropertyModel((Object)this.stationModel, "complement"))});
        form.add(new Component[]{new TextField("Station.createur", (IModel)new PropertyModel((Object)this.stationModel, "createur")).setEnabled(false)});
        form.add(new Component[]{new TextField("ManageStationModel.latitudeDegrees", (IModel)new PropertyModel((Object)this.manageStationModel, "latitudeDegrees"))});
        form.add(new Component[]{new Label("Coordonnate.degrees.latitude", String.valueOf('\u00b0'))});
        form.add(new Component[]{new TextField("ManageStationModel.latitudeMinutes", (IModel)new PropertyModel((Object)this.manageStationModel, "latitudeMinutes"))});
        form.add(new Component[]{new Label("Coordonnate.minutes.latitude", String.valueOf('\''))});
        form.add(new Component[]{new DropDownChoice("ManageStationModel.latitudeOrientation", (IModel)new PropertyModel((Object)this.manageStationModel, "latitudeOrientation"), Arrays.asList(CoordTools.LATITUDE_ORIENTATIONS))});
        form.add(new Component[]{new TextField("ManageStationModel.longitudeDegrees", (IModel)new PropertyModel((Object)this.manageStationModel, "longitudeDegrees"))});
        form.add(new Component[]{new Label("Coordonnate.degrees.longitude", String.valueOf('\u00b0'))});
        form.add(new Component[]{new TextField("ManageStationModel.longitudeMinutes", (IModel)new PropertyModel((Object)this.manageStationModel, "longitudeMinutes"))});
        form.add(new Component[]{new Label("Coordonnate.minutes.longitude", String.valueOf('\''))});
        form.add(new Component[]{new DropDownChoice("ManageStationModel.longitudeOrientation", (IModel)new PropertyModel((Object)this.manageStationModel, "longitudeOrientation"), Arrays.asList(CoordTools.LONGITUDE_ORIENTATIONS))});
        form.add(new Component[]{new DropDownChoice("Station.referentiel", (IModel)new PropertyModel((Object)this.stationModel, "referentiel"), WebContext.REFERENTIEL_CODES, (IChoiceRenderer)new MapChoiceRenderer(DataContext.REFERENTIELS))});
        SubmittableButton submittableButton = new SubmittableButton(ACTION_CREATE, (SubmittableButtonEvents)new /* Unavailable Anonymous Inner Class!! */);
        submittableButton.setVisibilityAllowed(bl2);
        form.add(new Component[]{submittableButton});
        SubmittableButton submittableButton2 = new SubmittableButton(ACTION_UPDATE, (SubmittableButtonEvents)new /* Unavailable Anonymous Inner Class!! */);
        submittableButton2.setVisibilityAllowed(!bl2 && this.stationService.updateOrdeleteStationEnabled((Station)this.stationModel.getObject(), this.getSession().getUtilisateur()));
        form.add(new Component[]{submittableButton2});
        SubmittableButton submittableButton3 = new SubmittableButton(ACTION_DELETE, (SubmittableButtonEvents)new /* Unavailable Anonymous Inner Class!! */);
        submittableButton3.setVisibilityAllowed(!bl2 && this.stationService.updateOrdeleteStationEnabled((Station)this.stationModel.getObject(), this.getSession().getUtilisateur()));
        submittableButton3.add(new Behavior[]{new JSConfirmationBehavior(this.getString("Confirm"))});
        submittableButton3.setDefaultFormProcessing(false);
        form.add(new Component[]{submittableButton3});
        form.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
        if (bl2) {
            if (((Station)this.stationModel.getObject()).getCodePays() == null) {
                ((Station)this.stationModel.getObject()).setCodePays((String)((Map)WebContext.COUNTRIES.get(this.getSession().getLocale())).entrySet().iterator().next().getKey());
            }
            if (((Station)this.stationModel.getObject()).getReferentiel() == null) {
                ((Station)this.stationModel.getObject()).setReferentiel((Integer)WebContext.REFERENTIEL_CODES.get(0));
            }
            if (((ManageStationModel)this.manageStationModel.getObject()).getLatitudeOrientation() == null) {
                ((ManageStationModel)this.manageStationModel.getObject()).setLatitudeOrientation(CoordTools.LATITUDE_ORIENTATIONS[1]);
            }
            if (((ManageStationModel)this.manageStationModel.getObject()).getLongitudeOrientation() == null) {
                ((ManageStationModel)this.manageStationModel.getObject()).setLongitudeOrientation(CoordTools.LONGITUDE_ORIENTATIONS[0]);
            }
        }
        this.add(new Component[]{form});
    }

    private void redirect() {
        if (this.multipleEntry) {
            Station station = new Station();
            station.setCodePays(((Station)this.stationModel.getObject()).getCodePays());
            if (((ManageStationModel)this.manageStationModel.getObject()).getLatitudeDegrees() != null) {
                station.setLatitude(((Station)this.stationModel.getObject()).getLatitude());
                station.setLongitude(((Station)this.stationModel.getObject()).getLongitude());
                station.setReferentiel(((Station)this.stationModel.getObject()).getReferentiel());
            }
            this.setResponsePage((Page)new ManageStationPage(station, this.callerPage));
        } else {
            this.callerPage.addPageParameter(Station.class.getSimpleName(), (Object)((Station)this.stationModel.getObject()).getIdStation());
            this.callerPage.responsePage((TemplatePage)this);
        }
    }

    private void validateModel() {
        if (((Station)this.stationModel.getObject()).getCreateur() == null) {
            ((Station)this.stationModel.getObject()).setCreateur((Personne)this.getSession().getUtilisateur());
        }
        List list = this.validator.validate(this.stationModel.getObject(), this.getSession().getLocale(), new String[]{"referentiel"});
        List list2 = this.validator.validate(this.manageStationModel.getObject(), this.getSession().getLocale(), new String[0]);
        if (((ManageStationModel)this.manageStationModel.getObject()).getLatitudeDegrees() != null || ((ManageStationModel)this.manageStationModel.getObject()).getLatitudeMinutes() != null || ((ManageStationModel)this.manageStationModel.getObject()).getLongitudeDegrees() != null || ((ManageStationModel)this.manageStationModel.getObject()).getLongitudeMinutes() != null) {
            if (((ManageStationModel)this.manageStationModel.getObject()).getLatitudeDegrees() != null && ((ManageStationModel)this.manageStationModel.getObject()).getLatitudeMinutes() != null && ((ManageStationModel)this.manageStationModel.getObject()).getLatitudeOrientation() != null && ((ManageStationModel)this.manageStationModel.getObject()).getLongitudeDegrees() != null && ((ManageStationModel)this.manageStationModel.getObject()).getLongitudeMinutes() != null && ((ManageStationModel)this.manageStationModel.getObject()).getLongitudeOrientation() != null && ((Station)this.stationModel.getObject()).getReferentiel() != null) {
                if (list.isEmpty() && list2.isEmpty()) {
                    ((Station)this.stationModel.getObject()).setLatitude(CoordTools.latitude((Integer)((ManageStationModel)this.manageStationModel.getObject()).getLatitudeDegrees(), (BigDecimal)((ManageStationModel)this.manageStationModel.getObject()).getLatitudeMinutes(), (Character)((ManageStationModel)this.manageStationModel.getObject()).getLatitudeOrientation()));
                    ((Station)this.stationModel.getObject()).setLongitude(CoordTools.longitude((Integer)((ManageStationModel)this.manageStationModel.getObject()).getLongitudeDegrees(), (BigDecimal)((ManageStationModel)this.manageStationModel.getObject()).getLongitudeMinutes(), (Character)((ManageStationModel)this.manageStationModel.getObject()).getLongitudeOrientation()));
                }
            } else {
                this.getPage().error((Serializable)((Object)this.getString("Station.coordonnees.KO")));
            }
        } else if (((ManageStationModel)this.manageStationModel.getObject()).getLatitudeDegrees() == null && ((ManageStationModel)this.manageStationModel.getObject()).getLatitudeMinutes() == null && ((ManageStationModel)this.manageStationModel.getObject()).getLongitudeDegrees() == null && ((ManageStationModel)this.manageStationModel.getObject()).getLongitudeMinutes() == null) {
            ((Station)this.stationModel.getObject()).setLatitude(null);
            ((Station)this.stationModel.getObject()).setLongitude(null);
        }
        this.addValidationErrors((Collection)this.validator.validate(this.stationModel.getObject(), this.getSession().getLocale(), new String[]{"nom", "codePays", "localite", "complement", "createur", "latitude", "longitude"}));
        this.addValidationErrors((Collection)list);
        this.addValidationErrors((Collection)list2);
    }

    static /* synthetic */ IModel access$000(ManageStationPage manageStationPage) {
        return manageStationPage.manageStationModel;
    }

    static /* synthetic */ IModel access$100(ManageStationPage manageStationPage) {
        return manageStationPage.stationModel;
    }

    static /* synthetic */ StationService access$200(ManageStationPage manageStationPage) {
        return manageStationPage.stationService;
    }

    static /* synthetic */ void access$300(ManageStationPage manageStationPage) {
        manageStationPage.redirect();
    }

    static /* synthetic */ void access$400(ManageStationPage manageStationPage) {
        manageStationPage.validateModel();
    }
}

