/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.web.pages.domain.specimen;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import nc.ird.cantharella.data.exceptions.DataNotFoundException;
import nc.ird.cantharella.data.exceptions.UnexpectedException;
import nc.ird.cantharella.data.model.Personne;
import nc.ird.cantharella.data.model.Specimen;
import nc.ird.cantharella.data.model.Station;
import nc.ird.cantharella.data.validation.utils.ModelValidator;
import nc.ird.cantharella.service.services.PersonneService;
import nc.ird.cantharella.service.services.SpecimenService;
import nc.ird.cantharella.service.services.StationService;
import nc.ird.cantharella.web.pages.TemplatePage;
import nc.ird.cantharella.web.pages.renderers.PersonneRenderer;
import nc.ird.cantharella.web.utils.CallerPage;
import nc.ird.cantharella.web.utils.behaviors.JSConfirmationBehavior;
import nc.ird.cantharella.web.utils.forms.AutoCompleteTextFieldString;
import nc.ird.cantharella.web.utils.forms.SubmittableButton;
import nc.ird.cantharella.web.utils.forms.SubmittableButtonEvents;
import nc.ird.cantharella.web.utils.renderers.EnumChoiceRenderer;
import nc.ird.cantharella.web.utils.security.AuthRole;
import nc.ird.cantharella.web.utils.security.AuthRoles;
import nc.ird.module.utils.BeanTools;
import nc.ird.module.utils.CollectionTools;
import nc.ird.module.utils.LogTools;
import org.apache.commons.logging.Log;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.markup.html.form.DateTextField;
import org.apache.wicket.extensions.yui.calendar.DatePicker;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.apache.wicket.util.string.StringValueConversionException;

@AuthRoles(value={AuthRole.USER, AuthRole.ADMIN})
public final class ManageSpecimenPage
extends TemplatePage {
    private static final String ACTION_CREATE = "Create";
    public static final String ACTION_DELETE = "Delete";
    private static final String ACTION_UPDATE = "Update";
    private static final Log LOG = LogTools.getLog();
    private final IModel<Specimen> specimenModel;
    @SpringBean
    private SpecimenService specimenService;
    private final List<Personne> personnes;
    private final List<Station> stations;
    @SpringBean
    private PersonneService personneService;
    @SpringBean
    private StationService stationService;
    @SpringBean(name="webModelValidator")
    private ModelValidator validator;
    private final CallerPage callerPage;
    private boolean multipleEntry;

    public ManageSpecimenPage(CallerPage callerPage, boolean bl) {
        this(null, null, callerPage, bl);
    }

    public ManageSpecimenPage(Integer n, CallerPage callerPage) {
        this(n, null, callerPage, false);
    }

    public ManageSpecimenPage(Specimen specimen, CallerPage callerPage) {
        this(null, specimen, callerPage, true);
    }

    private ManageSpecimenPage(Integer n, Specimen specimen, CallerPage callerPage, boolean bl) {
        super(ManageSpecimenPage.class);
        boolean bl2;
        assert (n == null || specimen == null);
        this.callerPage = callerPage;
        this.multipleEntry = bl;
        CallerPage callerPage2 = new CallerPage((TemplatePage)this);
        try {
            this.specimenModel = new Model((Serializable)(n == null && specimen == null ? new Specimen() : (specimen != null ? specimen : this.specimenService.loadSpecimen(n))));
        }
        catch (DataNotFoundException dataNotFoundException) {
            LOG.error((Object)dataNotFoundException.getMessage(), (Throwable)dataNotFoundException);
            throw new UnexpectedException((Exception)((Object)dataNotFoundException));
        }
        boolean bl3 = bl2 = n == null;
        if (bl2) {
            ((Specimen)this.specimenModel.getObject()).setCreateur((Personne)this.getSession().getUtilisateur());
        }
        this.personnes = this.personneService.listPersonnes();
        this.stations = this.stationService.listStations(this.getSession().getUtilisateur());
        List list = this.specimenService.listSpecimenEmbranchements();
        List list2 = this.specimenService.listSpecimenFamilles();
        List list3 = this.specimenService.listSpecimenGenres();
        List list4 = this.specimenService.listSpecimenEspeces();
        List list5 = this.specimenService.listSpecimenSousEspeces();
        List list6 = this.specimenService.listSpecimenVarietes();
        List list7 = this.specimenService.listLieuxDepot();
        if (specimen != null) {
            if (((Specimen)this.specimenModel.getObject()).getIdentificateur() != null) {
                ((Specimen)this.specimenModel.getObject()).setIdentificateur((Personne)CollectionTools.findWithValue((List)this.personnes, (String)"idPersonne", (BeanTools.AccessType)BeanTools.AccessType.GETTER, (Object)((Specimen)this.specimenModel.getObject()).getIdentificateur().getIdPersonne()));
            }
            if (((Specimen)this.specimenModel.getObject()).getStation() != null) {
                ((Specimen)this.specimenModel.getObject()).setStation((Station)CollectionTools.findWithValue((List)this.stations, (String)"idStation", (BeanTools.AccessType)BeanTools.AccessType.GETTER, (Object)((Specimen)this.specimenModel.getObject()).getStation().getIdStation()));
            }
        }
        Form form = new Form("Form");
        form.add(new Component[]{new TextField("Specimen.ref", (IModel)new PropertyModel((Object)this.specimenModel, "ref"))});
        form.add(new Component[]{new AutoCompleteTextFieldString("Specimen.embranchement", (IModel)new PropertyModel((Object)this.specimenModel, "embranchement"), list, AutoCompleteTextFieldString.ComparisonMode.CONTAINS)});
        form.add(new Component[]{new AutoCompleteTextFieldString("Specimen.famille", (IModel)new PropertyModel((Object)this.specimenModel, "famille"), list2, AutoCompleteTextFieldString.ComparisonMode.CONTAINS)});
        form.add(new Component[]{new AutoCompleteTextFieldString("Specimen.genre", (IModel)new PropertyModel((Object)this.specimenModel, "genre"), list3, AutoCompleteTextFieldString.ComparisonMode.CONTAINS)});
        form.add(new Component[]{new AutoCompleteTextFieldString("Specimen.espece", (IModel)new PropertyModel((Object)this.specimenModel, "espece"), list4, AutoCompleteTextFieldString.ComparisonMode.CONTAINS)});
        form.add(new Component[]{new AutoCompleteTextFieldString("Specimen.sousEspece", (IModel)new PropertyModel((Object)this.specimenModel, "sousEspece"), list5, AutoCompleteTextFieldString.ComparisonMode.CONTAINS)});
        form.add(new Component[]{new AutoCompleteTextFieldString("Specimen.variete", (IModel)new PropertyModel((Object)this.specimenModel, "variete"), list6, AutoCompleteTextFieldString.ComparisonMode.CONTAINS)});
        DropDownChoice dropDownChoice = new DropDownChoice("Specimen.typeOrganisme", (IModel)new PropertyModel((Object)this.specimenModel, "typeOrganisme"), Arrays.asList(Specimen.TypeOrganisme.values()), (IChoiceRenderer)new EnumChoiceRenderer((TemplatePage)this));
        dropDownChoice.setNullValid(false);
        form.add(new Component[]{dropDownChoice});
        form.add(new Component[]{new DropDownChoice("Specimen.identificateur", (IModel)new PropertyModel((Object)this.specimenModel, "identificateur"), this.personnes, (IChoiceRenderer)new PersonneRenderer()).setNullValid(true)});
        form.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
        form.add(new Component[]{new DropDownChoice("Specimen.station", (IModel)new PropertyModel((Object)this.specimenModel, "station"), this.stations).setNullValid(true)});
        form.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
        form.add(new Component[]{new TextArea("Specimen.complement", (IModel)new PropertyModel((Object)this.specimenModel, "complement"))});
        form.add(new Component[]{new TextField("Specimen.createur", (IModel)new PropertyModel((Object)this.specimenModel, "createur")).setEnabled(false)});
        form.add(new Component[]{new TextField("Specimen.numDepot", (IModel)new PropertyModel((Object)this.specimenModel, "numDepot"))});
        form.add(new Component[]{new DateTextField("Specimen.dateDepot", (IModel)new PropertyModel((Object)this.specimenModel, "dateDepot")).add(new Behavior[]{new DatePicker()})});
        form.add(new Component[]{new AutoCompleteTextFieldString("Specimen.lieuDepot", (IModel)new PropertyModel((Object)this.specimenModel, "lieuDepot"), list7, AutoCompleteTextFieldString.ComparisonMode.CONTAINS)});
        SubmittableButton submittableButton = new SubmittableButton(ACTION_CREATE, (SubmittableButtonEvents)new /* Unavailable Anonymous Inner Class!! */);
        submittableButton.setVisibilityAllowed(bl2);
        form.add(new Component[]{submittableButton});
        SubmittableButton submittableButton2 = new SubmittableButton(ACTION_UPDATE, (SubmittableButtonEvents)new /* Unavailable Anonymous Inner Class!! */);
        submittableButton2.setVisibilityAllowed(!bl2 && this.specimenService.updateOrdeleteSpecimenEnabled((Specimen)this.specimenModel.getObject(), this.getSession().getUtilisateur()));
        form.add(new Component[]{submittableButton2});
        SubmittableButton submittableButton3 = new SubmittableButton(ACTION_DELETE, (SubmittableButtonEvents)new /* Unavailable Anonymous Inner Class!! */);
        submittableButton3.setVisibilityAllowed(!bl2 && this.specimenService.updateOrdeleteSpecimenEnabled((Specimen)this.specimenModel.getObject(), this.getSession().getUtilisateur()));
        submittableButton3.add(new Behavior[]{new JSConfirmationBehavior(this.getString("Confirm"))});
        submittableButton3.setDefaultFormProcessing(false);
        form.add(new Component[]{submittableButton3});
        form.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
        this.add(new Component[]{form});
    }

    protected void onBeforeRender() {
        this.refreshModel();
        super.onBeforeRender();
    }

    private void redirect() {
        if (this.multipleEntry) {
            Specimen specimen = new Specimen();
            specimen.setTypeOrganisme(((Specimen)this.specimenModel.getObject()).getTypeOrganisme());
            specimen.setEmbranchement(((Specimen)this.specimenModel.getObject()).getEmbranchement());
            specimen.setIdentificateur(((Specimen)this.specimenModel.getObject()).getIdentificateur());
            specimen.setStation(((Specimen)this.specimenModel.getObject()).getStation());
            specimen.setLieuDepot(((Specimen)this.specimenModel.getObject()).getLieuDepot());
            this.setResponsePage((Page)new ManageSpecimenPage(specimen, this.callerPage));
        } else if (this.callerPage != null) {
            this.callerPage.addPageParameter(Specimen.class.getSimpleName(), (Object)((Specimen)this.specimenModel.getObject()).getIdSpecimen());
            this.callerPage.responsePage((TemplatePage)this);
        }
    }

    private void refreshModel() {
        Personne personne;
        String string = Personne.class.getSimpleName();
        if (this.getPageParameters().getNamedKeys().contains(string)) {
            CollectionTools.setter((Collection)this.personnes, (Collection)this.personneService.listPersonnes());
            try {
                personne = this.personneService.loadPersonne(Integer.valueOf(this.getPageParameters().get(string).toInt()));
                ((Specimen)this.specimenModel.getObject()).setIdentificateur(personne);
            }
            catch (StringValueConversionException stringValueConversionException) {
                LOG.error((Object)stringValueConversionException.getMessage(), (Throwable)stringValueConversionException);
                throw new UnexpectedException((Exception)((Object)stringValueConversionException));
            }
            catch (DataNotFoundException dataNotFoundException) {
                LOG.error((Object)dataNotFoundException.getMessage(), (Throwable)dataNotFoundException);
                throw new UnexpectedException((Exception)((Object)dataNotFoundException));
            }
            this.getPageParameters().remove(string);
        }
        string = Station.class.getSimpleName();
        if (this.getPageParameters().getNamedKeys().contains(string)) {
            CollectionTools.setter((Collection)this.stations, (Collection)this.stationService.listStations(this.getSession().getUtilisateur()));
            try {
                personne = this.stationService.loadStation(Integer.valueOf(this.getPageParameters().get(string).toInt()));
                ((Specimen)this.specimenModel.getObject()).setStation((Station)personne);
            }
            catch (StringValueConversionException stringValueConversionException) {
                LOG.error((Object)stringValueConversionException.getMessage(), (Throwable)stringValueConversionException);
                throw new UnexpectedException((Exception)((Object)stringValueConversionException));
            }
            catch (DataNotFoundException dataNotFoundException) {
                LOG.error((Object)dataNotFoundException.getMessage(), (Throwable)dataNotFoundException);
                throw new UnexpectedException((Exception)((Object)dataNotFoundException));
            }
            this.getPageParameters().remove(string);
        }
    }

    private void validateModel() {
        this.addValidationErrors((Collection)this.validator.validate(this.specimenModel.getObject(), this.getSession().getLocale(), new String[0]));
    }

    static /* synthetic */ IModel access$000(ManageSpecimenPage manageSpecimenPage) {
        return manageSpecimenPage.specimenModel;
    }

    static /* synthetic */ SpecimenService access$100(ManageSpecimenPage manageSpecimenPage) {
        return manageSpecimenPage.specimenService;
    }

    static /* synthetic */ void access$200(ManageSpecimenPage manageSpecimenPage) {
        manageSpecimenPage.redirect();
    }

    static /* synthetic */ void access$300(ManageSpecimenPage manageSpecimenPage) {
        manageSpecimenPage.validateModel();
    }
}

