/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.web.pages.domain.purification;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import nc.ird.cantharella.data.exceptions.DataNotFoundException;
import nc.ird.cantharella.data.exceptions.UnexpectedException;
import nc.ird.cantharella.data.model.Fraction;
import nc.ird.cantharella.data.model.MethodePurification;
import nc.ird.cantharella.data.model.Personne;
import nc.ird.cantharella.data.model.Produit;
import nc.ird.cantharella.data.model.Purification;
import nc.ird.cantharella.data.validation.utils.ModelValidator;
import nc.ird.cantharella.service.services.PersonneService;
import nc.ird.cantharella.service.services.ProduitService;
import nc.ird.cantharella.service.services.PurificationService;
import nc.ird.cantharella.web.pages.TemplatePage;
import nc.ird.cantharella.web.pages.renderers.PersonneRenderer;
import nc.ird.cantharella.web.utils.CallerPage;
import nc.ird.cantharella.web.utils.behaviors.JSConfirmationBehavior;
import nc.ird.cantharella.web.utils.forms.SubmittableButton;
import nc.ird.cantharella.web.utils.forms.SubmittableButtonEvents;
import nc.ird.cantharella.web.utils.security.AuthRole;
import nc.ird.cantharella.web.utils.security.AuthRoles;
import nc.ird.module.utils.BeanTools;
import nc.ird.module.utils.CollectionTools;
import nc.ird.module.utils.LogTools;
import org.apache.commons.logging.Log;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Page;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.markup.html.form.DateTextField;
import org.apache.wicket.extensions.yui.calendar.DatePicker;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.MultiLineLabel;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.IFormSubmittingComponent;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.apache.wicket.util.string.StringValueConversionException;

@AuthRoles(value={AuthRole.ADMIN, AuthRole.USER})
public final class ManagePurificationPage
extends TemplatePage {
    private static final Log LOG = LogTools.getLog();
    private static final String ACTION_CREATE = "Create";
    private static final String ACTION_UPDATE = "Update";
    public static final String ACTION_DELETE = "Delete";
    private final IModel<Purification> purificationModel;
    private Model<Fraction> newFractionModel;
    @SpringBean
    private PurificationService purificationService;
    @SpringBean
    private PersonneService personneService;
    @SpringBean
    private ProduitService produitService;
    private final List<Personne> personnes;
    private final List<MethodePurification> methodes;
    private final List<Produit> produits;
    @SpringBean(name="webModelValidator")
    private ModelValidator validator;
    private final CallerPage callerPage;
    private boolean multipleEntry;
    private boolean createMode;
    private HashMap<String, Integer> fractionsDeleted;
    Button addPurificationButton;
    MarkupContainer descriptionMethoContainer;
    MarkupContainer paramsMethoContainer;

    public ManagePurificationPage(CallerPage callerPage, boolean bl) {
        this(null, null, callerPage, bl);
    }

    public ManagePurificationPage(Integer n, CallerPage callerPage) {
        this(n, null, callerPage, false);
    }

    public ManagePurificationPage(Purification purification, CallerPage callerPage) {
        this(null, purification, callerPage, true);
    }

    private ManagePurificationPage(Integer n, Purification purification, CallerPage callerPage, boolean bl) {
        super(ManagePurificationPage.class);
        assert (n == null || purification == null);
        this.callerPage = callerPage;
        this.multipleEntry = bl;
        this.fractionsDeleted = new HashMap();
        this.newFractionModel = new Model((Serializable)new Fraction());
        try {
            this.purificationModel = new Model((Serializable)(n == null && purification == null ? new Purification() : (purification != null ? purification : this.purificationService.loadPurification(n))));
        }
        catch (DataNotFoundException dataNotFoundException) {
            LOG.error((Object)dataNotFoundException.getMessage(), (Throwable)dataNotFoundException);
            throw new UnexpectedException((Exception)((Object)dataNotFoundException));
        }
        boolean bl2 = this.createMode = n == null;
        if (this.createMode) {
            ((Purification)this.purificationModel.getObject()).setCreateur((Personne)this.getSession().getUtilisateur());
        }
        this.personnes = this.personneService.listPersonnes();
        this.methodes = this.purificationService.listMethodesPurification();
        this.produits = this.produitService.listProduits(this.getSession().getUtilisateur());
        if (purification != null) {
            ((Purification)this.purificationModel.getObject()).setManipulateur((Personne)CollectionTools.findWithValue((List)this.personnes, (String)"idPersonne", (BeanTools.AccessType)BeanTools.AccessType.GETTER, (Object)((Purification)this.purificationModel.getObject()).getManipulateur().getIdPersonne()));
        }
        Form form = new Form("Form");
        this.initPrincipalFields(form);
        this.initMethodeFields(form);
        this.initFractionsFields(form);
        SubmittableButton submittableButton = new SubmittableButton(ACTION_CREATE, (SubmittableButtonEvents)new /* Unavailable Anonymous Inner Class!! */);
        submittableButton.setVisibilityAllowed(this.createMode);
        form.add(new Component[]{submittableButton});
        SubmittableButton submittableButton2 = new SubmittableButton(ACTION_UPDATE, (SubmittableButtonEvents)new /* Unavailable Anonymous Inner Class!! */);
        submittableButton2.setVisibilityAllowed(!this.createMode);
        form.add(new Component[]{submittableButton2});
        SubmittableButton submittableButton3 = new SubmittableButton(ACTION_DELETE, ManagePurificationPage.class, (SubmittableButtonEvents)new /* Unavailable Anonymous Inner Class!! */);
        submittableButton3.setVisibilityAllowed(!this.createMode);
        submittableButton3.setDefaultFormProcessing(false);
        submittableButton3.add(new Behavior[]{new JSConfirmationBehavior(this.getString("Confirm"))});
        form.add(new Component[]{submittableButton3});
        form.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
        form.setDefaultButton((IFormSubmittingComponent)this.addPurificationButton);
        this.add(new Component[]{form});
    }

    private void initPrincipalFields(Form<Void> form) {
        form.add(new Component[]{new TextField("Purification.ref", (IModel)new PropertyModel((Object)this.purificationModel, "ref"))});
        form.add(new Component[]{new DropDownChoice("Purification.manipulateur", (IModel)new PropertyModel((Object)this.purificationModel, "manipulateur"), this.personnes, (IChoiceRenderer)new PersonneRenderer()).setNullValid(false)});
        form.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
        form.add(new Component[]{new DateTextField("Purification.date", (IModel)new PropertyModel((Object)this.purificationModel, "date")).add(new Behavior[]{new DatePicker()})});
        DropDownChoice dropDownChoice = new DropDownChoice("Purification.produit", (IModel)new PropertyModel((Object)this.purificationModel, "produit"), this.produits);
        dropDownChoice.setNullValid(false);
        dropDownChoice.setEnabled(this.createMode);
        form.add(new Component[]{dropDownChoice});
        TextField textField = new TextField("Purification.masseDepart", (IModel)new PropertyModel((Object)this.purificationModel, "masseDepart"));
        textField.add(new Behavior[]{new /* Unavailable Anonymous Inner Class!! */});
        form.add(new Component[]{textField});
        form.add(new Component[]{new TextArea("Purification.complement", (IModel)new PropertyModel((Object)this.purificationModel, "complement"))});
        form.add(new Component[]{new TextField("Purification.createur", (IModel)new PropertyModel((Object)this.purificationModel, "createur")).setEnabled(false)});
    }

    private void initMethodeFields(Form<Void> form) {
        WebMarkupContainer webMarkupContainer = new WebMarkupContainer("Purification.methode");
        webMarkupContainer.setOutputMarkupId(true);
        form.add(new Component[]{webMarkupContainer});
        this.descriptionMethoContainer = new /* Unavailable Anonymous Inner Class!! */;
        this.descriptionMethoContainer.setOutputMarkupId(true);
        this.descriptionMethoContainer.setOutputMarkupPlaceholderTag(true);
        webMarkupContainer.add(new Component[]{this.descriptionMethoContainer});
        MultiLineLabel multiLineLabel = new MultiLineLabel("Purification.descriptionMethode", (IModel)new PropertyModel((Object)this.purificationModel, "methode.description"));
        multiLineLabel.setOutputMarkupId(true);
        this.descriptionMethoContainer.add(new Component[]{multiLineLabel});
        this.paramsMethoContainer = new /* Unavailable Anonymous Inner Class!! */;
        WebMarkupContainer webMarkupContainer2 = new WebMarkupContainer("Purification.paramsMethode.Table");
        this.paramsMethoContainer.add(new Component[]{webMarkupContainer2});
        this.paramsMethoContainer.setOutputMarkupId(true);
        this.paramsMethoContainer.setOutputMarkupPlaceholderTag(true);
        webMarkupContainer2.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
        webMarkupContainer.add(new Component[]{this.paramsMethoContainer});
        DropDownChoice dropDownChoice = new DropDownChoice("Purification.nomMethode", (IModel)new PropertyModel((Object)this.purificationModel, "methode"), this.methodes);
        dropDownChoice.setNullValid(false);
        dropDownChoice.add(new Behavior[]{new /* Unavailable Anonymous Inner Class!! */});
        webMarkupContainer.add(new Component[]{dropDownChoice});
    }

    private void initFractionsFields(Form<Void> form) {
        WebMarkupContainer webMarkupContainer = new WebMarkupContainer("Purification.fractions.Table");
        webMarkupContainer.setOutputMarkupId(true);
        webMarkupContainer.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
        TextField textField = new TextField("Purification.fractions.indice", (IModel)new PropertyModel((Object)this.newFractionModel, "indice"));
        webMarkupContainer.add(new Component[]{textField});
        TextField textField2 = new TextField("Purification.fractions.ref", (IModel)new PropertyModel((Object)this.newFractionModel, "ref"));
        webMarkupContainer.add(new Component[]{textField2});
        TextField textField3 = new TextField("Purification.fractions.masseObtenue", (IModel)new PropertyModel((Object)this.newFractionModel, "masseObtenue"));
        webMarkupContainer.add(new Component[]{textField3});
        this.addPurificationButton = new /* Unavailable Anonymous Inner Class!! */;
        webMarkupContainer.add(new Component[]{this.addPurificationButton});
        form.add(new Component[]{webMarkupContainer});
    }

    protected void onBeforeRender() {
        this.refreshModel();
        super.onBeforeRender();
    }

    private void redirect() {
        if (this.multipleEntry) {
            Purification purification = new Purification();
            purification.setManipulateur(((Purification)this.purificationModel.getObject()).getManipulateur());
            this.setResponsePage((Page)new ManagePurificationPage(purification, this.callerPage));
        } else if (this.callerPage != null) {
            this.callerPage.addPageParameter(Purification.class.getSimpleName(), (Object)((Purification)this.purificationModel.getObject()).getIdPurification());
            this.callerPage.responsePage((TemplatePage)this);
        }
    }

    private void refreshModel() {
        String string = Personne.class.getSimpleName();
        if (this.getPageParameters().getNamedKeys().contains(string)) {
            CollectionTools.setter((Collection)this.personnes, (Collection)this.personneService.listPersonnes());
            try {
                Personne personne = this.personneService.loadPersonne(Integer.valueOf(this.getPageParameters().get(string).toInt()));
                ((Purification)this.purificationModel.getObject()).setManipulateur(personne);
            }
            catch (StringValueConversionException stringValueConversionException) {
                LOG.error((Object)stringValueConversionException.getMessage(), (Throwable)stringValueConversionException);
                throw new UnexpectedException((Exception)((Object)stringValueConversionException));
            }
            catch (DataNotFoundException dataNotFoundException) {
                LOG.error((Object)dataNotFoundException.getMessage(), (Throwable)dataNotFoundException);
                throw new UnexpectedException((Exception)((Object)dataNotFoundException));
            }
            this.getPageParameters().remove(string);
        }
    }

    private void validateModel() {
        this.addValidationErrors((Collection)this.validator.validate(this.purificationModel.getObject(), this.getSession().getLocale(), new String[0]));
        if (!this.purificationService.isPurificationUnique((Purification)this.purificationModel.getObject())) {
            this.error((Serializable)((Object)this.getString("Purification.notUnique")));
        }
    }

    static /* synthetic */ IModel access$000(ManagePurificationPage managePurificationPage) {
        return managePurificationPage.purificationModel;
    }

    static /* synthetic */ PurificationService access$100(ManagePurificationPage managePurificationPage) {
        return managePurificationPage.purificationService;
    }

    static /* synthetic */ void access$200(ManagePurificationPage managePurificationPage) {
        managePurificationPage.redirect();
    }

    static /* synthetic */ void access$300(ManagePurificationPage managePurificationPage) {
        managePurificationPage.validateModel();
    }

    static /* synthetic */ ProduitService access$400(ManagePurificationPage managePurificationPage) {
        return managePurificationPage.produitService;
    }

    static /* synthetic */ HashMap access$500(ManagePurificationPage managePurificationPage) {
        return managePurificationPage.fractionsDeleted;
    }

    static /* synthetic */ void access$600(ManagePurificationPage managePurificationPage, AjaxRequestTarget ajaxRequestTarget) {
        managePurificationPage.refreshFeedbackPage(ajaxRequestTarget);
    }

    static /* synthetic */ Model access$700(ManagePurificationPage managePurificationPage) {
        return managePurificationPage.newFractionModel;
    }

    static /* synthetic */ ModelValidator access$800(ManagePurificationPage managePurificationPage) {
        return managePurificationPage.validator;
    }

    static /* synthetic */ Log access$900() {
        return LOG;
    }

    static /* synthetic */ void access$1000(ManagePurificationPage managePurificationPage, AjaxRequestTarget ajaxRequestTarget) {
        managePurificationPage.refreshFeedbackPage(ajaxRequestTarget);
    }

    static /* synthetic */ void access$1100(ManagePurificationPage managePurificationPage, AjaxRequestTarget ajaxRequestTarget) {
        managePurificationPage.refreshFeedbackPage(ajaxRequestTarget);
    }
}

