/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.web.pages.domain.personne.panels;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import nc.ird.cantharella.data.model.Personne;
import nc.ird.cantharella.data.validation.utils.ModelValidator;
import nc.ird.cantharella.service.services.PersonneService;
import nc.ird.cantharella.web.config.WebContext;
import nc.ird.cantharella.web.pages.TemplatePage;
import nc.ird.cantharella.web.utils.forms.AutoCompleteTextFieldString;
import nc.ird.cantharella.web.utils.renderers.MapChoiceRenderer;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.spring.injection.annot.SpringBean;

public final class ManagePersonnePanel
extends Panel {
    @SpringBean(name="webModelValidator")
    private ModelValidator validator;
    @SpringBean
    private PersonneService personneService;

    public ManagePersonnePanel(String string, IModel<? extends Personne> iModel) {
        super(string, iModel);
        List list = this.personneService.listPersonneOrganismes();
        this.add(new Component[]{new TextField("Personne.prenom", (IModel)new PropertyModel(iModel, "prenom"))});
        this.add(new Component[]{new TextField("Personne.nom", (IModel)new PropertyModel(iModel, "nom"))});
        this.add(new Component[]{new AutoCompleteTextFieldString("Personne.organisme", (IModel)new PropertyModel(iModel, "organisme"), list, AutoCompleteTextFieldString.ComparisonMode.CONTAINS)});
        this.add(new Component[]{new TextField("Personne.fonction", (IModel)new PropertyModel(iModel, "fonction"))});
        this.add(new Component[]{new TextField("Personne.tel", (IModel)new PropertyModel(iModel, "tel"))});
        this.add(new Component[]{new TextField("Personne.fax", (IModel)new PropertyModel(iModel, "fax"))});
        this.add(new Component[]{new TextField("Personne.courriel", (IModel)new PropertyModel(iModel, "courriel"))});
        this.add(new Component[]{new TextArea("Personne.adressePostale", (IModel)new PropertyModel(iModel, "adressePostale"))});
        this.add(new Component[]{new TextField("Personne.codePostal", (IModel)new PropertyModel(iModel, "codePostal"))});
        this.add(new Component[]{new TextField("Personne.ville", (IModel)new PropertyModel(iModel, "ville"))});
        this.add(new Component[]{new DropDownChoice("Personne.codePays", (IModel)new PropertyModel(iModel, "codePays"), (List)WebContext.COUNTRY_CODES.get(this.getSession().getLocale()), (IChoiceRenderer)new MapChoiceRenderer((Map)WebContext.COUNTRIES.get(this.getSession().getLocale())))});
        if (((Personne)iModel.getObject()).getCodePays() == null) {
            ((Personne)iModel.getObject()).setCodePays((String)((Map)WebContext.COUNTRIES.get(this.getSession().getLocale())).entrySet().iterator().next().getKey());
        }
    }

    public void validate() {
        ((TemplatePage)this.getPage()).addValidationErrors((Collection)this.validator.validate((Object)((Personne)this.getDefaultModelObject()), this.getSession().getLocale(), new String[]{"prenom", "nom", "organisme", "fonction", "tel", "fax", "courriel", "adressePostale", "codePostal", "ville", "codePays"}));
    }
}

