/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.web.pages.domain.personne;

import java.io.Serializable;
import nc.ird.cantharella.data.exceptions.DataNotFoundException;
import nc.ird.cantharella.data.exceptions.UnexpectedException;
import nc.ird.cantharella.data.model.Personne;
import nc.ird.cantharella.data.model.Utilisateur;
import nc.ird.cantharella.service.services.PersonneService;
import nc.ird.cantharella.web.pages.TemplatePage;
import nc.ird.cantharella.web.pages.domain.personne.panels.ManagePersonnePanel;
import nc.ird.cantharella.web.utils.CallerPage;
import nc.ird.cantharella.web.utils.behaviors.JSConfirmationBehavior;
import nc.ird.cantharella.web.utils.forms.SubmittableButton;
import nc.ird.cantharella.web.utils.forms.SubmittableButtonEvents;
import nc.ird.cantharella.web.utils.security.AuthRole;
import nc.ird.cantharella.web.utils.security.AuthRoles;
import nc.ird.module.utils.LogTools;
import org.apache.commons.logging.Log;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.spring.injection.annot.SpringBean;

@AuthRoles(value={AuthRole.ADMIN, AuthRole.USER})
public final class ManagePersonnePage
extends TemplatePage {
    private static final String ACTION_CREATE = "Create";
    private static final String ACTION_CREATE_UTILISATEUR = "CreateUtilisateur";
    public static final String ACTION_DELETE = "Delete";
    private static final String ACTION_UPDATE = "Update";
    private static final Log LOG = LogTools.getLog();
    private final CallerPage callerPage;
    private boolean multipleEntry;
    private final IModel<Personne> personneModel;
    @SpringBean
    private PersonneService personneService;

    public ManagePersonnePage(CallerPage callerPage, boolean bl) {
        this(null, null, callerPage, bl);
    }

    public ManagePersonnePage(Integer n, CallerPage callerPage) {
        this(n, null, callerPage, false);
    }

    public ManagePersonnePage(Personne personne, CallerPage callerPage) {
        this(null, personne, callerPage, true);
    }

    private ManagePersonnePage(Integer n, Personne personne, CallerPage callerPage, boolean bl) {
        super(ManagePersonnePage.class);
        assert (n == null || personne == null);
        this.callerPage = callerPage;
        this.multipleEntry = bl;
        try {
            this.personneModel = new Model((Serializable)(n == null && personne == null ? new Personne() : (personne != null ? personne : this.personneService.loadPersonne(n))));
        }
        catch (DataNotFoundException dataNotFoundException) {
            LOG.error((Object)dataNotFoundException.getMessage(), (Throwable)dataNotFoundException);
            throw new UnexpectedException((Exception)((Object)dataNotFoundException));
        }
        boolean bl2 = n == null;
        Form form = new Form("Form", this.personneModel);
        ManagePersonnePanel managePersonnePanel = new ManagePersonnePanel("ManagePersonnePanel", this.personneModel);
        form.add(new Component[]{managePersonnePanel});
        SubmittableButton submittableButton = new SubmittableButton(ACTION_CREATE, (SubmittableButtonEvents)new /* Unavailable Anonymous Inner Class!! */);
        submittableButton.setVisibilityAllowed(bl2);
        form.add(new Component[]{submittableButton});
        SubmittableButton submittableButton2 = new SubmittableButton(ACTION_UPDATE, (SubmittableButtonEvents)new /* Unavailable Anonymous Inner Class!! */);
        submittableButton2.setVisibilityAllowed(!bl2);
        form.add(new Component[]{submittableButton2});
        SubmittableButton submittableButton3 = new SubmittableButton(ACTION_CREATE_UTILISATEUR, (SubmittableButtonEvents)new /* Unavailable Anonymous Inner Class!! */);
        submittableButton3.setVisibilityAllowed(!bl2 && this.getSession().getUtilisateur().getTypeDroit() == Utilisateur.TypeDroit.ADMINISTRATEUR);
        form.add(new Component[]{submittableButton3});
        SubmittableButton submittableButton4 = new SubmittableButton(ACTION_DELETE, (SubmittableButtonEvents)new /* Unavailable Anonymous Inner Class!! */);
        submittableButton4.setVisibilityAllowed(!bl2);
        submittableButton4.setDefaultFormProcessing(false);
        submittableButton4.add(new Behavior[]{new JSConfirmationBehavior(this.getString("Confirm"))});
        form.add(new Component[]{submittableButton4});
        form.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
        this.add(new Component[]{form});
    }

    private void redirect() {
        if (this.multipleEntry) {
            Personne personne = new Personne();
            personne.setOrganisme(((Personne)this.personneModel.getObject()).getOrganisme());
            personne.setAdressePostale(((Personne)this.personneModel.getObject()).getAdressePostale());
            personne.setCodePostal(((Personne)this.personneModel.getObject()).getCodePostal());
            personne.setVille(((Personne)this.personneModel.getObject()).getVille());
            personne.setCodePays(((Personne)this.personneModel.getObject()).getCodePays());
            this.setResponsePage((Page)new ManagePersonnePage(personne, this.callerPage));
        } else if (this.callerPage != null) {
            this.callerPage.addPageParameter(Personne.class.getSimpleName(), (Object)((Personne)this.personneModel.getObject()).getIdPersonne());
            this.callerPage.responsePage((TemplatePage)this);
        }
    }

    static /* synthetic */ IModel access$000(ManagePersonnePage managePersonnePage) {
        return managePersonnePage.personneModel;
    }

    static /* synthetic */ PersonneService access$100(ManagePersonnePage managePersonnePage) {
        return managePersonnePage.personneService;
    }

    static /* synthetic */ void access$200(ManagePersonnePage managePersonnePage) {
        managePersonnePage.redirect();
    }
}

