/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.web.pages.domain.lot;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import nc.ird.cantharella.data.exceptions.DataNotFoundException;
import nc.ird.cantharella.data.exceptions.UnexpectedException;
import nc.ird.cantharella.data.model.Campagne;
import nc.ird.cantharella.data.model.Lot;
import nc.ird.cantharella.data.model.Partie;
import nc.ird.cantharella.data.model.Personne;
import nc.ird.cantharella.data.model.Specimen;
import nc.ird.cantharella.data.model.Station;
import nc.ird.cantharella.data.validation.utils.ModelValidator;
import nc.ird.cantharella.service.services.CampagneService;
import nc.ird.cantharella.service.services.LotService;
import nc.ird.cantharella.service.services.SpecimenService;
import nc.ird.cantharella.web.pages.TemplatePage;
import nc.ird.cantharella.web.utils.CallerPage;
import nc.ird.cantharella.web.utils.behaviors.JSConfirmationBehavior;
import nc.ird.cantharella.web.utils.forms.SubmittableButton;
import nc.ird.cantharella.web.utils.forms.SubmittableButtonEvents;
import nc.ird.cantharella.web.utils.panels.SimpleTooltipPanel;
import nc.ird.cantharella.web.utils.security.AuthRole;
import nc.ird.cantharella.web.utils.security.AuthRoles;
import nc.ird.module.utils.BeanTools;
import nc.ird.module.utils.CollectionTools;
import nc.ird.module.utils.LogTools;
import org.apache.commons.logging.Log;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.markup.html.form.DateTextField;
import org.apache.wicket.extensions.yui.calendar.DatePicker;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.apache.wicket.util.string.StringValueConversionException;

@AuthRoles(value={AuthRole.USER, AuthRole.ADMIN})
public final class ManageLotPage
extends TemplatePage {
    private static final String ACTION_CREATE = "Create";
    public static final String ACTION_DELETE = "Delete";
    private static final String ACTION_UPDATE = "Update";
    private static final Log LOG = LogTools.getLog();
    private final List<Campagne> campagnes;
    @SpringBean
    private CampagneService campagneService;
    private final IModel<Lot> lotModel;
    @SpringBean
    private LotService lotService;
    private final List<Specimen> specimens;
    @SpringBean
    private SpecimenService specimenService;
    @SpringBean(name="webModelValidator")
    private ModelValidator validator;
    private final CallerPage callerPage;
    private boolean multipleEntry;

    public ManageLotPage(CallerPage callerPage, boolean bl) {
        this(null, null, callerPage, bl);
    }

    public ManageLotPage(Integer n, CallerPage callerPage) {
        this(n, null, callerPage, false);
    }

    public ManageLotPage(Lot lot, CallerPage callerPage) {
        this(null, lot, callerPage, true);
    }

    private ManageLotPage(Integer n, Lot lot, CallerPage callerPage, boolean bl) {
        super(ManageLotPage.class);
        Object object;
        boolean bl2;
        assert (n == null || lot == null);
        this.callerPage = callerPage;
        this.multipleEntry = bl;
        CallerPage callerPage2 = new CallerPage((TemplatePage)this);
        try {
            this.lotModel = new Model((Serializable)(n == null && lot == null ? new Lot() : (lot != null ? lot : this.lotService.loadLot(n))));
        }
        catch (DataNotFoundException dataNotFoundException) {
            LOG.error((Object)dataNotFoundException.getMessage(), (Throwable)dataNotFoundException);
            throw new UnexpectedException((Exception)((Object)dataNotFoundException));
        }
        boolean bl3 = bl2 = n == null;
        if (bl2) {
            ((Lot)this.lotModel.getObject()).setCreateur((Personne)this.getSession().getUtilisateur());
        }
        this.campagnes = this.campagneService.listCampagnes(this.getSession().getUtilisateur());
        this.specimens = this.specimenService.listSpecimens(this.getSession().getUtilisateur());
        List list = this.lotService.listParties();
        if (lot != null) {
            ((Lot)this.lotModel.getObject()).setCampagne((Campagne)CollectionTools.findWithValue((List)this.campagnes, (String)"idCampagne", (BeanTools.AccessType)BeanTools.AccessType.GETTER, (Object)((Lot)this.lotModel.getObject()).getCampagne().getIdCampagne()));
            if (((Lot)this.lotModel.getObject()).getCampagne() != null) {
                object = ((Lot)this.lotModel.getObject()).getCampagne().getStations();
                ((Lot)this.lotModel.getObject()).setStation((Station)CollectionTools.findWithValue((List)object, (String)"idStation", (BeanTools.AccessType)BeanTools.AccessType.GETTER, (Object)((Lot)this.lotModel.getObject()).getStation().getIdStation()));
            }
            if (((Lot)this.lotModel.getObject()).getPartie() != null) {
                ((Lot)this.lotModel.getObject()).setPartie((Partie)CollectionTools.findWithValue((List)list, (String)"idPartie", (BeanTools.AccessType)BeanTools.AccessType.GETTER, (Object)((Lot)this.lotModel.getObject()).getPartie().getIdPartie()));
            }
        } else if (n != null) {
            // empty if block
        }
        object = new Form("Form");
        DropDownChoice dropDownChoice = new DropDownChoice("Lot.campagne", (IModel)new PropertyModel((Object)this.lotModel, "campagne"), this.campagnes);
        dropDownChoice.setNullValid(false);
        object.add(new Component[]{dropDownChoice});
        object.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
        DropDownChoice dropDownChoice2 = new DropDownChoice("Lot.station", (IModel)new PropertyModel((Object)this.lotModel, "station"), ((Lot)this.lotModel.getObject()).getCampagne() == null ? new ArrayList() : ((Lot)this.lotModel.getObject()).getCampagne().getStations());
        dropDownChoice2.setOutputMarkupId(true);
        dropDownChoice2.setNullValid(false);
        dropDownChoice2.setEnabled(((Lot)this.lotModel.getObject()).getCampagne() != null);
        object.add(new Component[]{dropDownChoice2});
        object.add(new Component[]{new SimpleTooltipPanel("Lot.station.info", (IModel)new Model((Serializable)((Object)this.getString("Lot.station.info"))))});
        dropDownChoice.add(new Behavior[]{new /* Unavailable Anonymous Inner Class!! */});
        object.add(new Component[]{new DateTextField("Lot.dateRecolte", (IModel)new PropertyModel((Object)this.lotModel, "dateRecolte")).add(new Behavior[]{new DatePicker()})});
        object.add(new Component[]{new TextField("Lot.ref", (IModel)new PropertyModel((Object)this.lotModel, "ref"))});
        object.add(new Component[]{new DropDownChoice("Lot.specimenRef", (IModel)new PropertyModel((Object)this.lotModel, "specimenRef"), this.specimens).setNullValid(false)});
        object.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
        object.add(new Component[]{new DropDownChoice("Lot.partie", (IModel)new PropertyModel((Object)this.lotModel, "partie"), list).setNullValid(true)});
        object.add(new Component[]{new TextField("Lot.masseFraiche", (IModel)new PropertyModel((Object)this.lotModel, "masseFraiche"))});
        object.add(new Component[]{new TextField("Lot.masseSeche", (IModel)new PropertyModel((Object)this.lotModel, "masseSeche"))});
        object.add(new Component[]{new CheckBox("Lot.echantillonColl", (IModel)new PropertyModel((Object)this.lotModel, "echantillonColl"))});
        object.add(new Component[]{new CheckBox("Lot.echantillonIdent", (IModel)new PropertyModel((Object)this.lotModel, "echantillonIdent"))});
        object.add(new Component[]{new CheckBox("Lot.echantillonPhylo", (IModel)new PropertyModel((Object)this.lotModel, "echantillonPhylo"))});
        object.add(new Component[]{new TextArea("Lot.complement", (IModel)new PropertyModel((Object)this.lotModel, "complement"))});
        object.add(new Component[]{new TextField("Lot.createur", (IModel)new PropertyModel((Object)this.lotModel, "createur")).setEnabled(false)});
        SubmittableButton submittableButton = new SubmittableButton(ACTION_CREATE, (SubmittableButtonEvents)new /* Unavailable Anonymous Inner Class!! */);
        submittableButton.setVisibilityAllowed(bl2);
        object.add(new Component[]{submittableButton});
        SubmittableButton submittableButton2 = new SubmittableButton(ACTION_UPDATE, (SubmittableButtonEvents)new /* Unavailable Anonymous Inner Class!! */);
        submittableButton2.setVisibilityAllowed(!bl2 && this.lotService.updateOrdeleteLotEnabled((Lot)this.lotModel.getObject(), this.getSession().getUtilisateur()));
        object.add(new Component[]{submittableButton2});
        SubmittableButton submittableButton3 = new SubmittableButton(ACTION_DELETE, (SubmittableButtonEvents)new /* Unavailable Anonymous Inner Class!! */);
        submittableButton3.setVisibilityAllowed(!bl2 && this.lotService.updateOrdeleteLotEnabled((Lot)this.lotModel.getObject(), this.getSession().getUtilisateur()));
        submittableButton3.add(new Behavior[]{new JSConfirmationBehavior(this.getString("Confirm"))});
        submittableButton3.setDefaultFormProcessing(false);
        object.add(new Component[]{submittableButton3});
        object.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
        this.add(new Component[]{object});
    }

    protected void onBeforeRender() {
        this.refreshModel();
        super.onBeforeRender();
    }

    private void redirect() {
        if (this.multipleEntry) {
            Lot lot = new Lot();
            lot.setCampagne(((Lot)this.lotModel.getObject()).getCampagne());
            lot.setStation(((Lot)this.lotModel.getObject()).getStation());
            lot.setDateRecolte(((Lot)this.lotModel.getObject()).getDateRecolte());
            lot.setPartie(((Lot)this.lotModel.getObject()).getPartie());
            this.setResponsePage((Page)new ManageLotPage(lot, this.callerPage));
        } else if (this.callerPage != null) {
            this.callerPage.addPageParameter(Lot.class.getSimpleName(), (Object)((Lot)this.lotModel.getObject()).getIdLot());
            this.callerPage.responsePage((TemplatePage)this);
        }
    }

    private void refreshModel() {
        Campagne campagne;
        String string = Campagne.class.getSimpleName();
        if (this.getPageParameters().getNamedKeys().contains(string)) {
            CollectionTools.setter((Collection)this.campagnes, (Collection)this.campagneService.listCampagnes(this.getSession().getUtilisateur()));
            try {
                campagne = this.campagneService.loadCampagne(Integer.valueOf(this.getPageParameters().get(string).toInt()));
                ((Lot)this.lotModel.getObject()).setCampagne(campagne);
            }
            catch (StringValueConversionException stringValueConversionException) {
                LOG.error((Object)stringValueConversionException.getMessage(), (Throwable)stringValueConversionException);
                throw new UnexpectedException((Exception)((Object)stringValueConversionException));
            }
            catch (DataNotFoundException dataNotFoundException) {
                LOG.error((Object)dataNotFoundException.getMessage(), (Throwable)dataNotFoundException);
                throw new UnexpectedException((Exception)((Object)dataNotFoundException));
            }
            this.getPageParameters().remove(string);
        }
        string = Specimen.class.getSimpleName();
        if (this.getPageParameters().getNamedKeys().contains(string)) {
            CollectionTools.setter((Collection)this.specimens, (Collection)this.specimenService.listSpecimens(this.getSession().getUtilisateur()));
            try {
                campagne = this.specimenService.loadSpecimen(Integer.valueOf(this.getPageParameters().get(string).toInt()));
                ((Lot)this.lotModel.getObject()).setSpecimenRef((Specimen)campagne);
            }
            catch (StringValueConversionException stringValueConversionException) {
                LOG.error((Object)stringValueConversionException.getMessage(), (Throwable)stringValueConversionException);
                throw new UnexpectedException((Exception)((Object)stringValueConversionException));
            }
            catch (DataNotFoundException dataNotFoundException) {
                LOG.error((Object)dataNotFoundException.getMessage(), (Throwable)dataNotFoundException);
                throw new UnexpectedException((Exception)((Object)dataNotFoundException));
            }
            this.getPageParameters().remove(string);
        }
    }

    private void validateModel() {
        if (((Lot)this.lotModel.getObject()).getCreateur() == null) {
            ((Lot)this.lotModel.getObject()).setCreateur((Personne)this.getSession().getUtilisateur());
        }
        this.addValidationErrors((Collection)this.validator.validate(this.lotModel.getObject(), this.getSession().getLocale(), new String[0]));
    }

    static /* synthetic */ IModel access$000(ManageLotPage manageLotPage) {
        return manageLotPage.lotModel;
    }

    static /* synthetic */ CampagneService access$100(ManageLotPage manageLotPage) {
        return manageLotPage.campagneService;
    }

    static /* synthetic */ LotService access$200(ManageLotPage manageLotPage) {
        return manageLotPage.lotService;
    }

    static /* synthetic */ void access$300(ManageLotPage manageLotPage) {
        manageLotPage.redirect();
    }

    static /* synthetic */ void access$400(ManageLotPage manageLotPage) {
        manageLotPage.validateModel();
    }
}

