/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.web.pages.domain.extraction;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import nc.ird.cantharella.data.exceptions.DataNotFoundException;
import nc.ird.cantharella.data.exceptions.UnexpectedException;
import nc.ird.cantharella.data.model.Extraction;
import nc.ird.cantharella.data.model.Extrait;
import nc.ird.cantharella.data.model.Lot;
import nc.ird.cantharella.data.model.MethodeExtraction;
import nc.ird.cantharella.data.model.Personne;
import nc.ird.cantharella.data.model.TypeExtrait;
import nc.ird.cantharella.data.validation.utils.ModelValidator;
import nc.ird.cantharella.service.services.ExtractionService;
import nc.ird.cantharella.service.services.LotService;
import nc.ird.cantharella.service.services.PersonneService;
import nc.ird.cantharella.service.services.ProduitService;
import nc.ird.cantharella.web.pages.TemplatePage;
import nc.ird.cantharella.web.pages.domain.extraction.ManageExtractionPage;
import nc.ird.cantharella.web.pages.renderers.PersonneRenderer;
import nc.ird.cantharella.web.utils.CallerPage;
import nc.ird.cantharella.web.utils.behaviors.JSConfirmationBehavior;
import nc.ird.cantharella.web.utils.forms.SubmittableButton;
import nc.ird.cantharella.web.utils.forms.SubmittableButtonEvents;
import nc.ird.cantharella.web.utils.panels.SimpleTooltipPanel;
import nc.ird.cantharella.web.utils.security.AuthRole;
import nc.ird.cantharella.web.utils.security.AuthRoles;
import nc.ird.module.utils.BeanTools;
import nc.ird.module.utils.CollectionTools;
import nc.ird.module.utils.LogTools;
import org.apache.commons.logging.Log;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.Page;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.markup.html.form.DateTextField;
import org.apache.wicket.extensions.yui.calendar.DatePicker;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.MultiLineLabel;
import org.apache.wicket.markup.html.form.AbstractSingleSelectChoice;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.IFormSubmittingComponent;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.apache.wicket.util.string.StringValueConversionException;

@AuthRoles(value={AuthRole.ADMIN, AuthRole.USER})
public final class ManageExtractionPage
extends TemplatePage {
    private static final String ACTION_CREATE = "Create";
    private static final String ACTION_UPDATE = "Update";
    public static final String ACTION_DELETE = "Delete";
    private static final Log LOG = LogTools.getLog();
    private final IModel<Extraction> extractionModel;
    private IModel<Extrait> newExtraitModel;
    @SpringBean
    private ExtractionService extractionService;
    @SpringBean
    private PersonneService personneService;
    @SpringBean
    private ProduitService produitService;
    @SpringBean
    private LotService lotService;
    private final List<Personne> personnes;
    private final List<MethodeExtraction> methodes;
    private List<TypeExtrait> typesExtrait;
    private List<Lot> lots;
    @SpringBean(name="webModelValidator")
    private ModelValidator validator;
    private final CallerPage callerPage;
    private boolean multipleEntry;
    private boolean createMode;
    private HashMap<String, Integer> extraitsDeleted;
    private MarkupContainer extraitsTable;
    private AbstractSingleSelectChoice<TypeExtrait> typeExtraitInput;
    private SimpleTooltipPanel typeExtraitTooltip;
    private FormComponent<String> refInput;
    private FormComponent<BigDecimal> masseObtenueInput;
    private Button addExtraitButton;
    private static final String PATTERN_REF_EXTRAIT = "%s%s";

    public ManageExtractionPage(CallerPage callerPage, boolean bl) {
        this(null, null, callerPage, bl);
    }

    public ManageExtractionPage(Integer n, CallerPage callerPage) {
        this(n, null, callerPage, false);
    }

    public ManageExtractionPage(Extraction extraction, CallerPage callerPage) {
        this(null, extraction, callerPage, true);
    }

    private ManageExtractionPage(Integer n, Extraction extraction, CallerPage callerPage, boolean bl) {
        super(ManageExtractionPage.class);
        assert (n == null || extraction == null);
        this.callerPage = callerPage;
        this.multipleEntry = bl;
        this.extraitsDeleted = new HashMap();
        this.newExtraitModel = new Model((Serializable)new Extrait());
        try {
            this.extractionModel = new Model((Serializable)(n == null && extraction == null ? new Extraction() : (extraction != null ? extraction : this.extractionService.loadExtraction(n))));
        }
        catch (DataNotFoundException dataNotFoundException) {
            LOG.error((Object)dataNotFoundException.getMessage(), (Throwable)dataNotFoundException);
            throw new UnexpectedException((Exception)((Object)dataNotFoundException));
        }
        boolean bl2 = this.createMode = n == null;
        if (this.createMode) {
            ((Extraction)this.extractionModel.getObject()).setCreateur((Personne)this.getSession().getUtilisateur());
        }
        this.personnes = this.personneService.listPersonnes();
        this.methodes = this.extractionService.listMethodesExtraction();
        this.lots = this.lotService.listLots(this.getSession().getUtilisateur());
        if (extraction != null) {
            ((Extraction)this.extractionModel.getObject()).setManipulateur((Personne)CollectionTools.findWithValue((List)this.personnes, (String)"idPersonne", (BeanTools.AccessType)BeanTools.AccessType.GETTER, (Object)((Extraction)this.extractionModel.getObject()).getManipulateur().getIdPersonne()));
            ((Extraction)this.extractionModel.getObject()).setMethode((MethodeExtraction)CollectionTools.findWithValue((List)this.methodes, (String)"idMethodeExtraction", (BeanTools.AccessType)BeanTools.AccessType.GETTER, (Object)((Extraction)this.extractionModel.getObject()).getMethode().getIdMethodeExtraction()));
        }
        this.typesExtrait = new ArrayList();
        Form form = new Form("Form");
        this.initPrincipalFields(form);
        this.initMethodeFields(form);
        this.initExtraitsFields(form);
        SubmittableButton submittableButton = new SubmittableButton(ACTION_CREATE, (SubmittableButtonEvents)new /* Unavailable Anonymous Inner Class!! */);
        submittableButton.setVisibilityAllowed(this.createMode);
        form.add(new Component[]{submittableButton});
        SubmittableButton submittableButton2 = new SubmittableButton(ACTION_UPDATE, ManageExtractionPage.class, (SubmittableButtonEvents)new /* Unavailable Anonymous Inner Class!! */);
        submittableButton2.setVisibilityAllowed(!this.createMode);
        form.add(new Component[]{submittableButton2});
        SubmittableButton submittableButton3 = new SubmittableButton(ACTION_DELETE, (SubmittableButtonEvents)new /* Unavailable Anonymous Inner Class!! */);
        submittableButton3.setVisibilityAllowed(!this.createMode);
        submittableButton3.setDefaultFormProcessing(false);
        submittableButton3.add(new Behavior[]{new JSConfirmationBehavior(this.getString("Confirm"))});
        form.add(new Component[]{submittableButton3});
        form.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
        form.setDefaultButton((IFormSubmittingComponent)this.addExtraitButton);
        this.add(new Component[]{form});
    }

    private void initPrincipalFields(Form<Void> form) {
        form.add(new Component[]{new TextField("Extraction.ref", (IModel)new PropertyModel((Object)this.extractionModel, "ref"))});
        DropDownChoice dropDownChoice = new DropDownChoice("Extraction.manipulateur", (IModel)new PropertyModel((Object)this.extractionModel, "manipulateur"), this.personnes, (IChoiceRenderer)new PersonneRenderer());
        dropDownChoice.setNullValid(false);
        dropDownChoice.setModelObject((Object)((Extraction)this.extractionModel.getObject()).getManipulateur());
        form.add(new Component[]{dropDownChoice});
        dropDownChoice.getChoices().indexOf(dropDownChoice.getModelObject());
        form.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
        form.add(new Component[]{new DateTextField("Extraction.date", (IModel)new PropertyModel((Object)this.extractionModel, "date")).add(new Behavior[]{new DatePicker()})});
        DropDownChoice dropDownChoice2 = new DropDownChoice("Extraction.lot", (IModel)new PropertyModel((Object)this.extractionModel, "lot"), this.lots);
        dropDownChoice2.setNullValid(false);
        dropDownChoice2.setEnabled(this.createMode);
        dropDownChoice2.add(new Behavior[]{new /* Unavailable Anonymous Inner Class!! */});
        form.add(new Component[]{dropDownChoice2});
        7 var4_4 = new /* Unavailable Anonymous Inner Class!! */;
        var4_4.setOutputMarkupPlaceholderTag(true);
        var4_4.setVisibilityAllowed(this.createMode);
        form.add(new Component[]{var4_4});
        TextField textField = new TextField("Extraction.masseDepart", (IModel)new PropertyModel((Object)this.extractionModel, "masseDepart"));
        textField.add(new Behavior[]{new /* Unavailable Anonymous Inner Class!! */});
        form.add(new Component[]{textField});
        form.add(new Component[]{new TextArea("Extraction.complement", (IModel)new PropertyModel((Object)this.extractionModel, "complement"))});
        form.add(new Component[]{new TextField("Extraction.createur", (IModel)new PropertyModel((Object)this.extractionModel, "createur")).setEnabled(false)});
    }

    private void initMethodeFields(Form<Void> form) {
        9 var2_2 = new /* Unavailable Anonymous Inner Class!! */;
        var2_2.setOutputMarkupId(true);
        var2_2.setOutputMarkupPlaceholderTag(true);
        form.add(new Component[]{var2_2});
        var2_2.add(new Component[]{new MultiLineLabel("Extraction.methode.description", (IModel)new PropertyModel((Object)this.extractionModel, "methode.description"))});
        DropDownChoice dropDownChoice = new DropDownChoice("Extraction.methode.nom", (IModel)new PropertyModel((Object)this.extractionModel, "methode"), this.methodes);
        dropDownChoice.setNullValid(false);
        dropDownChoice.setOutputMarkupId(true);
        dropDownChoice.add(new Behavior[]{new /* Unavailable Anonymous Inner Class!! */});
        form.add(new Component[]{dropDownChoice});
    }

    private void initExtraitsFields(Form<Void> form) {
        this.extraitsTable = new WebMarkupContainer("Extraction.extraits.Table");
        this.extraitsTable.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
        this.extraitsTable.setOutputMarkupId(true);
        this.typeExtraitInput = new DropDownChoice("Extraction.extraits.typeExtrait", (IModel)new PropertyModel((Object)this.newExtraitModel, "typeExtrait"), this.typesExtrait).setNullValid(false);
        this.typeExtraitTooltip = new SimpleTooltipPanel("Extraction.extraits.typeExtrait.info", (IModel)new PropertyModel((Object)this.newExtraitModel, "typeExtrait.description"));
        this.typeExtraitTooltip.setOutputMarkupId(true);
        this.typeExtraitTooltip.setOutputMarkupPlaceholderTag(true);
        this.extraitsTable.add(new Component[]{this.typeExtraitTooltip});
        this.typeExtraitInput.add(new Behavior[]{new /* Unavailable Anonymous Inner Class!! */});
        this.extraitsTable.add(new Component[]{this.typeExtraitInput});
        this.refInput = new TextField("Extraction.extraits.ref", (IModel)new PropertyModel((Object)this.newExtraitModel, "ref"));
        this.refInput.setOutputMarkupId(true);
        this.extraitsTable.add(new Component[]{this.refInput});
        this.masseObtenueInput = new TextField("Extraction.extraits.masseObtenue", (IModel)new PropertyModel((Object)this.newExtraitModel, "masseObtenue"));
        this.masseObtenueInput.setOutputMarkupId(true);
        this.extraitsTable.add(new Component[]{this.masseObtenueInput});
        this.addExtraitButton = new /* Unavailable Anonymous Inner Class!! */;
        this.addExtraitButton.setOutputMarkupId(true);
        this.extraitsTable.add(new Component[]{this.addExtraitButton});
        form.add(new Component[]{this.extraitsTable});
        this.updateTypesExtrait(true, null);
    }

    protected void onBeforeRender() {
        this.refreshModel();
        super.onBeforeRender();
    }

    private void redirect() {
        if (this.multipleEntry) {
            Extraction extraction = new Extraction();
            extraction.setManipulateur(((Extraction)this.extractionModel.getObject()).getManipulateur());
            extraction.setMethode(((Extraction)this.extractionModel.getObject()).getMethode());
            extraction.setMasseDepart(((Extraction)this.extractionModel.getObject()).getMasseDepart());
            this.setResponsePage((Page)new ManageExtractionPage(extraction, this.callerPage));
        } else if (this.callerPage != null) {
            this.callerPage.addPageParameter(Extraction.class.getSimpleName(), (Object)((Extraction)this.extractionModel.getObject()).getIdExtraction());
            this.callerPage.responsePage((TemplatePage)this);
        }
    }

    private void refreshModel() {
        Personne personne;
        String string = Personne.class.getSimpleName();
        if (this.getPageParameters().getNamedKeys().contains(string)) {
            CollectionTools.setter((Collection)this.personnes, (Collection)this.personneService.listPersonnes());
            try {
                personne = this.personneService.loadPersonne(Integer.valueOf(this.getPageParameters().get(string).toInt()));
                ((Extraction)this.extractionModel.getObject()).setManipulateur(personne);
            }
            catch (StringValueConversionException stringValueConversionException) {
                LOG.error((Object)stringValueConversionException.getMessage(), (Throwable)stringValueConversionException);
                throw new UnexpectedException((Exception)((Object)stringValueConversionException));
            }
            catch (DataNotFoundException dataNotFoundException) {
                LOG.error((Object)dataNotFoundException.getMessage(), (Throwable)dataNotFoundException);
                throw new UnexpectedException((Exception)((Object)dataNotFoundException));
            }
            this.getPageParameters().remove(string);
        }
        string = Lot.class.getSimpleName();
        if (this.getPageParameters().getNamedKeys().contains(string)) {
            CollectionTools.setter((Collection)this.lots, (Collection)this.lotService.listLots(this.getSession().getUtilisateur()));
            try {
                personne = this.lotService.loadLot(Integer.valueOf(this.getPageParameters().get(string).toInt()));
                ((Extraction)this.extractionModel.getObject()).setLot((Lot)personne);
            }
            catch (StringValueConversionException stringValueConversionException) {
                LOG.error((Object)stringValueConversionException.getMessage(), (Throwable)stringValueConversionException);
                throw new UnexpectedException((Exception)((Object)stringValueConversionException));
            }
            catch (DataNotFoundException dataNotFoundException) {
                LOG.error((Object)dataNotFoundException.getMessage(), (Throwable)dataNotFoundException);
                throw new UnexpectedException((Exception)((Object)dataNotFoundException));
            }
            this.getPageParameters().remove(string);
        }
        this.updateRefExtrait(null);
    }

    private void updateRefExtrait(AjaxRequestTarget ajaxRequestTarget) {
        if (((Extraction)this.extractionModel.getObject()).getLot() != null && ((Extrait)this.newExtraitModel.getObject()).getTypeExtrait() != null) {
            ((Extrait)this.newExtraitModel.getObject()).setRef(String.format(PATTERN_REF_EXTRAIT, ((Extraction)this.extractionModel.getObject()).getLot().getRef(), ((Extrait)this.newExtraitModel.getObject()).getTypeExtrait().getInitiales()));
            if (ajaxRequestTarget != null) {
                ajaxRequestTarget.add(new Component[]{this.refInput});
            }
        }
    }

    private void updateTypesExtrait(boolean bl, AjaxRequestTarget ajaxRequestTarget) {
        if (((Extraction)this.extractionModel.getObject()).getMethode() != null) {
            CollectionTools.setter((Collection)this.typesExtrait, (Collection)((Extraction)this.extractionModel.getObject()).getMethode().getSortedTypesEnSortie());
            for (Extrait extrait : ((Extraction)this.extractionModel.getObject()).getExtraits()) {
                this.typesExtrait.remove(extrait.getTypeExtrait());
            }
        }
        this.configureExtraitInputs();
        if (bl) {
            ((Extrait)this.newExtraitModel.getObject()).setTypeExtrait(this.typeExtraitInput.getChoices().isEmpty() ? null : (TypeExtrait)this.typeExtraitInput.getChoices().get(0));
        }
        this.updateRefExtrait(ajaxRequestTarget);
        if (ajaxRequestTarget != null) {
            ajaxRequestTarget.add(new Component[]{this.typeExtraitInput, this.typeExtraitTooltip, this.refInput, this.masseObtenueInput, this.addExtraitButton});
        }
    }

    private void configureExtraitInputs() {
        if (((Extraction)this.extractionModel.getObject()).getMethode() == null || ((Extraction)this.extractionModel.getObject()).getExtraits() != null && ((Extraction)this.extractionModel.getObject()).getExtraits().size() == ((Extraction)this.extractionModel.getObject()).getMethode().getTypesEnSortie().size()) {
            this.disableExtraitAdding();
        } else {
            this.enableExtraitAdding();
        }
    }

    private void enableExtraitAdding() {
        this.typeExtraitInput.setEnabled(true);
        this.typeExtraitTooltip.setVisibilityAllowed(true);
        this.refInput.setEnabled(true);
        this.masseObtenueInput.setEnabled(true);
        this.addExtraitButton.setEnabled(true);
    }

    private void disableExtraitAdding() {
        this.typeExtraitInput.setEnabled(false);
        this.typeExtraitTooltip.setVisibilityAllowed(false);
        this.refInput.setEnabled(false);
        this.masseObtenueInput.setEnabled(false);
        this.addExtraitButton.setEnabled(false);
    }

    private void validateModel() {
        this.addValidationErrors((Collection)this.validator.validate(this.extractionModel.getObject(), this.getSession().getLocale(), new String[0]));
        if (!this.extractionService.isExtractionUnique((Extraction)this.extractionModel.getObject())) {
            this.error((Serializable)((Object)this.getString("Extraction.notUnique")));
        }
    }

    static /* synthetic */ IModel access$000(ManageExtractionPage manageExtractionPage) {
        return manageExtractionPage.extractionModel;
    }

    static /* synthetic */ ExtractionService access$100(ManageExtractionPage manageExtractionPage) {
        return manageExtractionPage.extractionService;
    }

    static /* synthetic */ void access$200(ManageExtractionPage manageExtractionPage) {
        manageExtractionPage.redirect();
    }

    static /* synthetic */ void access$300(ManageExtractionPage manageExtractionPage) {
        manageExtractionPage.validateModel();
    }

    static /* synthetic */ void access$400(ManageExtractionPage manageExtractionPage, AjaxRequestTarget ajaxRequestTarget) {
        manageExtractionPage.updateRefExtrait(ajaxRequestTarget);
    }

    static /* synthetic */ List access$500(ManageExtractionPage manageExtractionPage) {
        return manageExtractionPage.typesExtrait;
    }

    static /* synthetic */ void access$600(ManageExtractionPage manageExtractionPage, boolean bl, AjaxRequestTarget ajaxRequestTarget) {
        manageExtractionPage.updateTypesExtrait(bl, ajaxRequestTarget);
    }

    static /* synthetic */ ProduitService access$700(ManageExtractionPage manageExtractionPage) {
        return manageExtractionPage.produitService;
    }

    static /* synthetic */ HashMap access$800(ManageExtractionPage manageExtractionPage) {
        return manageExtractionPage.extraitsDeleted;
    }

    static /* synthetic */ MarkupContainer access$900(ManageExtractionPage manageExtractionPage) {
        return manageExtractionPage.extraitsTable;
    }

    static /* synthetic */ void access$1000(ManageExtractionPage manageExtractionPage, AjaxRequestTarget ajaxRequestTarget) {
        manageExtractionPage.refreshFeedbackPage(ajaxRequestTarget);
    }

    static /* synthetic */ SimpleTooltipPanel access$1100(ManageExtractionPage manageExtractionPage) {
        return manageExtractionPage.typeExtraitTooltip;
    }

    static /* synthetic */ IModel access$1200(ManageExtractionPage manageExtractionPage) {
        return manageExtractionPage.newExtraitModel;
    }

    static /* synthetic */ ModelValidator access$1300(ManageExtractionPage manageExtractionPage) {
        return manageExtractionPage.validator;
    }

    static /* synthetic */ Log access$1400() {
        return LOG;
    }

    static /* synthetic */ void access$1500(ManageExtractionPage manageExtractionPage, AjaxRequestTarget ajaxRequestTarget) {
        manageExtractionPage.refreshFeedbackPage(ajaxRequestTarget);
    }

    static /* synthetic */ void access$1600(ManageExtractionPage manageExtractionPage, AjaxRequestTarget ajaxRequestTarget) {
        manageExtractionPage.refreshFeedbackPage(ajaxRequestTarget);
    }
}

