/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.web.pages.domain.config;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import nc.ird.cantharella.data.exceptions.DataNotFoundException;
import nc.ird.cantharella.data.exceptions.UnexpectedException;
import nc.ird.cantharella.data.model.MethodeTestBio;
import nc.ird.cantharella.data.validation.utils.ModelValidator;
import nc.ird.cantharella.service.services.TestBioService;
import nc.ird.cantharella.web.pages.TemplatePage;
import nc.ird.cantharella.web.utils.behaviors.JSConfirmationBehavior;
import nc.ird.cantharella.web.utils.forms.AutoCompleteTextFieldString;
import nc.ird.cantharella.web.utils.forms.SubmittableButton;
import nc.ird.cantharella.web.utils.forms.SubmittableButtonEvents;
import nc.ird.cantharella.web.utils.security.AuthRole;
import nc.ird.cantharella.web.utils.security.AuthRoles;
import nc.ird.module.utils.LogTools;
import org.apache.commons.logging.Log;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.spring.injection.annot.SpringBean;

@AuthRoles(value={AuthRole.ADMIN})
public final class ManageMethodeTestBioPage
extends TemplatePage {
    private static final String ACTION_CREATE = "Create";
    private static final String ACTION_UPDATE = "Update";
    public static final String ACTION_DELETE = "Delete";
    private final String[] RETURN_PARAM = new String[]{"methodeTestBio", "opened"};
    private static final Log LOG = LogTools.getLog();
    private final IModel<MethodeTestBio> methodeTestModel;
    @SpringBean
    private TestBioService testService;
    @SpringBean(name="webModelValidator")
    private ModelValidator validator;

    public ManageMethodeTestBioPage() {
        this(null);
    }

    public ManageMethodeTestBioPage(Integer n) {
        super(ManageMethodeTestBioPage.class);
        boolean bl;
        if (n == null) {
            this.methodeTestModel = new Model((Serializable)new MethodeTestBio());
            bl = true;
        } else {
            try {
                this.methodeTestModel = new Model((Serializable)this.testService.loadMethodeTest(n));
            }
            catch (DataNotFoundException dataNotFoundException) {
                LOG.error((Object)dataNotFoundException.getMessage(), (Throwable)dataNotFoundException);
                throw new UnexpectedException((Exception)((Object)dataNotFoundException));
            }
            bl = false;
        }
        List list = this.testService.listDomainesMethodes();
        List list2 = this.testService.listUnitesResultatMethodes();
        Form form = new Form("Form");
        form.add(new Component[]{new TextField("MethodeTestBio.nom", (IModel)new PropertyModel((Object)this.methodeTestModel, "nom"))});
        form.add(new Component[]{new TextField("MethodeTestBio.cible", (IModel)new PropertyModel((Object)this.methodeTestModel, "cible"))});
        form.add(new Component[]{new AutoCompleteTextFieldString("MethodeTestBio.domaine", (IModel)new PropertyModel((Object)this.methodeTestModel, "domaine"), list, AutoCompleteTextFieldString.ComparisonMode.CONTAINS)});
        form.add(new Component[]{new TextArea("MethodeTestBio.description", (IModel)new PropertyModel((Object)this.methodeTestModel, "description"))});
        form.add(new Component[]{new TextField("MethodeTestBio.valeurMesuree", (IModel)new PropertyModel((Object)this.methodeTestModel, "valeurMesuree"))});
        form.add(new Component[]{new AutoCompleteTextFieldString("MethodeTestBio.uniteResultat", (IModel)new PropertyModel((Object)this.methodeTestModel, "uniteResultat"), list2, AutoCompleteTextFieldString.ComparisonMode.STARTS_WITH)});
        form.add(new Component[]{new TextField("MethodeTestBio.critereActivite", (IModel)new PropertyModel((Object)this.methodeTestModel, "critereActivite"))});
        SubmittableButton submittableButton = new SubmittableButton(ACTION_CREATE, (SubmittableButtonEvents)new /* Unavailable Anonymous Inner Class!! */);
        submittableButton.setVisibilityAllowed(bl);
        form.add(new Component[]{submittableButton});
        SubmittableButton submittableButton2 = new SubmittableButton(ACTION_UPDATE, (SubmittableButtonEvents)new /* Unavailable Anonymous Inner Class!! */);
        submittableButton2.setVisibilityAllowed(!bl);
        form.add(new Component[]{submittableButton2});
        SubmittableButton submittableButton3 = new SubmittableButton(ACTION_DELETE, (SubmittableButtonEvents)new /* Unavailable Anonymous Inner Class!! */);
        submittableButton3.setVisibilityAllowed(!bl);
        submittableButton3.setDefaultFormProcessing(false);
        submittableButton3.add(new Behavior[]{new JSConfirmationBehavior(this.getString("Confirm"))});
        form.add(new Component[]{submittableButton3});
        form.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
        this.add(new Component[]{form});
    }

    private void validateModel() {
        this.addValidationErrors((Collection)this.validator.validate(this.methodeTestModel.getObject(), this.getSession().getLocale(), new String[0]));
    }

    static /* synthetic */ IModel access$000(ManageMethodeTestBioPage manageMethodeTestBioPage) {
        return manageMethodeTestBioPage.methodeTestModel;
    }

    static /* synthetic */ TestBioService access$100(ManageMethodeTestBioPage manageMethodeTestBioPage) {
        return manageMethodeTestBioPage.testService;
    }

    static /* synthetic */ String[] access$200(ManageMethodeTestBioPage manageMethodeTestBioPage) {
        return manageMethodeTestBioPage.RETURN_PARAM;
    }

    static /* synthetic */ void access$300(ManageMethodeTestBioPage manageMethodeTestBioPage) {
        manageMethodeTestBioPage.validateModel();
    }
}

