/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.web.pages.domain.config;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import nc.ird.cantharella.data.exceptions.DataNotFoundException;
import nc.ird.cantharella.data.exceptions.UnexpectedException;
import nc.ird.cantharella.data.model.MethodePurification;
import nc.ird.cantharella.data.model.ParamMethoPuri;
import nc.ird.cantharella.data.validation.utils.ModelValidator;
import nc.ird.cantharella.service.services.PurificationService;
import nc.ird.cantharella.web.pages.TemplatePage;
import nc.ird.cantharella.web.pages.domain.config.ManageMethodePurificationPage;
import nc.ird.cantharella.web.utils.behaviors.JSConfirmationBehavior;
import nc.ird.cantharella.web.utils.forms.SubmittableButton;
import nc.ird.cantharella.web.utils.forms.SubmittableButtonEvents;
import nc.ird.cantharella.web.utils.security.AuthRole;
import nc.ird.cantharella.web.utils.security.AuthRoles;
import nc.ird.module.utils.LogTools;
import org.apache.commons.logging.Log;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IFormSubmittingComponent;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.spring.injection.annot.SpringBean;

@AuthRoles(value={AuthRole.ADMIN})
public final class ManageMethodePurificationPage
extends TemplatePage {
    private static final String ACTION_CREATE = "Create";
    private static final String ACTION_UPDATE = "Update";
    public static final String ACTION_DELETE = "Delete";
    private final String[] RETURN_PARAM = new String[]{"methodePurification", "opened"};
    private static final Log LOG = LogTools.getLog();
    private final IModel<MethodePurification> methodePurificationModel;
    private IModel<ParamMethoPuri> newParamModel;
    @SpringBean
    private PurificationService purificationService;
    @SpringBean(name="webModelValidator")
    private ModelValidator validator;
    private HashMap<String, ParamMethoPuri> paramsDeleted = new HashMap();

    public ManageMethodePurificationPage() {
        this(null);
    }

    public ManageMethodePurificationPage(Integer n) {
        super(ManageMethodePurificationPage.class);
        boolean bl;
        this.newParamModel = new Model((Serializable)new ParamMethoPuri());
        if (n == null) {
            this.methodePurificationModel = new Model((Serializable)new MethodePurification());
            bl = true;
        } else {
            try {
                this.methodePurificationModel = new Model((Serializable)this.purificationService.loadMethodePurification(n));
            }
            catch (DataNotFoundException dataNotFoundException) {
                LOG.error((Object)dataNotFoundException.getMessage(), (Throwable)dataNotFoundException);
                throw new UnexpectedException((Exception)((Object)dataNotFoundException));
            }
            bl = false;
        }
        Form form = new Form("Form");
        form.add(new Component[]{new TextField("MethodePurification.nom", (IModel)new PropertyModel((Object)this.methodePurificationModel, "nom"))});
        form.add(new Component[]{new TextArea("MethodePurification.description", (IModel)new PropertyModel((Object)this.methodePurificationModel, "description"))});
        WebMarkupContainer webMarkupContainer = new WebMarkupContainer("MethodePurification.parametres.Table");
        webMarkupContainer.setOutputMarkupId(true);
        webMarkupContainer.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
        TextField textField = new TextField("MethodePurification.parametres.nom", (IModel)new PropertyModel((Object)this.newParamModel, "nom"));
        webMarkupContainer.add(new Component[]{textField});
        TextField textField2 = new TextField("MethodePurification.parametres.description", (IModel)new PropertyModel((Object)this.newParamModel, "description"));
        webMarkupContainer.add(new Component[]{textField2});
        TextField textField3 = new TextField("MethodePurification.parametres.index", (IModel)new PropertyModel((Object)this.newParamModel, "index"));
        webMarkupContainer.add(new Component[]{textField3});
        2 var8_9 = new /* Unavailable Anonymous Inner Class!! */;
        webMarkupContainer.add(new Component[]{var8_9});
        SubmittableButton submittableButton = new SubmittableButton(ACTION_CREATE, (SubmittableButtonEvents)new /* Unavailable Anonymous Inner Class!! */);
        submittableButton.setVisibilityAllowed(bl);
        form.add(new Component[]{submittableButton});
        form.add(new Component[]{webMarkupContainer});
        SubmittableButton submittableButton2 = new SubmittableButton(ACTION_UPDATE, (SubmittableButtonEvents)new /* Unavailable Anonymous Inner Class!! */);
        submittableButton2.setVisibilityAllowed(!bl);
        form.add(new Component[]{submittableButton2});
        SubmittableButton submittableButton3 = new SubmittableButton(ACTION_DELETE, (SubmittableButtonEvents)new /* Unavailable Anonymous Inner Class!! */);
        submittableButton3.setVisibilityAllowed(!bl);
        submittableButton3.setDefaultFormProcessing(false);
        submittableButton3.add(new Behavior[]{new JSConfirmationBehavior(this.getString("Confirm"))});
        form.add(new Component[]{submittableButton3});
        form.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
        form.setDefaultButton((IFormSubmittingComponent)var8_9);
        this.add(new Component[]{form});
    }

    private void validateModel() {
        this.addValidationErrors((Collection)this.validator.validate(this.methodePurificationModel.getObject(), this.getSession().getLocale(), new String[0]));
        for (ParamMethoPuri paramMethoPuri : this.paramsDeleted.values()) {
            if (!this.purificationService.isParamMethoPuriReferenced(paramMethoPuri)) continue;
            this.getPage().error((Serializable)((Object)this.getString("ParamMethoPuri.isReferenced", (IModel)new Model((Serializable)new Serializable[]{paramMethoPuri.getNom()}))));
        }
    }

    static /* synthetic */ IModel access$000(ManageMethodePurificationPage manageMethodePurificationPage) {
        return manageMethodePurificationPage.methodePurificationModel;
    }

    static /* synthetic */ HashMap access$100(ManageMethodePurificationPage manageMethodePurificationPage) {
        return manageMethodePurificationPage.paramsDeleted;
    }

    static /* synthetic */ IModel access$200(ManageMethodePurificationPage manageMethodePurificationPage) {
        return manageMethodePurificationPage.newParamModel;
    }

    static /* synthetic */ ModelValidator access$300(ManageMethodePurificationPage manageMethodePurificationPage) {
        return manageMethodePurificationPage.validator;
    }

    static /* synthetic */ Log access$400() {
        return LOG;
    }

    static /* synthetic */ void access$500(ManageMethodePurificationPage manageMethodePurificationPage, AjaxRequestTarget ajaxRequestTarget) {
        manageMethodePurificationPage.refreshFeedbackPage(ajaxRequestTarget);
    }

    static /* synthetic */ void access$600(ManageMethodePurificationPage manageMethodePurificationPage, AjaxRequestTarget ajaxRequestTarget) {
        manageMethodePurificationPage.refreshFeedbackPage(ajaxRequestTarget);
    }

    static /* synthetic */ PurificationService access$700(ManageMethodePurificationPage manageMethodePurificationPage) {
        return manageMethodePurificationPage.purificationService;
    }

    static /* synthetic */ String[] access$800(ManageMethodePurificationPage manageMethodePurificationPage) {
        return manageMethodePurificationPage.RETURN_PARAM;
    }

    static /* synthetic */ void access$900(ManageMethodePurificationPage manageMethodePurificationPage) {
        manageMethodePurificationPage.validateModel();
    }
}

