/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.web.pages.domain.config;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import nc.ird.cantharella.data.exceptions.DataNotFoundException;
import nc.ird.cantharella.data.exceptions.UnexpectedException;
import nc.ird.cantharella.data.model.MethodeExtraction;
import nc.ird.cantharella.data.model.TypeExtrait;
import nc.ird.cantharella.data.validation.utils.ModelValidator;
import nc.ird.cantharella.service.services.ExtractionService;
import nc.ird.cantharella.web.pages.TemplatePage;
import nc.ird.cantharella.web.pages.domain.config.ManageMethodeExtractionPage;
import nc.ird.cantharella.web.utils.behaviors.JSConfirmationBehavior;
import nc.ird.cantharella.web.utils.forms.SubmittableButton;
import nc.ird.cantharella.web.utils.forms.SubmittableButtonEvents;
import nc.ird.cantharella.web.utils.security.AuthRole;
import nc.ird.cantharella.web.utils.security.AuthRoles;
import nc.ird.module.utils.LogTools;
import org.apache.commons.logging.Log;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.IFormSubmittingComponent;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.spring.injection.annot.SpringBean;

@AuthRoles(value={AuthRole.ADMIN})
public final class ManageMethodeExtractionPage
extends TemplatePage {
    private static final String ACTION_CREATE = "Create";
    private static final String ACTION_UPDATE = "Update";
    public static final String ACTION_DELETE = "Delete";
    private final String[] RETURN_PARAM = new String[]{"methodeExtraction", "opened"};
    private static final Log LOG = LogTools.getLog();
    private final IModel<MethodeExtraction> methodeExtractionModel;
    private IModel<TypeExtrait> newTypeExtraitModel;
    @SpringBean
    private ExtractionService extraitService;
    @SpringBean(name="webModelValidator")
    private ModelValidator validator;
    private HashMap<String, TypeExtrait> typesDeleted = new HashMap();

    public ManageMethodeExtractionPage() {
        this(null);
    }

    public ManageMethodeExtractionPage(Integer n) {
        super(ManageMethodeExtractionPage.class);
        boolean bl;
        this.newTypeExtraitModel = new Model((Serializable)new TypeExtrait());
        if (n == null) {
            this.methodeExtractionModel = new Model((Serializable)new MethodeExtraction());
            bl = true;
        } else {
            try {
                this.methodeExtractionModel = new Model((Serializable)this.extraitService.loadMethodeExtraction(n));
            }
            catch (DataNotFoundException dataNotFoundException) {
                LOG.error((Object)dataNotFoundException.getMessage(), (Throwable)dataNotFoundException);
                throw new UnexpectedException((Exception)((Object)dataNotFoundException));
            }
            bl = false;
        }
        Form form = new Form("Form");
        form.add(new Component[]{new TextField("MethodeExtraction.nom", (IModel)new PropertyModel((Object)this.methodeExtractionModel, "nom"))});
        form.add(new Component[]{new TextArea("MethodeExtraction.description", (IModel)new PropertyModel((Object)this.methodeExtractionModel, "description"))});
        WebMarkupContainer webMarkupContainer = new WebMarkupContainer("MethodeExtraction.typesEnSortie.Table");
        webMarkupContainer.setOutputMarkupId(true);
        webMarkupContainer.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
        TextField textField = new TextField("MethodeExtraction.typesEnSortie.initiales", (IModel)new PropertyModel((Object)this.newTypeExtraitModel, "initiales"));
        webMarkupContainer.add(new Component[]{textField});
        TextField textField2 = new TextField("MethodeExtraction.typesEnSortie.description", (IModel)new PropertyModel((Object)this.newTypeExtraitModel, "description"));
        webMarkupContainer.add(new Component[]{textField2});
        2 var7_8 = new /* Unavailable Anonymous Inner Class!! */;
        webMarkupContainer.add(new Component[]{var7_8});
        SubmittableButton submittableButton = new SubmittableButton(ACTION_CREATE, (SubmittableButtonEvents)new /* Unavailable Anonymous Inner Class!! */);
        submittableButton.setVisibilityAllowed(bl);
        form.add(new Component[]{submittableButton});
        form.add(new Component[]{webMarkupContainer});
        SubmittableButton submittableButton2 = new SubmittableButton(ACTION_UPDATE, (SubmittableButtonEvents)new /* Unavailable Anonymous Inner Class!! */);
        submittableButton2.setVisibilityAllowed(!bl);
        form.add(new Component[]{submittableButton2});
        SubmittableButton submittableButton3 = new SubmittableButton(ACTION_DELETE, (SubmittableButtonEvents)new /* Unavailable Anonymous Inner Class!! */);
        submittableButton3.setVisibilityAllowed(!bl);
        submittableButton3.setDefaultFormProcessing(false);
        submittableButton3.add(new Behavior[]{new JSConfirmationBehavior(this.getString("Confirm"))});
        form.add(new Component[]{submittableButton3});
        form.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
        form.setDefaultButton((IFormSubmittingComponent)var7_8);
        this.add(new Component[]{form});
    }

    private void validateModel() {
        this.addValidationErrors((Collection)this.validator.validate(this.methodeExtractionModel.getObject(), this.getSession().getLocale(), new String[0]));
        for (TypeExtrait typeExtrait : this.typesDeleted.values()) {
            if (!this.extraitService.isTypeExtraitReferenced(typeExtrait)) continue;
            this.getPage().error((Serializable)((Object)this.getString("TypeExtrait.isReferenced", (IModel)new Model((Serializable)new Serializable[]{typeExtrait.getInitiales()}))));
        }
    }

    static /* synthetic */ IModel access$000(ManageMethodeExtractionPage manageMethodeExtractionPage) {
        return manageMethodeExtractionPage.methodeExtractionModel;
    }

    static /* synthetic */ HashMap access$100(ManageMethodeExtractionPage manageMethodeExtractionPage) {
        return manageMethodeExtractionPage.typesDeleted;
    }

    static /* synthetic */ IModel access$200(ManageMethodeExtractionPage manageMethodeExtractionPage) {
        return manageMethodeExtractionPage.newTypeExtraitModel;
    }

    static /* synthetic */ ModelValidator access$300(ManageMethodeExtractionPage manageMethodeExtractionPage) {
        return manageMethodeExtractionPage.validator;
    }

    static /* synthetic */ Log access$400() {
        return LOG;
    }

    static /* synthetic */ void access$500(ManageMethodeExtractionPage manageMethodeExtractionPage, AjaxRequestTarget ajaxRequestTarget) {
        manageMethodeExtractionPage.refreshFeedbackPage(ajaxRequestTarget);
    }

    static /* synthetic */ void access$600(ManageMethodeExtractionPage manageMethodeExtractionPage, AjaxRequestTarget ajaxRequestTarget) {
        manageMethodeExtractionPage.refreshFeedbackPage(ajaxRequestTarget);
    }

    static /* synthetic */ ExtractionService access$700(ManageMethodeExtractionPage manageMethodeExtractionPage) {
        return manageMethodeExtractionPage.extraitService;
    }

    static /* synthetic */ String[] access$800(ManageMethodeExtractionPage manageMethodeExtractionPage) {
        return manageMethodeExtractionPage.RETURN_PARAM;
    }

    static /* synthetic */ void access$900(ManageMethodeExtractionPage manageMethodeExtractionPage) {
        manageMethodeExtractionPage.validateModel();
    }
}

