/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.web.pages.domain.config;

import java.io.Serializable;
import java.util.Collection;
import nc.ird.cantharella.data.exceptions.DataNotFoundException;
import nc.ird.cantharella.data.exceptions.UnexpectedException;
import nc.ird.cantharella.data.model.ErreurTestBio;
import nc.ird.cantharella.data.validation.utils.ModelValidator;
import nc.ird.cantharella.service.services.TestBioService;
import nc.ird.cantharella.web.pages.TemplatePage;
import nc.ird.cantharella.web.utils.behaviors.JSConfirmationBehavior;
import nc.ird.cantharella.web.utils.forms.SubmittableButton;
import nc.ird.cantharella.web.utils.forms.SubmittableButtonEvents;
import nc.ird.cantharella.web.utils.security.AuthRole;
import nc.ird.cantharella.web.utils.security.AuthRoles;
import nc.ird.module.utils.LogTools;
import org.apache.commons.logging.Log;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.spring.injection.annot.SpringBean;

@AuthRoles(value={AuthRole.ADMIN})
public final class ManageErreurTestBioPage
extends TemplatePage {
    private static final String ACTION_CREATE = "Create";
    private static final String ACTION_UPDATE = "Update";
    public static final String ACTION_DELETE = "Delete";
    private final String[] RETURN_PARAM = new String[]{"erreurTestBio", "opened"};
    private static final Log LOG = LogTools.getLog();
    private final IModel<ErreurTestBio> erreurTestModel;
    @SpringBean
    private TestBioService testService;
    @SpringBean(name="webModelValidator")
    private ModelValidator validator;

    public ManageErreurTestBioPage() {
        this(null);
    }

    public ManageErreurTestBioPage(Integer n) {
        super(ManageErreurTestBioPage.class);
        boolean bl;
        if (n == null) {
            this.erreurTestModel = new Model((Serializable)new ErreurTestBio());
            bl = true;
        } else {
            try {
                this.erreurTestModel = new Model((Serializable)this.testService.loadErreurTestBio(n));
            }
            catch (DataNotFoundException dataNotFoundException) {
                LOG.error((Object)dataNotFoundException.getMessage(), (Throwable)dataNotFoundException);
                throw new UnexpectedException((Exception)((Object)dataNotFoundException));
            }
            bl = false;
        }
        Form form = new Form("Form");
        form.add(new Component[]{new TextField("ErreurTestBio.nom", (IModel)new PropertyModel((Object)this.erreurTestModel, "nom"))});
        form.add(new Component[]{new TextArea("ErreurTestBio.description", (IModel)new PropertyModel((Object)this.erreurTestModel, "description"))});
        SubmittableButton submittableButton = new SubmittableButton(ACTION_CREATE, (SubmittableButtonEvents)new /* Unavailable Anonymous Inner Class!! */);
        submittableButton.setVisibilityAllowed(bl);
        form.add(new Component[]{submittableButton});
        SubmittableButton submittableButton2 = new SubmittableButton(ACTION_UPDATE, (SubmittableButtonEvents)new /* Unavailable Anonymous Inner Class!! */);
        submittableButton2.setVisibilityAllowed(!bl);
        form.add(new Component[]{submittableButton2});
        SubmittableButton submittableButton3 = new SubmittableButton(ACTION_DELETE, (SubmittableButtonEvents)new /* Unavailable Anonymous Inner Class!! */);
        submittableButton3.setVisibilityAllowed(!bl);
        submittableButton3.setDefaultFormProcessing(false);
        submittableButton3.add(new Behavior[]{new JSConfirmationBehavior(this.getString("Confirm"))});
        form.add(new Component[]{submittableButton3});
        form.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
        this.add(new Component[]{form});
    }

    private void validateModel() {
        this.addValidationErrors((Collection)this.validator.validate(this.erreurTestModel.getObject(), this.getSession().getLocale(), new String[0]));
    }

    static /* synthetic */ IModel access$000(ManageErreurTestBioPage manageErreurTestBioPage) {
        return manageErreurTestBioPage.erreurTestModel;
    }

    static /* synthetic */ TestBioService access$100(ManageErreurTestBioPage manageErreurTestBioPage) {
        return manageErreurTestBioPage.testService;
    }

    static /* synthetic */ String[] access$200(ManageErreurTestBioPage manageErreurTestBioPage) {
        return manageErreurTestBioPage.RETURN_PARAM;
    }

    static /* synthetic */ void access$300(ManageErreurTestBioPage manageErreurTestBioPage) {
        manageErreurTestBioPage.validateModel();
    }
}

