/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.web.pages.domain.campagne;

import java.io.Serializable;
import java.util.Map;
import nc.ird.cantharella.data.model.Campagne;
import nc.ird.cantharella.service.services.CampagneService;
import nc.ird.cantharella.service.services.StationService;
import nc.ird.cantharella.web.config.WebContext;
import nc.ird.cantharella.web.pages.TemplatePage;
import nc.ird.cantharella.web.pages.domain.campagne.ManageCampagnePage;
import nc.ird.cantharella.web.pages.domain.campagne.ReadCampagnePage;
import nc.ird.cantharella.web.utils.CallerPage;
import nc.ird.cantharella.web.utils.behaviors.JSConfirmationBehavior;
import nc.ird.cantharella.web.utils.behaviors.ReplaceEmptyLabelBehavior;
import nc.ird.cantharella.web.utils.forms.SubmittableButton;
import nc.ird.cantharella.web.utils.forms.SubmittableButtonEvents;
import nc.ird.cantharella.web.utils.models.DisplayMapValuePropertyModel;
import nc.ird.cantharella.web.utils.models.GenericLoadableDetachableModel;
import nc.ird.cantharella.web.utils.panels.SimpleTooltipPanel;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.basic.MultiLineLabel;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.spring.injection.annot.SpringBean;

public final class ReadCampagnePage
extends TemplatePage {
    public static final String ACTION_DELETE = "Delete";
    private final CallerPage callerPage;
    private final IModel<Campagne> campagneModel;
    @SpringBean
    private CampagneService campagneService;
    @SpringBean
    private StationService stationService;

    public ReadCampagnePage(Integer n, CallerPage callerPage) {
        super(ReadCampagnePage.class);
        CallerPage callerPage2 = new CallerPage((TemplatePage)this.getPage());
        this.callerPage = callerPage;
        this.campagneModel = new GenericLoadableDetachableModel(Campagne.class, (Serializable)n);
        Campagne campagne = (Campagne)this.campagneModel.getObject();
        this.add(new Component[]{new Label("Campagne.nom", (IModel)new PropertyModel((Object)this.campagneModel, "nom")).add(new Behavior[]{new ReplaceEmptyLabelBehavior()})});
        this.add(new Component[]{new Label("Campagne.codePays", (IModel)new DisplayMapValuePropertyModel((Object)this.campagneModel, "codePays", (Map)WebContext.COUNTRIES.get(this.getSession().getLocale()))).add(new Behavior[]{new ReplaceEmptyLabelBehavior()})});
        this.add(new Component[]{new Label("Campagne.dateDeb", (IModel)new PropertyModel((Object)this.campagneModel, "dateDeb")).add(new Behavior[]{new ReplaceEmptyLabelBehavior()})});
        this.add(new Component[]{new Label("Campagne.dateFin", (IModel)new PropertyModel((Object)this.campagneModel, "dateFin")).add(new Behavior[]{new ReplaceEmptyLabelBehavior()})});
        this.add(new Component[]{new Label("Campagne.programme", (IModel)new PropertyModel((Object)this.campagneModel, "programme")).add(new Behavior[]{new ReplaceEmptyLabelBehavior()})});
        this.add(new Component[]{new MultiLineLabel("Campagne.mentionLegale", (IModel)new PropertyModel((Object)this.campagneModel, "mentionLegale")).add(new Behavior[]{new ReplaceEmptyLabelBehavior()})});
        this.add(new Component[]{new SimpleTooltipPanel("Campagne.mentionLegale.info", (IModel)new Model((Serializable)((Object)this.getString("Campagne.mentionLegale.info2"))))});
        this.add(new Component[]{new MultiLineLabel("Campagne.complement", (IModel)new PropertyModel((Object)this.campagneModel, "complement")).add(new Behavior[]{new ReplaceEmptyLabelBehavior()})});
        this.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
        this.initParticipantsFields(callerPage2);
        this.initStationsFields(callerPage2);
        Form form = new Form("Form");
        2 var6_6 = new /* Unavailable Anonymous Inner Class!! */;
        var6_6.setVisibilityAllowed(this.campagneService.updateOrdeleteCampagneEnabled(campagne, this.getSession().getUtilisateur()));
        form.add(new Component[]{var6_6});
        form.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
        SubmittableButton submittableButton = new SubmittableButton(ACTION_DELETE, ManageCampagnePage.class, (SubmittableButtonEvents)new /* Unavailable Anonymous Inner Class!! */);
        submittableButton.setVisibilityAllowed(this.campagneService.updateOrdeleteCampagneEnabled(campagne, this.getSession().getUtilisateur()));
        submittableButton.add(new Behavior[]{new JSConfirmationBehavior(this.getString("Confirm"))});
        form.add(new Component[]{submittableButton});
        this.add(new Component[]{form});
    }

    private void initParticipantsFields(CallerPage callerPage) {
        5 var2_2 = new /* Unavailable Anonymous Inner Class!! */;
        6 var3_3 = new /* Unavailable Anonymous Inner Class!! */;
        var3_3.add(new Component[]{var2_2});
        this.add(new Component[]{var3_3});
        7 var4_4 = new /* Unavailable Anonymous Inner Class!! */;
        this.add(new Component[]{var4_4});
    }

    private void initStationsFields(CallerPage callerPage) {
        8 var2_2 = new /* Unavailable Anonymous Inner Class!! */;
        this.add(new Component[]{var2_2});
        WebMarkupContainer webMarkupContainer = new WebMarkupContainer("Campagne.stations.stationsNotAccessibles");
        webMarkupContainer.setOutputMarkupPlaceholderTag(true);
        var2_2.add(new Component[]{webMarkupContainer});
        9 var4_4 = new /* Unavailable Anonymous Inner Class!! */;
        10 var5_5 = new /* Unavailable Anonymous Inner Class!! */;
        var2_2.add(new Component[]{var5_5});
        11 var6_6 = new /* Unavailable Anonymous Inner Class!! */;
        this.add(new Component[]{var6_6});
    }

    private void redirect() {
        this.callerPage.responsePage((TemplatePage)this);
    }

    static /* synthetic */ void access$000(ReadCampagnePage readCampagnePage) {
        readCampagnePage.redirect();
    }

    static /* synthetic */ CampagneService access$100(ReadCampagnePage readCampagnePage) {
        return readCampagnePage.campagneService;
    }

    static /* synthetic */ IModel access$200(ReadCampagnePage readCampagnePage) {
        return readCampagnePage.campagneModel;
    }

    static /* synthetic */ StationService access$300(ReadCampagnePage readCampagnePage) {
        return readCampagnePage.stationService;
    }
}

