/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.web.pages.domain.campagne;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import nc.ird.cantharella.data.exceptions.DataNotFoundException;
import nc.ird.cantharella.data.exceptions.UnexpectedException;
import nc.ird.cantharella.data.model.Campagne;
import nc.ird.cantharella.data.model.CampagnePersonneParticipant;
import nc.ird.cantharella.data.model.Personne;
import nc.ird.cantharella.data.model.Station;
import nc.ird.cantharella.data.model.utils.AbstractModel;
import nc.ird.cantharella.data.validation.utils.ModelValidator;
import nc.ird.cantharella.service.services.CampagneService;
import nc.ird.cantharella.service.services.PersonneService;
import nc.ird.cantharella.service.services.StationService;
import nc.ird.cantharella.web.config.WebContext;
import nc.ird.cantharella.web.pages.TemplatePage;
import nc.ird.cantharella.web.pages.renderers.PersonneRenderer;
import nc.ird.cantharella.web.utils.CallerPage;
import nc.ird.cantharella.web.utils.behaviors.JSConfirmationBehavior;
import nc.ird.cantharella.web.utils.forms.AutoCompleteTextFieldString;
import nc.ird.cantharella.web.utils.forms.SubmittableButton;
import nc.ird.cantharella.web.utils.forms.SubmittableButtonEvents;
import nc.ird.cantharella.web.utils.models.DisplayMapValuePropertyModel;
import nc.ird.cantharella.web.utils.panels.SimpleTooltipPanel;
import nc.ird.cantharella.web.utils.renderers.MapChoiceRenderer;
import nc.ird.cantharella.web.utils.security.AuthRole;
import nc.ird.cantharella.web.utils.security.AuthRoles;
import nc.ird.module.utils.CollectionTools;
import nc.ird.module.utils.LogTools;
import org.apache.commons.logging.Log;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.markup.html.form.DateTextField;
import org.apache.wicket.extensions.yui.calendar.DatePicker;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.AbstractSingleSelectChoice;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.apache.wicket.util.string.StringValueConversionException;

@AuthRoles(value={AuthRole.ADMIN, AuthRole.USER})
public final class ManageCampagnePage
extends TemplatePage {
    private static final String ACTION_CREATE = "Create";
    public static final String ACTION_DELETE = "Delete";
    private static final String ACTION_UPDATE = "Update";
    private static final Log LOG = LogTools.getLog();
    private Button addParticipant;
    private Button addStation;
    private AbstractSingleSelectChoice<Personne> availablePersonnes;
    private AbstractSingleSelectChoice<Station> availableStations;
    private final CallerPage callerPage;
    private final IModel<Campagne> campagneModel;
    @SpringBean
    private CampagneService campagneService;
    @SpringBean
    private StationService stationService;
    private final IModel<CampagnePersonneParticipant> participantModel;
    private final IModel<Station> stationModel;
    private final List<Personne> personnes;
    private final List<Station> stations;
    @SpringBean
    private PersonneService personneService;
    @SpringBean(name="webModelValidator")
    private ModelValidator validator;
    FormComponent<String> complementView;
    private boolean multipleEntry;

    public ManageCampagnePage(CallerPage callerPage, boolean bl) {
        this(null, null, callerPage, bl);
    }

    public ManageCampagnePage(Integer n, CallerPage callerPage) {
        this(n, null, callerPage, false);
    }

    public ManageCampagnePage(Campagne campagne, CallerPage callerPage) {
        this(null, campagne, callerPage, true);
    }

    private ManageCampagnePage(Integer n, Campagne campagne, CallerPage callerPage, boolean bl) {
        super(ManageCampagnePage.class);
        boolean bl2;
        assert (n == null || campagne == null);
        this.callerPage = callerPage;
        this.multipleEntry = bl;
        try {
            this.campagneModel = new Model((Serializable)(n == null && campagne == null ? new Campagne() : (campagne != null ? campagne : this.campagneService.loadCampagne(n))));
        }
        catch (DataNotFoundException dataNotFoundException) {
            LOG.error((Object)dataNotFoundException.getMessage(), (Throwable)dataNotFoundException);
            throw new UnexpectedException((Exception)((Object)dataNotFoundException));
        }
        boolean bl3 = bl2 = n == null;
        if (bl2) {
            ((Campagne)this.campagneModel.getObject()).setCreateur((Personne)this.getSession().getUtilisateur());
        }
        this.participantModel = new Model((Serializable)new CampagnePersonneParticipant());
        ((CampagnePersonneParticipant)this.participantModel.getObject()).getId().setPk1((AbstractModel)this.campagneModel.getObject());
        this.stationModel = new Model((Serializable)new Station());
        List list = this.campagneService.listCampagneProgrammes();
        this.personnes = this.personneService.listPersonnes();
        this.stations = this.stationService.listStations(this.getSession().getUtilisateur());
        Form form = new Form("Form");
        form.add(new Component[]{new TextField("Campagne.nom", (IModel)new PropertyModel((Object)this.campagneModel, "nom"))});
        form.add(new Component[]{new DropDownChoice("Campagne.codePays", (IModel)new PropertyModel((Object)this.campagneModel, "codePays"), (List)WebContext.COUNTRY_CODES.get(this.getSession().getLocale()), (IChoiceRenderer)new MapChoiceRenderer((Map)WebContext.COUNTRIES.get(this.getSession().getLocale())))});
        if (((Campagne)this.campagneModel.getObject()).getCodePays() == null) {
            ((Campagne)this.campagneModel.getObject()).setCodePays((String)((Map)WebContext.COUNTRIES.get(this.getSession().getLocale())).entrySet().iterator().next().getKey());
        }
        form.add(new Component[]{new DateTextField("Campagne.dateDeb", (IModel)new PropertyModel((Object)this.campagneModel, "dateDeb")).add(new Behavior[]{new DatePicker()})});
        form.add(new Component[]{new DateTextField("Campagne.dateFin", (IModel)new PropertyModel((Object)this.campagneModel, "dateFin")).add(new Behavior[]{new DatePicker()})});
        form.add(new Component[]{new TextArea("Campagne.mentionLegale", (IModel)new PropertyModel((Object)this.campagneModel, "mentionLegale"))});
        form.add(new Component[]{new SimpleTooltipPanel("Campagne.mentionLegale.info", (IModel)new Model((Serializable)((Object)this.getString("Campagne.mentionLegale.info"))))});
        form.add(new Component[]{new TextArea("Campagne.complement", (IModel)new PropertyModel((Object)this.campagneModel, "complement"))});
        form.add(new Component[]{new SimpleTooltipPanel("Campagne.complement.info", (IModel)new Model((Serializable)((Object)this.getString("Campagne.complement.info"))))});
        form.add(new Component[]{new TextField("Campagne.createur", (IModel)new PropertyModel((Object)this.campagneModel, "createur")).setEnabled(false)});
        form.add(new Component[]{new AutoCompleteTextFieldString("Campagne.programme", (IModel)new PropertyModel((Object)this.campagneModel, "programme"), list, AutoCompleteTextFieldString.ComparisonMode.CONTAINS)});
        this.initParticipantsFields(form);
        this.initStationsFields(form);
        SubmittableButton submittableButton = new SubmittableButton(ACTION_CREATE, (SubmittableButtonEvents)new /* Unavailable Anonymous Inner Class!! */);
        submittableButton.setVisibilityAllowed(bl2);
        form.add(new Component[]{submittableButton});
        SubmittableButton submittableButton2 = new SubmittableButton(ACTION_UPDATE, (SubmittableButtonEvents)new /* Unavailable Anonymous Inner Class!! */);
        submittableButton2.setVisibilityAllowed(!bl2 && this.campagneService.updateOrdeleteCampagneEnabled((Campagne)this.campagneModel.getObject(), this.getSession().getUtilisateur()));
        form.add(new Component[]{submittableButton2});
        SubmittableButton submittableButton3 = new SubmittableButton(ACTION_DELETE, (SubmittableButtonEvents)new /* Unavailable Anonymous Inner Class!! */);
        submittableButton3.setVisibilityAllowed(!bl2 && this.campagneService.updateOrdeleteCampagneEnabled((Campagne)this.campagneModel.getObject(), this.getSession().getUtilisateur()));
        submittableButton3.add(new Behavior[]{new JSConfirmationBehavior(this.getString("Confirm"))});
        submittableButton3.setDefaultFormProcessing(false);
        form.add(new Component[]{submittableButton3});
        form.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
        this.cleanPersonnesChoice();
        this.cleanStationsChoice();
        this.add(new Component[]{form});
    }

    private void initParticipantsFields(Form<Void> form) {
        WebMarkupContainer webMarkupContainer = new WebMarkupContainer("Campagne.participants.Table");
        webMarkupContainer.setOutputMarkupId(true);
        webMarkupContainer.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
        this.availablePersonnes = new DropDownChoice("Campagne.participant", (IModel)new PropertyModel((Object)this.participantModel, "id.pk2"), new ArrayList(), (IChoiceRenderer)new PersonneRenderer());
        this.availablePersonnes.setNullValid(false);
        this.availablePersonnes.setOutputMarkupId(true);
        webMarkupContainer.add(new Component[]{this.availablePersonnes});
        this.complementView = new TextField("CampagnePersonneParticipant.complement", (IModel)new PropertyModel((Object)this.participantModel, "complement"));
        webMarkupContainer.add(new Component[]{this.complementView});
        this.addParticipant = new /* Unavailable Anonymous Inner Class!! */;
        webMarkupContainer.add(new Component[]{this.addParticipant});
        form.add(new Component[]{webMarkupContainer});
        webMarkupContainer.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
    }

    private void initStationsFields(Form<Void> form) {
        WebMarkupContainer webMarkupContainer = new WebMarkupContainer("Campagne.stations.Table");
        webMarkupContainer.setOutputMarkupId(true);
        webMarkupContainer.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
        this.availableStations = new DropDownChoice("Campagne.station", this.stationModel, new ArrayList());
        this.availableStations.setNullValid(false);
        this.availableStations.setOutputMarkupId(true);
        webMarkupContainer.add(new Component[]{this.availableStations});
        Label label = new Label("Campagne.station.codePays", (IModel)new DisplayMapValuePropertyModel((Object)this.stationModel, "codePays", (Map)WebContext.COUNTRIES.get(this.getSession().getLocale())));
        label.setOutputMarkupId(true);
        webMarkupContainer.add(new Component[]{label});
        Label label2 = new Label("Campagne.station.localite", (IModel)new PropertyModel((Object)this.stationModel, "localite"));
        label2.setOutputMarkupId(true);
        webMarkupContainer.add(new Component[]{label2});
        Label label3 = new Label("Campagne.station.latitude", (IModel)new PropertyModel((Object)this.stationModel, "latitude"));
        label3.setOutputMarkupId(true);
        webMarkupContainer.add(new Component[]{label3});
        Label label4 = new Label("Campagne.station.longitude", (IModel)new PropertyModel((Object)this.stationModel, "longitude"));
        label4.setOutputMarkupId(true);
        webMarkupContainer.add(new Component[]{label4});
        this.availableStations.add(new Behavior[]{new /* Unavailable Anonymous Inner Class!! */});
        this.addStation = new /* Unavailable Anonymous Inner Class!! */;
        webMarkupContainer.add(new Component[]{this.addStation});
        form.add(new Component[]{webMarkupContainer});
        webMarkupContainer.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
    }

    protected void onBeforeRender() {
        this.refreshModel();
        super.onBeforeRender();
    }

    private void redirect() {
        if (this.multipleEntry) {
            Campagne campagne = new Campagne();
            campagne.setCodePays(((Campagne)this.campagneModel.getObject()).getCodePays());
            campagne.setProgramme(((Campagne)this.campagneModel.getObject()).getProgramme());
            campagne.setMentionLegale(((Campagne)this.campagneModel.getObject()).getMentionLegale());
            this.setResponsePage((Page)new ManageCampagnePage(campagne, this.callerPage));
        } else if (this.callerPage != null) {
            this.callerPage.addPageParameter(Campagne.class.getSimpleName(), (Object)((Campagne)this.campagneModel.getObject()).getIdCampagne());
            this.callerPage.responsePage((TemplatePage)this);
        }
    }

    private void refreshModel() {
        Personne personne;
        String string = Personne.class.getSimpleName();
        if (this.getPageParameters().getNamedKeys().contains(string)) {
            CollectionTools.setter((Collection)this.personnes, (Collection)this.personneService.listPersonnes());
            this.cleanPersonnesChoice();
            try {
                personne = this.personneService.loadPersonne(Integer.valueOf(this.getPageParameters().get(string).toInt()));
                ((CampagnePersonneParticipant)this.participantModel.getObject()).getId().setPk2((AbstractModel)personne);
            }
            catch (StringValueConversionException stringValueConversionException) {
                LOG.error((Object)stringValueConversionException.getMessage(), (Throwable)stringValueConversionException);
                throw new UnexpectedException((Exception)((Object)stringValueConversionException));
            }
            catch (DataNotFoundException dataNotFoundException) {
                LOG.error((Object)dataNotFoundException.getMessage(), (Throwable)dataNotFoundException);
                throw new UnexpectedException((Exception)((Object)dataNotFoundException));
            }
            this.getPageParameters().remove(string);
        }
        string = Station.class.getSimpleName();
        if (this.getPageParameters().getNamedKeys().contains(string)) {
            CollectionTools.setter((Collection)this.stations, (Collection)this.stationService.listStations(this.getSession().getUtilisateur()));
            this.cleanStationsChoice();
            try {
                personne = this.stationService.loadStation(Integer.valueOf(this.getPageParameters().get(string).toInt()));
                this.stationModel.setObject((Object)personne);
            }
            catch (StringValueConversionException stringValueConversionException) {
                LOG.error((Object)stringValueConversionException.getMessage(), (Throwable)stringValueConversionException);
                throw new UnexpectedException((Exception)((Object)stringValueConversionException));
            }
            catch (DataNotFoundException dataNotFoundException) {
                LOG.error((Object)dataNotFoundException.getMessage(), (Throwable)dataNotFoundException);
                throw new UnexpectedException((Exception)((Object)dataNotFoundException));
            }
            this.getPageParameters().remove(string);
        }
    }

    private void cleanPersonnesChoice() {
        ArrayList arrayList = new ArrayList(this.personnes);
        for (CampagnePersonneParticipant campagnePersonneParticipant : ((Campagne)this.campagneModel.getObject()).getParticipants()) {
            for (Personne personne : this.personnes) {
                if (((Personne)campagnePersonneParticipant.getId().getPk2()).getIdPersonne() != personne.getIdPersonne()) continue;
                arrayList.remove(personne);
            }
        }
        this.availablePersonnes.setChoices(arrayList);
        this.availablePersonnes.setEnabled(!arrayList.isEmpty());
        this.addParticipant.setEnabled(!arrayList.isEmpty());
        this.complementView.setEnabled(!arrayList.isEmpty());
    }

    private void cleanStationsChoice() {
        ArrayList arrayList = new ArrayList(this.stations);
        for (Station station : ((Campagne)this.campagneModel.getObject()).getStations()) {
            for (Station station2 : this.stations) {
                if (station.getIdStation() != station2.getIdStation()) continue;
                arrayList.remove(station2);
            }
        }
        this.availableStations.setChoices(arrayList);
        this.availableStations.setEnabled(!arrayList.isEmpty());
        this.addStation.setEnabled(!arrayList.isEmpty());
        this.availableStations.setEnabled(!arrayList.isEmpty());
    }

    private void validateModel() {
        if (((Campagne)this.campagneModel.getObject()).getCreateur() == null) {
            ((Campagne)this.campagneModel.getObject()).setCreateur((Personne)this.getSession().getUtilisateur());
        }
        this.addValidationErrors((Collection)this.validator.validate(this.campagneModel.getObject(), this.getSession().getLocale(), new String[]{"nom", "codePays", "programme", "complement", "createur"}));
        List list = this.validator.validate(this.campagneModel.getObject(), this.getSession().getLocale(), new String[]{"dateDeb", "dateFin"});
        this.addValidationErrors((Collection)list);
        if (!(list.size() != 0 || ((Campagne)this.campagneModel.getObject()).getDateDeb() != null && ((Campagne)this.campagneModel.getObject()).getDateFin() != null && ((Campagne)this.campagneModel.getObject()).getDateDeb().before(((Campagne)this.campagneModel.getObject()).getDateFin()))) {
            this.getPage().error((Serializable)((Object)this.getString("Campagne.dates.KO")));
        }
    }

    static /* synthetic */ IModel access$000(ManageCampagnePage manageCampagnePage) {
        return manageCampagnePage.campagneModel;
    }

    static /* synthetic */ CampagneService access$100(ManageCampagnePage manageCampagnePage) {
        return manageCampagnePage.campagneService;
    }

    static /* synthetic */ void access$200(ManageCampagnePage manageCampagnePage) {
        manageCampagnePage.redirect();
    }

    static /* synthetic */ void access$300(ManageCampagnePage manageCampagnePage) {
        manageCampagnePage.validateModel();
    }

    static /* synthetic */ void access$400(ManageCampagnePage manageCampagnePage) {
        manageCampagnePage.cleanPersonnesChoice();
    }

    static /* synthetic */ void access$500(ManageCampagnePage manageCampagnePage) {
        manageCampagnePage.refreshModel();
    }

    static /* synthetic */ AbstractSingleSelectChoice access$600(ManageCampagnePage manageCampagnePage) {
        return manageCampagnePage.availablePersonnes;
    }

    static /* synthetic */ IModel access$700(ManageCampagnePage manageCampagnePage) {
        return manageCampagnePage.participantModel;
    }

    static /* synthetic */ Log access$800() {
        return LOG;
    }

    static /* synthetic */ void access$900(ManageCampagnePage manageCampagnePage, AjaxRequestTarget ajaxRequestTarget) {
        manageCampagnePage.refreshFeedbackPage(ajaxRequestTarget);
    }

    static /* synthetic */ void access$1000(ManageCampagnePage manageCampagnePage) {
        manageCampagnePage.cleanStationsChoice();
    }

    static /* synthetic */ AbstractSingleSelectChoice access$1100(ManageCampagnePage manageCampagnePage) {
        return manageCampagnePage.availableStations;
    }

    static /* synthetic */ IModel access$1200(ManageCampagnePage manageCampagnePage) {
        return manageCampagnePage.stationModel;
    }

    static /* synthetic */ void access$1300(ManageCampagnePage manageCampagnePage, AjaxRequestTarget ajaxRequestTarget) {
        manageCampagnePage.refreshFeedbackPage(ajaxRequestTarget);
    }
}

