/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.web.pages.columns;

import nc.ird.cantharella.data.model.Extrait;
import nc.ird.cantharella.data.model.Fraction;
import nc.ird.cantharella.data.model.Produit;
import nc.ird.cantharella.web.pages.TemplatePage;
import nc.ird.cantharella.web.utils.columns.LinkPropertyColumn;
import nc.ird.module.utils.BeanTools;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.model.IModel;

public abstract class LinkProduitPropertyColumn<T>
extends LinkPropertyColumn<T> {
    private final TemplatePage page;

    public LinkProduitPropertyColumn(IModel<String> iModel, String string, String string2, TemplatePage templatePage) {
        super(iModel, string, string2);
        this.page = templatePage;
    }

    public void onClick(Item<ICellPopulator<T>> item, String string, IModel<T> iModel) {
        if (iModel.getObject() != null) {
            Produit produit = (Produit)BeanTools.getValue((Object)iModel.getObject(), (BeanTools.AccessType)BeanTools.AccessType.GETTER, (String)"produit");
            if (produit.isExtrait()) {
                Extrait extrait = (Extrait)produit;
                this.onClickIfExtrait(extrait);
            } else {
                Fraction fraction = (Fraction)produit;
                this.onClickIfFraction(fraction);
            }
        }
    }

    public void populateItem(Item<ICellPopulator<T>> item, String string, IModel<T> iModel) {
        if (iModel.getObject() != null) {
            Produit produit = (Produit)BeanTools.getValue((Object)iModel.getObject(), (BeanTools.AccessType)BeanTools.AccessType.GETTER, (String)"produit");
            this.linkTitle = produit.isExtrait() ? this.page.getString("ReadExtraction") : this.page.getString("ReadPurification");
        }
        super.populateItem(item, string, iModel);
    }

    public abstract void onClickIfExtrait(Extrait var1);

    public abstract void onClickIfFraction(Fraction var1);
}

