/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.web.pages;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.MissingResourceException;
import nc.ird.cantharella.web.pages.ContactPage;
import nc.ird.cantharella.web.pages.HomePage;
import nc.ird.cantharella.web.pages.domain.campagne.ListCampagnesPage;
import nc.ird.cantharella.web.pages.domain.config.ListConfigurationPage;
import nc.ird.cantharella.web.pages.domain.extraction.ListExtractionsPage;
import nc.ird.cantharella.web.pages.domain.lot.ListLotsPage;
import nc.ird.cantharella.web.pages.domain.personne.ListPersonnesPage;
import nc.ird.cantharella.web.pages.domain.purification.ListPurificationsPage;
import nc.ird.cantharella.web.pages.domain.specimen.ListSpecimensPage;
import nc.ird.cantharella.web.pages.domain.station.ListStationsPage;
import nc.ird.cantharella.web.pages.domain.testBio.ListTestsBioPage;
import nc.ird.cantharella.web.pages.domain.utilisateur.UpdateUtilisateurPage;
import nc.ird.cantharella.web.utils.security.AuthContainer;
import nc.ird.cantharella.web.utils.security.AuthRole;
import nc.ird.cantharella.web.utils.security.AuthSession;
import nc.ird.module.utils.AssertTools;
import nc.ird.module.utils.LogTools;
import nc.ird.module.utils.Pair;
import org.apache.commons.logging.Log;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.IAjaxIndicatorAware;
import org.apache.wicket.markup.html.IHeaderContributor;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.WebPage;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.panel.FeedbackPanel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.request.mapper.parameter.PageParameters;

public abstract class TemplatePage
extends WebPage
implements IAjaxIndicatorAware,
IHeaderContributor {
    private static final String ACTION_LOGOUT = "Logout";
    private static final String ID_AJAX_INDICATOR = "AjaxIndicator";
    private static final Log LOG = LogTools.getLog();
    public static final String PATTERN_ENUM_VALUE_LABEL = "%s.%s";
    private static final String PATTERN_ERROR_ACTION_EXCEPTION = "%s.%s.%s";
    private static final String PATTERN_ERROR_MESSAGE = "%s.KO";
    private static final String PATTERN_ERROR_MESSAGE_VALIDATOR = "%s - %s";
    private static final String PATTERN_PANEL_PAGE_TITLE_HEAD = " - %s";
    private static final String PATTERN_SUCCESS_ACTION_MESSAGE = "%s.%s.OK";
    private static final String YEAR = String.valueOf(Calendar.getInstance().get(1));
    private final MarkupContainer feedbackPanelContainer;
    private final String resource;

    protected TemplatePage(Class<? extends TemplatePage> clazz) {
        super(new PageParameters());
        AssertTools.assertNotNull(clazz);
        this.resource = clazz.getSimpleName();
        this.addPageTitles();
        this.add(new Component[]{new BookmarkablePageLink(HomePage.class.getSimpleName(), this.getApplication().getHomePage())});
        this.add(new Component[]{this.createUserSatellite()});
        this.add(new Component[]{this.createUserSearch()});
        this.add(new Component[]{this.createVisitorMenu()});
        this.add(new Component[]{this.createUserMenu()});
        this.createLanguageLinks();
        this.feedbackPanelContainer = new WebMarkupContainer("FeedbackPageContainer");
        this.feedbackPanelContainer.add(new Component[]{new FeedbackPanel("FeedbackPage")});
        this.feedbackPanelContainer.setOutputMarkupId(true);
        this.add(new Component[]{this.feedbackPanelContainer});
        this.add(new Component[]{new Label("Year", YEAR)});
        this.add(new Component[]{new BookmarkablePageLink(ContactPage.class.getSimpleName(), ContactPage.class)});
        this.setVersioned(true);
    }

    public void renderHead(IHeaderResponse iHeaderResponse) {
        iHeaderResponse.renderCSSReference(this.getString("TemplatePage.Css.Menu"));
        if (!this.getSession().getFeedbackMessages().isEmpty()) {
            iHeaderResponse.renderOnLoadJavaScript("location.hash='header'");
        }
    }

    private void createLanguageLinks() {
        this.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
        this.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
    }

    private AuthContainer createUserSatellite() {
        AuthContainer authContainer = new AuthContainer("Satellite.USER", new AuthRole[]{AuthRole.USER, AuthRole.ADMIN});
        if (authContainer.isAuthorized()) {
            BookmarkablePageLink bookmarkablePageLink = new BookmarkablePageLink(UpdateUtilisateurPage.class.getSimpleName(), UpdateUtilisateurPage.class);
            bookmarkablePageLink.add(new Component[]{new Label("Utilisateur", (IModel)new PropertyModel((Object)this, "session.utilisateur"))});
            authContainer.add(new Component[]{bookmarkablePageLink});
            authContainer.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
        }
        return authContainer;
    }

    private AuthContainer createUserSearch() {
        AuthContainer authContainer = new AuthContainer("Search.USER", new AuthRole[]{AuthRole.USER, AuthRole.ADMIN});
        return authContainer;
    }

    private AuthContainer createVisitorMenu() {
        AuthContainer authContainer = new AuthContainer("Menu.VISITOR", new AuthRole[]{AuthRole.VISITOR});
        return authContainer;
    }

    private AuthContainer createUserMenu() {
        AuthContainer authContainer = new AuthContainer("Menu.USER", new AuthRole[]{AuthRole.USER, AuthRole.ADMIN});
        if (authContainer.isAuthorized()) {
            authContainer.add(new Component[]{this.createAdminMenu()});
            authContainer.add(new Component[]{new BookmarkablePageLink(ListPersonnesPage.class.getSimpleName(), ListPersonnesPage.class)});
            authContainer.add(new Component[]{new BookmarkablePageLink(ListCampagnesPage.class.getSimpleName(), ListCampagnesPage.class)});
            authContainer.add(new Component[]{new BookmarkablePageLink(ListStationsPage.class.getSimpleName(), ListStationsPage.class)});
            authContainer.add(new Component[]{new BookmarkablePageLink(ListLotsPage.class.getSimpleName(), ListLotsPage.class)});
            authContainer.add(new Component[]{new BookmarkablePageLink(ListSpecimensPage.class.getSimpleName(), ListSpecimensPage.class)});
            authContainer.add(new Component[]{new BookmarkablePageLink(ListExtractionsPage.class.getSimpleName(), ListExtractionsPage.class)});
            authContainer.add(new Component[]{new BookmarkablePageLink(ListPurificationsPage.class.getSimpleName(), ListPurificationsPage.class)});
            authContainer.add(new Component[]{new BookmarkablePageLink(ListTestsBioPage.class.getSimpleName(), ListTestsBioPage.class)});
        }
        return authContainer;
    }

    private AuthContainer createAdminMenu() {
        AuthContainer authContainer = new AuthContainer("Menu.ADMIN", new AuthRole[]{AuthRole.ADMIN});
        if (authContainer.isAuthorized()) {
            authContainer.add(new Component[]{new BookmarkablePageLink(ListConfigurationPage.class.getSimpleName(), ListConfigurationPage.class)});
        }
        return authContainer;
    }

    private void addPageTitles() {
        String string = this.getString(this.getResource());
        this.add(new Component[]{new Label("PageTitleHead", String.format(PATTERN_PANEL_PAGE_TITLE_HEAD, string))});
        this.add(new Component[]{new Label("PageTitleBody", string)});
    }

    public final void addValidationErrors(Collection<String> collection) {
        for (String string : collection) {
            this.error((Serializable)((Object)string));
        }
    }

    public final void addValidationErrors(List<Pair<String, String>> list) {
        for (Pair<String, String> pair : list) {
            String string = (String)pair.getKey();
            try {
                string = this.getString(string);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            this.error((Serializable)((Object)String.format(PATTERN_ERROR_MESSAGE_VALIDATOR, string, pair.getValue())));
        }
    }

    public final void errorCurrentPage(Class<? extends TemplatePage> clazz, String string, Exception exception) {
        AssertTools.assertNotNull(clazz);
        AssertTools.assertNotEmpty((String)string);
        AssertTools.assertNotNull((Object)exception);
        String string2 = this.getString(String.format(PATTERN_ERROR_ACTION_EXCEPTION, clazz.getSimpleName(), string, exception.getClass().getSimpleName()));
        LOG.warn((Object)string2);
        this.error((Serializable)((Object)string2));
    }

    public final void errorCurrentPage(Component component) {
        AssertTools.assertNotNull((Object)component);
        String string = String.format(PATTERN_ERROR_MESSAGE, component.getId());
        try {
            string = this.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        LOG.warn((Object)string);
        this.error((Serializable)((Object)string));
    }

    public final void errorCurrentPage(String string, Exception exception) {
        AssertTools.assertNotEmpty((String)string);
        AssertTools.assertNotNull((Object)exception);
        String string2 = this.getString(String.format(PATTERN_ERROR_ACTION_EXCEPTION, this.getResource(), string, exception.getClass().getSimpleName()));
        LOG.warn((Object)string2);
        this.error((Serializable)((Object)string2));
    }

    public final String getAjaxIndicatorMarkupId() {
        return ID_AJAX_INDICATOR;
    }

    protected final String getResource() {
        return this.resource;
    }

    public final AuthSession getSession() {
        return (AuthSession)super.getSession();
    }

    protected final void refreshFeedbackPage(AjaxRequestTarget ajaxRequestTarget) {
        if (ajaxRequestTarget != null) {
            ajaxRequestTarget.add(new Component[]{this.feedbackPanelContainer});
            if (!this.getSession().getFeedbackMessages().isEmpty()) {
                LOG.debug((Object)"REFRESH FEEDBACK BY AJAX");
                ajaxRequestTarget.appendJavaScript((CharSequence)"window.location.hash = '#header';");
                ajaxRequestTarget.focusComponent((Component)this.feedbackPanelContainer);
            }
        }
    }

    public final void successCurrentPage(Class<? extends TemplatePage> clazz, String string) {
        this.info((Serializable)((Object)this.successMessage(clazz, string)));
    }

    public final void successCurrentPage(String string) {
        this.info((Serializable)((Object)this.successMessage(string)));
    }

    private String successMessage(Class<? extends TemplatePage> clazz, String string) {
        AssertTools.assertNotNull(clazz);
        AssertTools.assertNotEmpty((String)string);
        return this.getString(String.format(PATTERN_SUCCESS_ACTION_MESSAGE, clazz.getSimpleName(), string));
    }

    private String successMessage(String string) {
        AssertTools.assertNotEmpty((String)string);
        return this.getString(String.format(PATTERN_SUCCESS_ACTION_MESSAGE, this.getResource(), string));
    }

    public final void successNextPage(Class<? extends TemplatePage> clazz, String string) {
        this.getSession().info((Serializable)((Object)this.successMessage(clazz, string)));
    }

    public final void successNextPage(String string) {
        this.getSession().info((Serializable)((Object)this.successMessage(string)));
    }

    public final <E extends Enum<?>> String enumValueMessage(E e) {
        if (e == null) {
            return null;
        }
        String string = String.format(PATTERN_ENUM_VALUE_LABEL, e.getClass().getSimpleName(), e.toString());
        return this.getString(string);
    }
}

