/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.web.pages;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.List;
import nc.ird.cantharella.data.model.Utilisateur;
import nc.ird.cantharella.data.validation.utils.ModelValidator;
import nc.ird.cantharella.service.services.CampagneService;
import nc.ird.cantharella.service.services.ExtractionService;
import nc.ird.cantharella.service.services.LotService;
import nc.ird.cantharella.service.services.PersonneService;
import nc.ird.cantharella.service.services.PurificationService;
import nc.ird.cantharella.service.services.SpecimenService;
import nc.ird.cantharella.service.services.StationService;
import nc.ird.cantharella.service.services.TestBioService;
import nc.ird.cantharella.web.pages.HomePage;
import nc.ird.cantharella.web.pages.TemplatePage;
import nc.ird.cantharella.web.pages.domain.utilisateur.RegisterPage;
import nc.ird.cantharella.web.pages.domain.utilisateur.ResetPasswordPage;
import nc.ird.cantharella.web.pages.model.LoginModel;
import nc.ird.cantharella.web.utils.forms.SubmittableButton;
import nc.ird.cantharella.web.utils.forms.SubmittableButtonEvents;
import nc.ird.cantharella.web.utils.security.AuthContainer;
import nc.ird.cantharella.web.utils.security.AuthRole;
import nc.ird.module.utils.LogTools;
import org.apache.commons.logging.Log;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.PasswordTextField;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.panel.EmptyPanel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.spring.injection.annot.SpringBean;

public final class HomePage
extends TemplatePage {
    private static final Log LOG = LogTools.getLog();
    private static final String ACTION_LOGIN = "Login";
    @SpringBean
    private PersonneService personneService;
    @SpringBean
    private CampagneService campagneService;
    @SpringBean
    private StationService stationService;
    @SpringBean
    private SpecimenService specimenService;
    @SpringBean
    private LotService lotService;
    @SpringBean
    private ExtractionService extractionService;
    @SpringBean
    private PurificationService purificationService;
    @SpringBean
    private TestBioService testBioService;
    @SpringBean(name="webModelValidator")
    private ModelValidator validator;

    public HomePage() {
        super(HomePage.class);
        this.addVisitorContent();
        this.addUserContent();
        this.addAdminContent();
    }

    private void addAdminContent() {
        AuthContainer authContainer = new AuthContainer("Content.ADMIN", new AuthRole[]{AuthRole.ADMIN});
        if (authContainer.isAuthorized()) {
            WebMarkupContainer webMarkupContainer = new WebMarkupContainer("InvalidUtilisateurs.List");
            webMarkupContainer.setOutputMarkupId(true);
            List list = this.personneService.listUtilisateursInvalid();
            webMarkupContainer.setVisibilityAllowed(!list.isEmpty());
            if (webMarkupContainer.isVisibilityAllowed()) {
                webMarkupContainer.add(new Component[]{new /* Unavailable Anonymous Inner Class!! */});
            }
            authContainer.add(new Component[]{webMarkupContainer});
        }
        this.add(new Component[]{authContainer});
    }

    private void addUserContent() {
        AuthContainer authContainer = new AuthContainer("Content.USER", new AuthRole[]{AuthRole.USER, AuthRole.ADMIN});
        if (authContainer.isAuthorized()) {
            authContainer.add(new Component[]{new Label(this.getResource() + ".Statistics.Personnes", String.valueOf(this.personneService.countPersonnes()))});
            authContainer.add(new Component[]{new Label(this.getResource() + ".Statistics.Campagnes", String.valueOf(this.campagneService.countCampagnes()))});
            authContainer.add(new Component[]{new Label(this.getResource() + ".Statistics.Stations", String.valueOf(this.stationService.countStations()))});
            authContainer.add(new Component[]{new Label(this.getResource() + ".Statistics.Specimens", String.valueOf(this.specimenService.countSpecimens()))});
            authContainer.add(new Component[]{new Label(this.getResource() + ".Statistics.Lots", String.valueOf(this.lotService.countLots()))});
            authContainer.add(new Component[]{new Label(this.getResource() + ".Statistics.Extractions", String.valueOf(this.extractionService.countExtractions()))});
            authContainer.add(new Component[]{new Label(this.getResource() + ".Statistics.Purifications", String.valueOf(this.purificationService.countPurifications()))});
            authContainer.add(new Component[]{new Label(this.getResource() + ".Statistics.TestsBio", String.valueOf(this.testBioService.countResultatsTestsBio()))});
            2 var2_2 = new /* Unavailable Anonymous Inner Class!! */;
            authContainer.add(new Component[]{var2_2});
            if (this.getSession().getUtilisateur().getTypeDroit() == Utilisateur.TypeDroit.ADMINISTRATEUR) {
                authContainer.add(new Component[]{new Label("HomePage.Rights.User1", this.getString("HomePage.Rights.Admin"))});
                var2_2.setVisibilityAllowed(false);
                EmptyPanel emptyPanel = new EmptyPanel("HomePage.Rights.User2");
                emptyPanel.setVisibilityAllowed(false);
                authContainer.add(new Component[]{emptyPanel});
            } else {
                Integer n = this.getSession().getUtilisateur().getCampagnesDroits().size();
                Integer n2 = this.getSession().getUtilisateur().getLotsDroits().size();
                String string = MessageFormat.format(this.getString("HomePage.Rights.User"), n, n2);
                authContainer.add(new Component[]{new Label("HomePage.Rights.User1", string)});
                Integer n3 = this.getSession().getUtilisateur().getCampagnesCreees().size();
                String string2 = MessageFormat.format(this.getString("HomePage.Rights.User2"), n3);
                Label label = new Label("HomePage.Rights.User2", string2);
                label.setVisibilityAllowed(n3 != 0);
                authContainer.add(new Component[]{label});
            }
        }
        this.add(new Component[]{authContainer});
    }

    private void addVisitorContent() {
        AuthContainer authContainer = new AuthContainer("Content.VISITOR", new AuthRole[]{AuthRole.VISITOR});
        if (authContainer.isAuthorized()) {
            Model model = new Model((Serializable)new LoginModel());
            Model model2 = new Model((Serializable)new Utilisateur());
            Form form = new Form("Form");
            form.add(new Component[]{new TextField("Personne.courriel", (IModel)new PropertyModel((Object)model2, "courriel"))});
            form.add(new Component[]{new PasswordTextField("LoginModel.password", (IModel)new PropertyModel((Object)model, "password")).setRequired(false)});
            form.add(new Component[]{new CheckBox("LoginModel.rememberMe", (IModel)new PropertyModel((Object)model, "rememberMe"))});
            form.add(new Component[]{new SubmittableButton(ACTION_LOGIN, (SubmittableButtonEvents)new /* Unavailable Anonymous Inner Class!! */)});
            form.add(new Component[]{new BookmarkablePageLink(ResetPasswordPage.class.getSimpleName(), ResetPasswordPage.class)});
            authContainer.add(new Component[]{new BookmarkablePageLink(RegisterPage.class.getSimpleName(), RegisterPage.class)});
            authContainer.add(new Component[]{form});
        }
        this.add(new Component[]{authContainer});
    }

    static /* synthetic */ PersonneService access$000(HomePage homePage) {
        return homePage.personneService;
    }

    static /* synthetic */ Log access$100() {
        return LOG;
    }

    static /* synthetic */ ModelValidator access$200(HomePage homePage) {
        return homePage.validator;
    }
}

