/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.web.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Resource;
import javax.validation.ValidatorFactory;
import nc.ird.cantharella.data.config.DataContext;
import nc.ird.cantharella.data.validation.utils.ModelValidator;
import nc.ird.cantharella.data.validation.utils.ModelValidatorImpl;
import nc.ird.cantharella.service.config.ServiceContext;
import nc.ird.cantharella.web.config.WebApplicationImpl;
import nc.ird.cantharella.web.utils.resources.WebMessages;
import nc.ird.module.utils.Pair;
import nc.ird.module.utils.StringTools;
import org.apache.wicket.RuntimeConfigurationType;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.resource.loader.IStringResourceLoader;
import org.apache.wicket.util.lang.Bytes;
import org.apache.wicket.util.time.Duration;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.ImportResource;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;

@Import(value={ServiceContext.class})
@ImportResource(value={"classpath:/webContext.xml"})
@Configuration
public abstract class WebContext {
    public static final String AUTH_COOKIE_KEY = "LoggedIn";
    public static final int AUTH_COOKIE_MAX_AGE = (int)Duration.days((int)1).seconds();
    public static final Map<Locale, Map<String, String>> COUNTRIES;
    public static final Map<Locale, List<String>> COUNTRY_CODES;
    public static final Duration HTTP_CACHE_DURATION;
    public static final Bytes HTTP_MAXIMUM_UPLOAD;
    public static final int HTTP_REQUEST_LOGGER_WINDOW_SIZE = 2000;
    public static final int HTTP_SESSION_MAX_PAGE_MAPS = 5;
    public static final Duration HTTP_TIME_OUT;
    public static final List<Integer> REFERENTIEL_CODES;
    public static final int PERCENT_PRECISION = 2;
    public static final int DOUBLE_MAX_FRACTION_DIGIT = 3;
    public static final int ROWS_PER_PAGE = 20;
    @Resource(name="dataMessageSource")
    private MessageSourceAccessor dataMessageSource;
    @Resource(name="validatorFactory")
    private ValidatorFactory validatorFactory;
    @Value(value="${app.debug}")
    protected boolean appDebugProperty;
    @Value(value="${app.optimize}")
    protected boolean appOptimizeProperty;
    @Value(value="${wicket.configuration}")
    protected String wicketConfiguration;

    @Bean
    public MessageSourceAccessor webMessageSource() {
        ReloadableResourceBundleMessageSource reloadableResourceBundleMessageSource = new ReloadableResourceBundleMessageSource();
        reloadableResourceBundleMessageSource.setBasename("web");
        reloadableResourceBundleMessageSource.setDefaultEncoding(DataContext.ENCODING);
        reloadableResourceBundleMessageSource.setCacheSeconds(-1);
        return new MessageSourceAccessor((MessageSource)reloadableResourceBundleMessageSource);
    }

    @Bean
    public ModelValidator webModelValidator() {
        return new ModelValidatorImpl(this.validatorFactory, new MessageSourceAccessor[]{this.webMessageSource(), this.dataMessageSource});
    }

    @Bean
    public WebApplication webApplication() {
        RuntimeConfigurationType runtimeConfigurationType = RuntimeConfigurationType.valueOf((String)this.wicketConfiguration.toUpperCase());
        return new WebApplicationImpl(this.appDebugProperty, this.appOptimizeProperty, runtimeConfigurationType, new IStringResourceLoader[]{new WebMessages(this.dataMessageSource), new WebMessages(this.webMessageSource())});
    }

    static {
        HTTP_CACHE_DURATION = Duration.days((int)1);
        HTTP_MAXIMUM_UPLOAD = Bytes.megabytes((long)1L);
        HTTP_TIME_OUT = Duration.seconds((int)30);
        REFERENTIEL_CODES = new ArrayList(DataContext.REFERENTIELS.keySet());
        HashMap hashMap = new HashMap(DataContext.LOCALES.size());
        HashMap hashMap2 = new HashMap(DataContext.LOCALES.size());
        for (Locale locale : DataContext.LOCALES) {
            Object object2;
            ArrayList<Pair> arrayList = new ArrayList<Pair>(DataContext.COUNTRY_CODES.size());
            for (Object object2 : DataContext.COUNTRY_CODES) {
                String string = new Locale(locale.getLanguage(), (String)object2).getDisplayCountry(locale);
                arrayList.add(new Pair(object2, (Object)new Pair((Object)StringTools.replaceAccents((String)string), (Object)string)));
            }
            Collections.sort(arrayList, new /* Unavailable Anonymous Inner Class!! */);
            LinkedHashMap linkedHashMap = new LinkedHashMap(arrayList.size());
            object2 = new ArrayList(arrayList.size());
            for (Pair pair : arrayList) {
                linkedHashMap.put(pair.getKey(), ((Pair)pair.getValue()).getValue());
                object2.add(pair.getKey());
            }
            hashMap.put(locale, Collections.unmodifiableMap(linkedHashMap));
            hashMap2.put(locale, Collections.unmodifiableList(object2));
        }
        COUNTRIES = Collections.unmodifiableMap(hashMap);
        COUNTRY_CODES = Collections.unmodifiableMap(hashMap2);
    }
}

