/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.web.config;

import java.math.BigDecimal;
import nc.ird.cantharella.data.config.DataContext;
import nc.ird.cantharella.data.exceptions.DataConstraintException;
import nc.ird.cantharella.data.exceptions.UnexpectedException;
import nc.ird.cantharella.service.services.PersonneService;
import nc.ird.cantharella.web.config.WebApplicationImpl;
import nc.ird.cantharella.web.config.WebContext;
import nc.ird.cantharella.web.pages.ContactPage;
import nc.ird.cantharella.web.pages.HomePage;
import nc.ird.cantharella.web.pages.domain.campagne.ListCampagnesPage;
import nc.ird.cantharella.web.pages.domain.campagne.ManageCampagnePage;
import nc.ird.cantharella.web.pages.domain.campagne.ReadCampagnePage;
import nc.ird.cantharella.web.pages.domain.config.ListConfigurationPage;
import nc.ird.cantharella.web.pages.domain.extraction.ListExtractionsPage;
import nc.ird.cantharella.web.pages.domain.extraction.ManageExtractionPage;
import nc.ird.cantharella.web.pages.domain.extraction.ReadExtractionPage;
import nc.ird.cantharella.web.pages.domain.lot.ListLotsPage;
import nc.ird.cantharella.web.pages.domain.lot.ManageLotPage;
import nc.ird.cantharella.web.pages.domain.lot.ReadLotPage;
import nc.ird.cantharella.web.pages.domain.personne.ListPersonnesPage;
import nc.ird.cantharella.web.pages.domain.personne.ManagePersonnePage;
import nc.ird.cantharella.web.pages.domain.personne.ReadPersonnePage;
import nc.ird.cantharella.web.pages.domain.purification.ListPurificationsPage;
import nc.ird.cantharella.web.pages.domain.purification.ManagePurificationPage;
import nc.ird.cantharella.web.pages.domain.purification.ReadPurificationPage;
import nc.ird.cantharella.web.pages.domain.specimen.ListSpecimensPage;
import nc.ird.cantharella.web.pages.domain.specimen.ManageSpecimenPage;
import nc.ird.cantharella.web.pages.domain.specimen.ReadSpecimenPage;
import nc.ird.cantharella.web.pages.domain.station.ListStationsPage;
import nc.ird.cantharella.web.pages.domain.station.ManageStationPage;
import nc.ird.cantharella.web.pages.domain.station.ReadStationPage;
import nc.ird.cantharella.web.pages.domain.testBio.ListTestsBioPage;
import nc.ird.cantharella.web.pages.domain.testBio.ManageTestBioPage;
import nc.ird.cantharella.web.pages.domain.testBio.ReadTestBioPage;
import nc.ird.cantharella.web.pages.domain.utilisateur.ManageUtilisateurPage;
import nc.ird.cantharella.web.pages.domain.utilisateur.RegisterPage;
import nc.ird.cantharella.web.pages.domain.utilisateur.ResetPasswordPage;
import nc.ird.cantharella.web.pages.domain.utilisateur.UpdateUtilisateurPage;
import nc.ird.cantharella.web.pages.errors.AccessDeniedPage;
import nc.ird.cantharella.web.pages.errors.InternalErrorPage;
import nc.ird.cantharella.web.pages.errors.PageExpiredErrorPage;
import nc.ird.cantharella.web.utils.converters.BigDecimalConverterImpl;
import nc.ird.cantharella.web.utils.converters.DoubleConverterImpl;
import nc.ird.cantharella.web.utils.security.AuthSession;
import nc.ird.cantharella.web.utils.security.AuthStrategy;
import nc.ird.module.utils.AssertTools;
import nc.ird.module.utils.LogTools;
import org.apache.commons.logging.Log;
import org.apache.wicket.ConverterLocator;
import org.apache.wicket.IConverterLocator;
import org.apache.wicket.RuntimeConfigurationType;
import org.apache.wicket.Session;
import org.apache.wicket.authentication.IAuthenticationStrategy;
import org.apache.wicket.authorization.IAuthorizationStrategy;
import org.apache.wicket.css.ICssCompressor;
import org.apache.wicket.injection.Injector;
import org.apache.wicket.javascript.DefaultJavaScriptCompressor;
import org.apache.wicket.javascript.IJavaScriptCompressor;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.request.IRequestMapper;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.Response;
import org.apache.wicket.request.mapper.MountedMapper;
import org.apache.wicket.request.mapper.PackageMapper;
import org.apache.wicket.request.mapper.mount.MountMapper;
import org.apache.wicket.resource.NoOpTextCompressor;
import org.apache.wicket.resource.loader.IStringResourceLoader;
import org.apache.wicket.settings.IExceptionSettings;
import org.apache.wicket.settings.IRequestCycleSettings;
import org.apache.wicket.spring.injection.annot.SpringBean;
import org.apache.wicket.spring.injection.annot.SpringComponentInjector;
import org.apache.wicket.util.lang.PackageName;
import org.apache.wicket.util.time.Duration;

/*
 * Exception performing whole class analysis ignored.
 */
public final class WebApplicationImpl
extends WebApplication {
    private static final Log LOG = LogTools.getLog();
    private final boolean debug;
    private final IStringResourceLoader[] messages;
    private final boolean optimize;
    @SpringBean
    private PersonneService personneService;
    private final RuntimeConfigurationType wicketConfiguration;

    public static void injectSpringBeans(Object object) {
        Injector.get().inject(object);
    }

    public WebApplicationImpl(boolean bl, boolean bl2, RuntimeConfigurationType runtimeConfigurationType, IStringResourceLoader ... iStringResourceLoaderArray) {
        AssertTools.assertArrayNotNull((Object[])iStringResourceLoaderArray);
        this.debug = bl;
        this.optimize = bl2;
        this.wicketConfiguration = runtimeConfigurationType;
        this.messages = iStringResourceLoaderArray;
    }

    public RuntimeConfigurationType getConfigurationType() {
        return this.wicketConfiguration;
    }

    public Class<HomePage> getHomePage() {
        return HomePage.class;
    }

    protected void init() {
        super.init();
        this.getComponentInstantiationListeners().add((Object)new SpringComponentInjector((WebApplication)this));
        WebApplicationImpl.injectSpringBeans((Object)this);
        try {
            this.personneService.checkOrCreateAdmin();
        }
        catch (DataConstraintException dataConstraintException) {
            LOG.error((Object)dataConstraintException.getMessage(), (Throwable)dataConstraintException);
            throw new UnexpectedException((Exception)((Object)dataConstraintException));
        }
        this.setApplicationSettings();
        this.setDebugSettings();
        this.setExceptionSettings();
        this.setFrameworkSettings();
        this.setMarkupSettings();
        this.setPageSettings();
        this.setRequestCycleSettings();
        this.setRequestLoggerSettings();
        this.setResourceSettings();
        this.setSecuritySettings();
        this.mountUrls();
    }

    protected IConverterLocator newConverterLocator() {
        ConverterLocator converterLocator = (ConverterLocator)super.newConverterLocator();
        converterLocator.set(Double.class, DoubleConverterImpl.INSTANCE);
        converterLocator.set(BigDecimal.class, BigDecimalConverterImpl.INSTANCE);
        return converterLocator;
    }

    public Session newSession(Request request, Response response) {
        return new AuthSession(request);
    }

    private void setApplicationSettings() {
        this.getApplicationSettings().setAccessDeniedPage(AccessDeniedPage.class);
        this.getApplicationSettings().setDefaultMaximumUploadSize(WebContext.HTTP_MAXIMUM_UPLOAD);
        this.getApplicationSettings().setInternalErrorPage(InternalErrorPage.class);
        this.getApplicationSettings().setPageExpiredErrorPage(PageExpiredErrorPage.class);
    }

    private void setDebugSettings() {
        this.getDebugSettings().setAjaxDebugModeEnabled(this.debug);
        this.getDebugSettings().setComponentUseCheck(this.debug);
        this.getDebugSettings().setDevelopmentUtilitiesEnabled(this.debug);
        this.getDebugSettings().setLinePreciseReportingOnAddComponentEnabled(this.debug);
        this.getDebugSettings().setLinePreciseReportingOnNewComponentEnabled(this.debug);
        this.getDebugSettings().setOutputComponentPath(this.debug);
        this.getDebugSettings().setOutputMarkupContainerClassName(this.debug);
    }

    private void setExceptionSettings() {
        this.getExceptionSettings().setUnexpectedExceptionDisplay(this.debug ? IExceptionSettings.SHOW_EXCEPTION_PAGE : IExceptionSettings.SHOW_INTERNAL_ERROR_PAGE);
    }

    private void setFrameworkSettings() {
        this.getFrameworkSettings().setDetachListener(null);
    }

    private void setMarkupSettings() {
        this.getMarkupSettings().setAutomaticLinking(false);
        this.getMarkupSettings().setCompressWhitespace(this.optimize);
        this.getMarkupSettings().setDefaultAfterDisabledLink("</strike");
        this.getMarkupSettings().setDefaultBeforeDisabledLink("<strike>");
        this.getMarkupSettings().setDefaultMarkupEncoding(DataContext.ENCODING);
        this.getMarkupSettings().setStripComments(this.optimize);
        this.getMarkupSettings().setStripWicketTags(true);
        this.getMarkupSettings().setThrowExceptionOnMissingXmlDeclaration(false);
    }

    private void setPageSettings() {
        this.getPageSettings().setVersionPagesByDefault(true);
    }

    private void setRequestCycleSettings() {
        this.getRequestCycleSettings().setBufferResponse(true);
        this.getRequestCycleSettings().setGatherExtendedBrowserInfo(false);
        this.getRequestCycleSettings().setRenderStrategy(IRequestCycleSettings.RenderStrategy.REDIRECT_TO_BUFFER);
        this.getRequestCycleSettings().setResponseRequestEncoding(DataContext.ENCODING);
        this.getRequestCycleSettings().setTimeout(WebContext.HTTP_TIME_OUT);
    }

    private void setRequestLoggerSettings() {
        this.getRequestLoggerSettings().setRecordSessionSize(this.debug);
        this.getRequestLoggerSettings().setRequestLoggerEnabled(this.debug);
        this.getRequestLoggerSettings().setRequestsWindowSize(2000);
    }

    private void setResourceSettings() {
        for (IStringResourceLoader iStringResourceLoader : this.messages) {
            this.getResourceSettings().getStringResourceLoaders().add(iStringResourceLoader);
        }
        this.getResourceSettings().setDefaultCacheDuration(this.optimize ? WebContext.HTTP_CACHE_DURATION : Duration.NONE);
        this.getResourceSettings().setJavaScriptCompressor((IJavaScriptCompressor)(this.optimize ? new DefaultJavaScriptCompressor() : null));
        this.getResourceSettings().setCssCompressor((ICssCompressor)(this.optimize ? new NoOpTextCompressor() : null));
        this.getResourceSettings().setParentFolderPlaceholder(null);
        this.getResourceSettings().setResourcePollFrequency(null);
        this.getResourceSettings().setThrowExceptionOnMissingResource(true);
        this.getResourceSettings().setUseDefaultOnMissingResource(!this.debug);
    }

    private void setSecuritySettings() {
        this.getSecuritySettings().setAuthorizationStrategy((IAuthorizationStrategy)new AuthStrategy());
        1 var1_1 = new /* Unavailable Anonymous Inner Class!! */;
        this.getSecuritySettings().setAuthenticationStrategy((IAuthenticationStrategy)var1_1);
        this.getSecuritySettings().setEnforceMounts(false);
    }

    private void mountUrls() {
        this.getRootRequestMapperAsCompound().add((IRequestMapper)new MountedMapper("/campagne/list", ListCampagnesPage.class));
        this.mountPage("/campagne/list", ListCampagnesPage.class);
        this.getRootRequestMapperAsCompound().add((IRequestMapper)new MountedMapper("/campagne/edit", ManageCampagnePage.class));
        this.mountPage("/campagne/edit", ManageCampagnePage.class);
        this.getRootRequestMapperAsCompound().add((IRequestMapper)new MountedMapper("/campagne/view", ReadCampagnePage.class));
        this.mountPage("/campagne/view", ReadCampagnePage.class);
        this.getRootRequestMapperAsCompound().add((IRequestMapper)new MountMapper("/config", (IRequestMapper)new PackageMapper(PackageName.forClass(ListConfigurationPage.class))));
        this.getRootRequestMapperAsCompound().add((IRequestMapper)new MountedMapper("/extraction/list", ListExtractionsPage.class));
        this.mountPage("/extraction/list", ListExtractionsPage.class);
        this.getRootRequestMapperAsCompound().add((IRequestMapper)new MountedMapper("/extraction/edit", ManageExtractionPage.class));
        this.mountPage("/extraction/edit", ManageExtractionPage.class);
        this.getRootRequestMapperAsCompound().add((IRequestMapper)new MountedMapper("/extraction/view", ReadExtractionPage.class));
        this.mountPage("/extraction/view", ReadExtractionPage.class);
        this.getRootRequestMapperAsCompound().add((IRequestMapper)new MountedMapper("/lot/list", ListLotsPage.class));
        this.mountPage("/lot/list", ListLotsPage.class);
        this.getRootRequestMapperAsCompound().add((IRequestMapper)new MountedMapper("/lot/edit", ManageLotPage.class));
        this.mountPage("/lot/edit", ManageLotPage.class);
        this.getRootRequestMapperAsCompound().add((IRequestMapper)new MountedMapper("/lot/view", ReadLotPage.class));
        this.mountPage("/lot/view", ReadLotPage.class);
        this.getRootRequestMapperAsCompound().add((IRequestMapper)new MountedMapper("/personne/list", ListPersonnesPage.class));
        this.mountPage("/personne/list", ListPersonnesPage.class);
        this.getRootRequestMapperAsCompound().add((IRequestMapper)new MountedMapper("/personne/edit", ManagePersonnePage.class));
        this.mountPage("/personne/edit", ManagePersonnePage.class);
        this.getRootRequestMapperAsCompound().add((IRequestMapper)new MountedMapper("/personne/view", ReadPersonnePage.class));
        this.mountPage("/personne/view", ReadPersonnePage.class);
        this.getRootRequestMapperAsCompound().add((IRequestMapper)new MountedMapper("/purification/list", ListPurificationsPage.class));
        this.mountPage("/purification/list", ListPurificationsPage.class);
        this.getRootRequestMapperAsCompound().add((IRequestMapper)new MountedMapper("/purification/edit", ManagePurificationPage.class));
        this.mountPage("/purification/edit", ManagePurificationPage.class);
        this.getRootRequestMapperAsCompound().add((IRequestMapper)new MountedMapper("/purification/view", ReadPurificationPage.class));
        this.mountPage("/purification/view", ReadPurificationPage.class);
        this.getRootRequestMapperAsCompound().add((IRequestMapper)new MountedMapper("/specimen/list", ListSpecimensPage.class));
        this.mountPage("/specimen/list", ListSpecimensPage.class);
        this.getRootRequestMapperAsCompound().add((IRequestMapper)new MountedMapper("/specimen/edit", ManageSpecimenPage.class));
        this.mountPage("/specimen/edit", ManageSpecimenPage.class);
        this.getRootRequestMapperAsCompound().add((IRequestMapper)new MountedMapper("/specimen/view", ReadSpecimenPage.class));
        this.mountPage("/specimen/view", ReadSpecimenPage.class);
        this.getRootRequestMapperAsCompound().add((IRequestMapper)new MountedMapper("/station/list", ListStationsPage.class));
        this.mountPage("/station/list", ListStationsPage.class);
        this.getRootRequestMapperAsCompound().add((IRequestMapper)new MountedMapper("/station/edit", ManageStationPage.class));
        this.mountPage("/station/edit", ManageStationPage.class);
        this.getRootRequestMapperAsCompound().add((IRequestMapper)new MountedMapper("/station/view", ReadStationPage.class));
        this.mountPage("/station/view", ReadStationPage.class);
        this.getRootRequestMapperAsCompound().add((IRequestMapper)new MountedMapper("/testBio/list", ListTestsBioPage.class));
        this.mountPage("/testBio/list", ListTestsBioPage.class);
        this.getRootRequestMapperAsCompound().add((IRequestMapper)new MountedMapper("/testBio/edit", ManageTestBioPage.class));
        this.mountPage("/testBio/edit", ManageTestBioPage.class);
        this.getRootRequestMapperAsCompound().add((IRequestMapper)new MountedMapper("/testBio/view", ReadTestBioPage.class));
        this.mountPage("/testBio/view", ReadTestBioPage.class);
        this.getRootRequestMapperAsCompound().add((IRequestMapper)new MountedMapper("/utilisateur/edit", ManageUtilisateurPage.class));
        this.mountPage("/utilisateur/edit", ManageUtilisateurPage.class);
        this.getRootRequestMapperAsCompound().add((IRequestMapper)new MountedMapper("/utilisateur/update", UpdateUtilisateurPage.class));
        this.mountPage("/utilisateur/update", UpdateUtilisateurPage.class);
        this.getRootRequestMapperAsCompound().add((IRequestMapper)new MountedMapper("/contact", ContactPage.class));
        this.mountPage("/contact", ContactPage.class);
        this.getRootRequestMapperAsCompound().add((IRequestMapper)new MountedMapper("/register", RegisterPage.class));
        this.mountPage("/register", RegisterPage.class);
        this.getRootRequestMapperAsCompound().add((IRequestMapper)new MountedMapper("/passwordLost", ResetPasswordPage.class));
        this.mountPage("/passwordLost", ResetPasswordPage.class);
    }
}

