/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.utils;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import nc.ird.cantharella.utils.AssertTools;
import org.apache.commons.io.LineIterator;
import org.apache.commons.lang3.StringUtils;

public final class StringTools {
    public static <O1, O2> String couplesToString(Map<O1, O2> couples, String separatorKeysValues, String separatorCouples) {
        AssertTools.assertNotNull(couples);
        AssertTools.assertNotNull(separatorKeysValues);
        AssertTools.assertNotNull(separatorCouples);
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<O1, O2> entry : couples.entrySet()) {
            builder.append(entry.getKey() + separatorKeysValues + entry.getValue() + separatorCouples);
        }
        return StringUtils.stripToNull((String)StringTools.truncate(builder, separatorCouples));
    }

    public static String listToString(List<? extends Object> list, String delimiter) {
        AssertTools.assertNotNull(list);
        AssertTools.assertNotEmpty(delimiter);
        StringBuilder builder = new StringBuilder();
        Iterator<? extends Object> itBeans = list.iterator();
        while (itBeans.hasNext()) {
            Object bean = itBeans.next();
            builder.append(bean.toString());
            if (!itBeans.hasNext()) continue;
            builder.append(delimiter);
        }
        return builder.toString();
    }

    public static int length(String string) {
        return string == null ? -1 : string.length();
    }

    public static Iterator<String> lineIterator(String string) {
        AssertTools.assertNotNull(string);
        ArrayList<String> lines = new ArrayList<String>();
        LineIterator i = new LineIterator((Reader)new StringReader(string));
        while (i.hasNext()) {
            String line = StringUtils.trimToNull((String)i.nextLine());
            if (line == null) continue;
            lines.add(line);
        }
        return lines.iterator();
    }

    public static Iterator<String> lineIterator(StringBuilder stringBuilder) {
        AssertTools.assertNotNull(stringBuilder);
        return StringTools.lineIterator(stringBuilder.toString());
    }

    public static String replaceAccents(String string) {
        return StringUtils.stripAccents((String)string);
    }

    public static String replaceConsecutiveWhitespaces(String string) {
        return StringUtils.isEmpty((CharSequence)string) ? string : string.replaceAll("\\p{Space}+", " ");
    }

    public static String replaceConsecutiveWhitespacesByUnderscore(String string) {
        return StringUtils.isEmpty((CharSequence)string) ? string : string.replaceAll("\\p{Space}+", "_");
    }

    public static String replaceNonAlpha(String string) {
        return StringUtils.isEmpty((CharSequence)string) ? string : string.replaceAll("[^\\p{Alpha}]", " ");
    }

    public static String truncate(String toTruncate, String truncation) {
        AssertTools.assertNotNull(truncation);
        String result = toTruncate;
        if (!StringUtils.isEmpty((CharSequence)toTruncate) && toTruncate.length() >= truncation.length() && truncation.equals(toTruncate.substring(toTruncate.length() - truncation.length(), toTruncate.length()))) {
            result = toTruncate.substring(0, toTruncate.length() - truncation.length());
        }
        return result;
    }

    public static String truncate(StringBuilder toTruncate, String truncation) {
        return toTruncate != null ? StringTools.truncate(toTruncate.toString(), truncation) : null;
    }

    private StringTools() {
    }

    public static <T> Comparator<T> createStringComparator() {
        return new Comparator<T>(){

            @Override
            public int compare(T t1, T t2) {
                String t1String = t1 == null ? "" : t1.toString();
                String t2String = t2 == null ? "" : t2.toString();
                return t1String.compareTo(t2String);
            }
        };
    }
}

