/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.utils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Locale;
import nc.ird.cantharella.utils.AssertTools;

public final class NumberTools {
    private NumberTools() {
    }

    public static <N extends Number> N nullIfZero(N n) {
        return n == null || n.doubleValue() == 0.0 ? null : (N)n;
    }

    public static Double parseDouble(String value, Locale locale, int maxFractionDigit) {
        AssertTools.assertNotEmpty(value);
        AssertTools.assertNotNull(locale);
        DecimalFormat fmt = (DecimalFormat)DecimalFormat.getNumberInstance(locale);
        fmt.setMaximumFractionDigits(maxFractionDigit);
        fmt.setRoundingMode(RoundingMode.HALF_UP);
        ParsePosition position = new ParsePosition(0);
        Number nb = (Number)fmt.parseObject(value, position);
        if (position.getIndex() != value.length()) {
            if (value.charAt(position.getIndex()) == '.') {
                DecimalFormatSymbols symbols = new DecimalFormatSymbols(locale);
                symbols.setDecimalSeparator('.');
                fmt.setDecimalFormatSymbols(symbols);
                position = new ParsePosition(0);
                nb = (Number)fmt.parseObject(value, position);
                if (position.getIndex() != value.length()) {
                    throw new NumberFormatException("Cannot convert '" + value + "' to Double. Parse failed at position " + position.getIndex() + ".");
                }
            } else {
                throw new NumberFormatException("Cannot convert '" + value + "' to Double. Parse failed at position " + position.getIndex() + ".");
            }
        }
        return nb.doubleValue();
    }

    public static BigDecimal parseBigDecimal(String value, Locale locale, int maxFractionDigit, int maxIntegerDigit) {
        AssertTools.assertNotEmpty(value);
        AssertTools.assertNotNull(locale);
        DecimalFormat fmt = (DecimalFormat)NumberFormat.getNumberInstance(locale);
        fmt.setMaximumFractionDigits(maxFractionDigit);
        fmt.setMaximumIntegerDigits(maxIntegerDigit);
        fmt.setParseBigDecimal(true);
        ParsePosition position = new ParsePosition(0);
        BigDecimal bd = (BigDecimal)fmt.parseObject(value, position);
        if (position.getIndex() != value.length()) {
            if (value.charAt(position.getIndex()) == '.') {
                DecimalFormatSymbols symbols = new DecimalFormatSymbols(locale);
                symbols.setDecimalSeparator('.');
                fmt.setDecimalFormatSymbols(symbols);
                position = new ParsePosition(0);
                bd = (BigDecimal)fmt.parseObject(value, position);
                if (position.getIndex() != value.length()) {
                    throw new NumberFormatException("Cannot convert '" + value + "' to BigDecimal. Parse failed at position " + position.getIndex() + ".");
                }
            } else {
                throw new NumberFormatException("Cannot convert '" + value + "' to BigDecimal. Parse failed at position " + position.getIndex() + ".");
            }
        }
        return bd;
    }

    public static String doubleToString(Double value, Locale locale, int minFractionDigit, int maxFractionDigit) {
        AssertTools.assertNotNull(value);
        AssertTools.assertNotNull(locale);
        NumberFormat fmt = NumberFormat.getInstance(locale);
        if (fmt != null) {
            fmt.setMinimumFractionDigits(minFractionDigit);
            fmt.setMaximumFractionDigits(maxFractionDigit);
            fmt.setRoundingMode(RoundingMode.HALF_UP);
            return fmt.format(value);
        }
        return value.toString();
    }

    public static String bigDecimalToString(BigDecimal value, Locale locale, int minFractionDigit, int maxFractionDigit, int maxIntegerDigit) {
        AssertTools.assertNotNull(value);
        AssertTools.assertNotNull(locale);
        NumberFormat fmt = NumberFormat.getInstance(locale);
        if (fmt != null) {
            fmt.setMinimumFractionDigits(minFractionDigit);
            fmt.setMaximumFractionDigits(maxFractionDigit);
            fmt.setMaximumIntegerDigits(maxIntegerDigit);
            fmt.setRoundingMode(RoundingMode.HALF_UP);
            return fmt.format(value);
        }
        return value.toString();
    }
}

