/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.utils;

import java.util.Comparator;

public class IntuitiveStringComparator<T extends CharSequence>
implements Comparator<T> {
    private T str1;
    private T str2;
    private int pos1;
    private int pos2;
    private int len1;
    private int len2;

    @Override
    public int compare(T s1, T s2) {
        this.str1 = s1;
        this.str2 = s2;
        this.len1 = this.str1.length();
        this.len2 = this.str2.length();
        this.pos2 = 0;
        this.pos1 = 0;
        if (this.len1 == 0) {
            return this.len2 == 0 ? 0 : -1;
        }
        if (this.len2 == 0) {
            return 1;
        }
        while (this.pos1 < this.len1 && this.pos2 < this.len2) {
            char ch1 = this.str1.charAt(this.pos1);
            char ch2 = this.str2.charAt(this.pos2);
            int result = 0;
            if (Character.isDigit(ch1)) {
                result = Character.isDigit(ch2) ? this.compareNumbers() : -1;
            } else if (Character.isLetter(ch1)) {
                result = Character.isLetter(ch2) ? this.compareOther(true) : 1;
            } else {
                int n = Character.isDigit(ch2) ? 1 : (result = Character.isLetter(ch2) ? -1 : this.compareOther(false));
            }
            if (result == 0) continue;
            return result;
        }
        return this.len1 - this.len2;
    }

    private int compareNumbers() {
        int delta = 0;
        int zeroes1 = 0;
        int zeroes2 = 0;
        char ch1 = '\u0000';
        char ch2 = '\u0000';
        while (this.pos1 < this.len1 && (ch1 = this.str1.charAt(this.pos1++)) == '0') {
            ++zeroes1;
        }
        while (this.pos2 < this.len2 && (ch2 = this.str2.charAt(this.pos2++)) == '0') {
            ++zeroes2;
        }
        while (true) {
            boolean noMoreDigits2;
            boolean noMoreDigits1 = ch1 == '\u0000' || !Character.isDigit(ch1);
            boolean bl = noMoreDigits2 = ch2 == '\u0000' || !Character.isDigit(ch2);
            if (noMoreDigits1 && noMoreDigits2) {
                return delta != 0 ? delta : zeroes1 - zeroes2;
            }
            if (noMoreDigits1) {
                return -1;
            }
            if (noMoreDigits2) {
                return 1;
            }
            if (delta == 0 && ch1 != ch2) {
                delta = ch1 - ch2;
            }
            ch1 = this.pos1 < this.len1 ? this.str1.charAt(this.pos1++) : (char)'\u0000';
            ch2 = this.pos2 < this.len2 ? this.str2.charAt(this.pos2++) : (char)'\u0000';
        }
    }

    private int compareOther(boolean isLetters) {
        char ch2;
        char ch1;
        if ((ch1 = this.str1.charAt(this.pos1++)) == (ch2 = this.str2.charAt(this.pos2++))) {
            return 0;
        }
        if (isLetters && (ch1 = Character.toUpperCase(ch1)) != (ch2 = Character.toUpperCase(ch2))) {
            ch1 = Character.toLowerCase(ch1);
            ch2 = Character.toLowerCase(ch2);
        }
        return ch1 - ch2;
    }
}

