/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.utils;

import au.com.bytecode.opencsv.CSVWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenerateCsv {
    private static final Logger LOG = LoggerFactory.getLogger(GenerateCsv.class);
    private char columnsSeparator;
    private String copyright;
    private String encoding;
    private static final String DEFAULT_COPYRIGHT = "\u00a9IRD tous droits r\u00e9serv\u00e9s";
    public static final String CHARSET_UTF_8 = "UTF-8";
    public static final String CHARSET_ISO_8859_1 = "ISO-8859-1";

    public GenerateCsv() {
        this(';', CHARSET_UTF_8);
    }

    public GenerateCsv(String encoding) {
        this(';', encoding);
    }

    public GenerateCsv(char columnsSeparator, String encoding) {
        this.setColumnsSeparator(columnsSeparator);
        this.setEncoding(encoding);
        this.setCopyright(DEFAULT_COPYRIGHT);
    }

    public ByteArrayOutputStream writeCSV(List<String[]> data, boolean withCopyright) throws IOException {
        ByteArrayOutputStream csvStream = new ByteArrayOutputStream();
        OutputStreamWriter outWriter = new OutputStreamWriter((OutputStream)csvStream, this.encoding);
        CSVWriter csvWriter = new CSVWriter((Writer)outWriter, this.getColumnsSeparator());
        csvWriter.writeAll(data);
        if (withCopyright) {
            csvWriter.writeNext(new String[]{this.getCopyright()});
        }
        csvWriter.close();
        LOG.debug("data written in the CSV stream");
        return csvStream;
    }

    public String getCopyright() {
        return this.copyright;
    }

    public void setCopyright(String copyright) {
        this.copyright = copyright;
    }

    public char getColumnsSeparator() {
        return this.columnsSeparator;
    }

    public void setColumnsSeparator(char columnsSeparator) {
        this.columnsSeparator = columnsSeparator;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }
}

