/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.utils;

import java.math.BigDecimal;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nc.ird.cantharella.utils.AssertTools;
import nc.ird.cantharella.utils.NumberTools;
import org.apache.commons.lang3.StringUtils;

public final class CoordTools {
    public static final char DEGREES = '\u00b0';
    public static final int LATITUDE_LENGTH = 11;
    public static final int LATITUDE_MAX_DEGREES = 90;
    public static final String LATITUDE_MAX_MINUTES_STRING = "59.999";
    public static final BigDecimal LATITUDE_MAX_MINUTES;
    public static final int LATITUDE_MIN_DEGREES = 0;
    public static final String LATITUDE_MIN_MINUTES_STRING = "00.000";
    public static final BigDecimal LATITUDE_MIN_MINUTES;
    public static final Character[] LATITUDE_ORIENTATIONS;
    private static final Pattern LATITUDE_PATTERN;
    public static final int LONGITUDE_LENGTH = 12;
    public static final int LONGITUDE_MAX_DEGREES = 180;
    public static final String LONGITUDE_MAX_MINUTES_STRING = "59.999";
    public static final BigDecimal LONGITUDE_MAX_MINUTES;
    public static final int LONGITUDE_MIN_DEGREES = 0;
    public static final String LONGITUDE_MIN_MINUTES_STRING = "00.000";
    public static final BigDecimal LONGITUDE_MIN_MINUTES;
    public static final Character[] LONGITUDE_ORIENTATIONS;
    private static final Pattern LONGITUDE_PATTERN;
    public static final char MINUTES = '\'';
    private static final char MINUTES_BLANK = '0';
    private static final int MINUTES_DECIMAL_LENGTH;
    private static final int MINUTES_INTEGER_LENGTH;
    public static final char MINUTES_SEPARATOR = '.';
    private static final String MINUTES_SEPARATOR_PATTERN = "\\.";

    public static String latitude(Integer d, BigDecimal m, Character o) {
        AssertTools.assertGreaterOrEquals(d, 0);
        AssertTools.assertLowerOrEquals(d, 90);
        AssertTools.assertGreaterOrEquals(m, LATITUDE_MIN_MINUTES);
        AssertTools.assertLowerOrEquals(m, LATITUDE_MAX_MINUTES);
        AssertTools.assertIn(Character.valueOf(Character.toUpperCase(o.charValue())), LATITUDE_ORIENTATIONS);
        String[] md = NumberTools.bigDecimalToString(m, Locale.ENGLISH, MINUTES_DECIMAL_LENGTH, MINUTES_DECIMAL_LENGTH, 2).split(MINUTES_SEPARATOR_PATTERN);
        return StringUtils.leftPad((String)String.valueOf(d), (int)String.valueOf(90).length()) + '\u00b0' + StringUtils.leftPad((String)String.valueOf(md[0]), (int)MINUTES_INTEGER_LENGTH, (char)'0') + '.' + StringUtils.rightPad((String)md[1], (int)MINUTES_DECIMAL_LENGTH, (char)'0') + '\'' + Character.toUpperCase(o.charValue());
    }

    public static Integer latitudeDegrees(String latitude) {
        if (StringUtils.isEmpty((CharSequence)latitude)) {
            return null;
        }
        Matcher matcher = LATITUDE_PATTERN.matcher(latitude);
        matcher.lookingAt();
        return Integer.valueOf(matcher.group(1).trim());
    }

    public static BigDecimal latitudeMinutes(String latitude) {
        if (StringUtils.isEmpty((CharSequence)latitude)) {
            return null;
        }
        Matcher matcher = LATITUDE_PATTERN.matcher(latitude);
        matcher.lookingAt();
        return NumberTools.parseBigDecimal(matcher.group(2) + '.' + matcher.group(3), Locale.ENGLISH, MINUTES_DECIMAL_LENGTH, 2);
    }

    public static Character latitudeOrientation(String latitude) {
        if (StringUtils.isEmpty((CharSequence)latitude)) {
            return null;
        }
        Matcher matcher = LATITUDE_PATTERN.matcher(latitude);
        matcher.lookingAt();
        return Character.valueOf(matcher.group(4).charAt(0));
    }

    public static String longitude(Integer d, BigDecimal m, Character o) {
        AssertTools.assertGreaterOrEquals(d, 0);
        AssertTools.assertLowerOrEquals(d, 180);
        AssertTools.assertGreaterOrEquals(m, LONGITUDE_MIN_MINUTES);
        AssertTools.assertLowerOrEquals(m, LONGITUDE_MAX_MINUTES);
        AssertTools.assertIn(Character.valueOf(Character.toUpperCase(o.charValue())), LONGITUDE_ORIENTATIONS);
        String[] md = NumberTools.bigDecimalToString(m, Locale.ENGLISH, MINUTES_DECIMAL_LENGTH, MINUTES_DECIMAL_LENGTH, 3).split(MINUTES_SEPARATOR_PATTERN);
        return StringUtils.leftPad((String)String.valueOf(d), (int)String.valueOf(180).length()) + '\u00b0' + StringUtils.leftPad((String)String.valueOf(md[0]), (int)MINUTES_INTEGER_LENGTH, (char)'0') + '.' + StringUtils.rightPad((String)md[1], (int)MINUTES_DECIMAL_LENGTH, (char)'0') + '\'' + Character.toUpperCase(o.charValue());
    }

    public static Integer longitudeDegrees(String longitude) {
        if (StringUtils.isEmpty((CharSequence)longitude)) {
            return null;
        }
        Matcher matcher = LONGITUDE_PATTERN.matcher(longitude);
        matcher.lookingAt();
        return Integer.valueOf(matcher.group(1).trim());
    }

    public static BigDecimal longitudeMinutes(String longitude) {
        if (StringUtils.isEmpty((CharSequence)longitude)) {
            return null;
        }
        Matcher matcher = LONGITUDE_PATTERN.matcher(longitude);
        matcher.lookingAt();
        return NumberTools.parseBigDecimal(matcher.group(2) + '.' + matcher.group(3), Locale.ENGLISH, MINUTES_DECIMAL_LENGTH, 3);
    }

    public static Character longitudeOrientation(String longitude) {
        if (StringUtils.isEmpty((CharSequence)longitude)) {
            return null;
        }
        Matcher matcher = LONGITUDE_PATTERN.matcher(longitude);
        matcher.lookingAt();
        return Character.valueOf(matcher.group(4).charAt(0));
    }

    public static boolean validateLatitude(String latitude) {
        AssertTools.assertNotEmpty(latitude);
        Matcher matcher = LATITUDE_PATTERN.matcher(latitude);
        if (matcher.lookingAt()) {
            int d = Integer.valueOf(matcher.group(1).trim());
            BigDecimal m = NumberTools.parseBigDecimal(matcher.group(2) + '.' + matcher.group(3), Locale.ENGLISH, MINUTES_DECIMAL_LENGTH, 2);
            return d >= 0 && d <= 90 && LATITUDE_MIN_MINUTES.compareTo(m) <= 0 && LATITUDE_MAX_MINUTES.compareTo(m) >= 0 && (d != 90 || new BigDecimal("0.000").compareTo(m) == 0);
        }
        return false;
    }

    public static boolean validateLongitude(String longitude) {
        AssertTools.assertNotEmpty(longitude);
        Matcher matcher = LONGITUDE_PATTERN.matcher(longitude);
        if (matcher.lookingAt()) {
            int d = Integer.valueOf(matcher.group(1).trim());
            BigDecimal m = NumberTools.parseBigDecimal(matcher.group(2) + '.' + matcher.group(3), Locale.ENGLISH, MINUTES_DECIMAL_LENGTH, 3);
            return d >= 0 && d <= 180 && LONGITUDE_MIN_MINUTES.compareTo(m) <= 0 && LATITUDE_MAX_MINUTES.compareTo(m) >= 0 && (d != 180 || new BigDecimal("0.000").compareTo(m) == 0);
        }
        return false;
    }

    private CoordTools() {
    }

    static {
        int i;
        char o;
        int i$;
        int i2;
        LATITUDE_MAX_MINUTES = new BigDecimal("59.999");
        LATITUDE_MIN_MINUTES = new BigDecimal("00.000");
        LATITUDE_ORIENTATIONS = new Character[]{Character.valueOf('N'), Character.valueOf('S')};
        LONGITUDE_MAX_MINUTES = new BigDecimal("59.999");
        LONGITUDE_MIN_MINUTES = new BigDecimal("00.000");
        LONGITUDE_ORIENTATIONS = new Character[]{Character.valueOf('E'), Character.valueOf('W')};
        String[] md = "59.999".split(MINUTES_SEPARATOR_PATTERN);
        MINUTES_INTEGER_LENGTH = md[0].length();
        MINUTES_DECIMAL_LENGTH = md[1].length();
        String patternMinutes = "[0-9]";
        String patternDegrees = "[ 0-9]";
        StringBuilder pattern = new StringBuilder("^(");
        for (i2 = 0; i2 < String.valueOf(90).length(); ++i2) {
            pattern.append(patternDegrees);
        }
        pattern.append(')');
        pattern.append('\u00b0');
        pattern.append('(');
        for (i2 = 0; i2 < MINUTES_INTEGER_LENGTH; ++i2) {
            pattern.append(patternMinutes);
        }
        pattern.append(")");
        pattern.append(MINUTES_SEPARATOR_PATTERN);
        pattern.append('(');
        for (i2 = 0; i2 < MINUTES_DECIMAL_LENGTH; ++i2) {
            pattern.append(patternMinutes);
        }
        pattern.append(')');
        pattern.append('\'');
        pattern.append("([");
        Character[] arr$ = LATITUDE_ORIENTATIONS;
        int len$ = arr$.length;
        for (i$ = 0; i$ < len$; ++i$) {
            o = arr$[i$].charValue();
            pattern.append(o);
        }
        pattern.append("])$");
        LATITUDE_PATTERN = Pattern.compile(pattern.toString());
        pattern = new StringBuilder("^(");
        for (i = 0; i < String.valueOf(180).length(); ++i) {
            pattern.append(patternDegrees);
        }
        pattern.append(')');
        pattern.append('\u00b0');
        pattern.append('(');
        for (i = 0; i < MINUTES_INTEGER_LENGTH; ++i) {
            pattern.append(patternMinutes);
        }
        pattern.append(")");
        pattern.append(MINUTES_SEPARATOR_PATTERN);
        pattern.append('(');
        for (i = 0; i < MINUTES_DECIMAL_LENGTH; ++i) {
            pattern.append(patternMinutes);
        }
        pattern.append(')');
        pattern.append('\'');
        pattern.append("([");
        arr$ = LONGITUDE_ORIENTATIONS;
        len$ = arr$.length;
        for (i$ = 0; i$ < len$; ++i$) {
            o = arr$[i$].charValue();
            pattern.append(o);
        }
        pattern.append("])$");
        LONGITUDE_PATTERN = Pattern.compile(pattern.toString());
    }
}

