/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import nc.ird.cantharella.utils.AssertTools;
import nc.ird.cantharella.utils.BeanTools;
import org.apache.commons.lang3.ObjectUtils;

public final class CollectionTools {
    public static <T> boolean containsOnlySameValue(Collection<T> collection, T value) {
        AssertTools.assertNotNull(collection);
        if (collection.isEmpty()) {
            return false;
        }
        boolean hasSame = true;
        Iterator<T> itCol = collection.iterator();
        while (hasSame && itCol.hasNext()) {
            T curVal = itCol.next();
            if (ObjectUtils.equals(curVal, value)) continue;
            hasSame = false;
        }
        return hasSame;
    }

    public static <T> Set<T> intersect(Set<T> s1, Set<T> s2) {
        HashSet intersect = s1 == null ? new HashSet() : new HashSet<T>(s1);
        intersect.retainAll(s2);
        return intersect;
    }

    public static <T> void setter(Collection<T> collectionToWrite, Collection<T> collectionToRead) {
        AssertTools.assertNotNull(collectionToWrite);
        collectionToWrite.clear();
        if (collectionToRead != null) {
            collectionToWrite.addAll(collectionToRead);
        }
    }

    public static boolean containsWithValue(Collection<? extends Object> collection, String pathToProperty, BeanTools.AccessType accessType, Object value) {
        AssertTools.assertNotNull(collection);
        AssertTools.assertNotEmpty(pathToProperty);
        for (Object object : collection) {
            Object curVal = BeanTools.getValueFromPath(object, accessType, pathToProperty);
            if (!curVal.equals(value)) continue;
            return true;
        }
        return false;
    }

    public static int countWithValue(Collection<? extends Object> collection, String pathToProperty, BeanTools.AccessType accessType, Object value) {
        AssertTools.assertNotNull(collection);
        AssertTools.assertNotEmpty(pathToProperty);
        int count = 0;
        for (Object object : collection) {
            Object curVal = BeanTools.getValueFromPath(object, accessType, pathToProperty);
            if (!value.equals(curVal)) continue;
            ++count;
        }
        return count;
    }

    public static <T> T findWithValue(List<T> collection, String pathToProperty, BeanTools.AccessType accessType, Object value) {
        AssertTools.assertNotNull(collection);
        AssertTools.assertNotEmpty(pathToProperty);
        for (T curBean : collection) {
            Object curVal = BeanTools.getValueFromPath(curBean, accessType, pathToProperty);
            if (!value.equals(curVal)) continue;
            return curBean;
        }
        return null;
    }

    public static boolean removeWithValue(Collection<? extends Object> collection, String pathToProperty, BeanTools.AccessType accessType, Object value) {
        AssertTools.assertNotNull(collection);
        AssertTools.assertNotEmpty(pathToProperty);
        boolean hasDeleted = false;
        Iterator<? extends Object> itList = collection.iterator();
        while (itList.hasNext()) {
            Object curBean = itList.next();
            Object curVal = BeanTools.getValueFromPath(curBean, accessType, pathToProperty);
            if (!value.equals(curVal)) continue;
            itList.remove();
            hasDeleted = true;
        }
        return hasDeleted;
    }

    public static boolean removeAllWithValue(Collection<? extends Object> collection, String pathToProperty, BeanTools.AccessType accessType, Collection<? extends Object> values) {
        AssertTools.assertNotNull(collection);
        AssertTools.assertNotEmpty(pathToProperty);
        boolean hasDeleted = false;
        Iterator<? extends Object> itList = collection.iterator();
        while (itList.hasNext()) {
            Object curBean = itList.next();
            Object curVal = BeanTools.getValueFromPath(curBean, accessType, pathToProperty);
            if (curVal == null || !values.contains(curVal)) continue;
            itList.remove();
            hasDeleted = true;
        }
        return hasDeleted;
    }

    public static List<Object> valuesFromList(Collection<? extends Object> collection, String pathToProperty, BeanTools.AccessType accessType) {
        AssertTools.assertNotNull(collection);
        AssertTools.assertNotEmpty(pathToProperty);
        ArrayList<Object> values = new ArrayList<Object>();
        for (Object object : collection) {
            Object curVal = BeanTools.getValueFromPath(object, accessType, pathToProperty);
            values.add(curVal);
        }
        return values;
    }

    private CollectionTools() {
    }
}

