/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.utils;

import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nc.ird.cantharella.utils.AssertTools;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;

public final class BeanTools {
    private static final String ANNOTATION = "Argument of type %s must have a field annotated with %s";
    private static final String FIELD = "Argument of type %s must have an accessible %s property";

    public static boolean equals(Object thiz, Object obj, AccessType accessType, String ... properties) {
        AssertTools.assertNotNull(thiz);
        AssertTools.assertNotEmpty(properties);
        AssertTools.assertArrayNotNull(properties);
        if (thiz == obj) {
            return true;
        }
        if (obj != null && thiz != null && (thiz.getClass().isAssignableFrom(obj.getClass()) || obj.getClass().isAssignableFrom(thiz.getClass()))) {
            EqualsBuilder builder = new EqualsBuilder();
            for (String property : properties) {
                try {
                    Object val1 = BeanTools.getValue(thiz, accessType, property);
                    Object val2 = BeanTools.getValue(obj, accessType, property);
                    if (val1 != null && val2 != null && !builder.append(val1.hashCode(), val2.hashCode()).isEquals()) {
                        return false;
                    }
                    if (builder.append(val1, val2).isEquals()) continue;
                    return false;
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(String.format(FIELD, thiz.getClass(), property), e);
                }
            }
            return builder.isEquals();
        }
        return false;
    }

    public static boolean equals(Object thiz, Object obj, Field ... fields) {
        AssertTools.assertNotNull(thiz);
        AssertTools.assertNotEmpty(fields);
        AssertTools.assertArrayNotNull(fields);
        if (thiz == obj) {
            return true;
        }
        if (obj != null && thiz != null && (thiz.getClass().isAssignableFrom(obj.getClass()) || obj.getClass().isAssignableFrom(thiz.getClass()))) {
            EqualsBuilder builder = new EqualsBuilder();
            for (Field field : fields) {
                try {
                    Object val1 = field.get(thiz);
                    Object val2 = field.get(obj);
                    if (val1 != null && val2 != null && !builder.append(val1.hashCode(), val2.hashCode()).isEquals()) {
                        return false;
                    }
                    if (builder.append(val1, val2).isEquals()) continue;
                    return false;
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(String.format(FIELD, thiz.getClass(), field.getName()), e);
                }
            }
            return builder.isEquals();
        }
        return false;
    }

    @SafeVarargs
    public static Field getAnnotatedPublicField(Object thiz, Class<? extends Annotation> ... annotations) throws NoSuchFieldException {
        AssertTools.assertNotNull(thiz);
        return BeanTools.getAnnotatedPublicField(thiz.getClass(), annotations);
    }

    @SafeVarargs
    public static Field getAnnotatedPrivateField(Class<?> clazz, Class<? extends Annotation> ... annotations) throws NoSuchFieldException {
        AssertTools.assertNotNull(clazz);
        AssertTools.assertNotEmpty(annotations);
        AssertTools.assertArrayNotNull(annotations);
        Field[] fields = clazz.getDeclaredFields();
        Field field = null;
        for (int i = 0; field == null && i < fields.length; ++i) {
            for (int j = 0; field == null && j < annotations.length; ++j) {
                if (!fields[i].isAnnotationPresent(annotations[j])) continue;
                field = fields[i];
            }
        }
        if (field == null) {
            if (clazz.getSuperclass() == null) {
                throw new NoSuchFieldException(String.format(ANNOTATION, clazz.getName(), Arrays.toString(annotations)));
            }
            return BeanTools.getAnnotatedInheritedField(clazz, clazz.getSuperclass(), annotations);
        }
        return field;
    }

    @SafeVarargs
    private static Field getAnnotatedInheritedField(Class<?> baseClazz, Class<?> browsedClazz, Class<? extends Annotation> ... annotations) throws NoSuchFieldException {
        AssertTools.assertNotNull(baseClazz);
        AssertTools.assertNotEmpty(annotations);
        AssertTools.assertArrayNotNull(annotations);
        Field[] fields = browsedClazz.getDeclaredFields();
        Field field = null;
        for (int i = 0; field == null && i < fields.length; ++i) {
            for (int j = 0; field == null && j < annotations.length; ++j) {
                if (!fields[i].isAnnotationPresent(annotations[j]) || !Modifier.isProtected(fields[i].getModifiers()) && !Modifier.isPublic(fields[i].getModifiers()) && !Modifier.isPrivate(fields[i].getModifiers())) continue;
                field = fields[i];
            }
        }
        if (field == null) {
            if (browsedClazz.getSuperclass() == null) {
                throw new NoSuchFieldException(String.format(ANNOTATION, baseClazz.getName(), Arrays.toString(annotations)));
            }
            BeanTools.getAnnotatedInheritedField(baseClazz, browsedClazz.getSuperclass(), annotations);
        }
        return field;
    }

    @SafeVarargs
    public static Field getAnnotatedPublicField(Class<?> clazz, Class<? extends Annotation> ... annotations) throws NoSuchFieldException {
        AssertTools.assertNotNull(clazz);
        AssertTools.assertNotEmpty(annotations);
        AssertTools.assertArrayNotNull(annotations);
        Field[] fields = clazz.getFields();
        Field field = null;
        for (int i = 0; field == null && i < fields.length; ++i) {
            for (int j = 0; field == null && j < annotations.length; ++j) {
                if (!fields[i].isAnnotationPresent(annotations[j])) continue;
                field = fields[i];
            }
        }
        if (field == null) {
            throw new NoSuchFieldException(String.format(ANNOTATION, clazz.getName(), Arrays.toString(annotations)));
        }
        return field;
    }

    public static <A extends Annotation> A getAnnotationOnProperty(Class<?> beanClass, Class<A> annotation, String property) throws NoSuchFieldException {
        AssertTools.assertNotNull(beanClass);
        AssertTools.assertNotNull(annotation);
        return beanClass.getField(property).getAnnotation(annotation);
    }

    public static Object getValue(Object bean, AccessType accessType, String property) {
        Object value;
        AssertTools.assertNotNull(bean);
        AssertTools.assertNotNull((Object)accessType);
        AssertTools.assertNotEmpty(property);
        switch (accessType) {
            case GETTER: {
                try {
                    PropertyDescriptor prodDesc = new PropertyDescriptor(property, bean.getClass(), "is" + StringUtils.capitalize((String)property), null);
                    Method method = prodDesc.getReadMethod();
                    value = method.invoke(bean, new Object[0]);
                    break;
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(e);
                }
            }
            case FIELD: {
                try {
                    value = bean.getClass().getField(property).get(bean);
                    break;
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(e);
                }
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return value;
    }

    public static Object getValueFromPath(Object bean, AccessType accessType, String pathToProperty) {
        AssertTools.assertNotNull(bean);
        AssertTools.assertNotNull((Object)accessType);
        AssertTools.assertNotEmpty(pathToProperty);
        List<String> beanNames = BeanTools.createAccessBeanList(pathToProperty);
        Object curBean = bean;
        for (String beanName : beanNames) {
            if (curBean == null) continue;
            curBean = BeanTools.getValue(curBean, AccessType.GETTER, beanName);
        }
        return curBean;
    }

    private static List<String> createAccessBeanList(String propertiesPath) {
        Matcher matcher = Pattern.compile("\\w+").matcher(propertiesPath);
        ArrayList<String> paramList = new ArrayList<String>();
        while (matcher.find()) {
            paramList.add(propertiesPath.substring(matcher.start(), matcher.end()));
        }
        return paramList;
    }

    public static int hashCode(Object thiz, Field ... fields) {
        int seed;
        AssertTools.assertNotNull(thiz);
        AssertTools.assertNotEmpty(fields);
        AssertTools.assertArrayNotNull(fields);
        int hashCode = seed = thiz.getClass().hashCode();
        for (Field field : fields) {
            Object value;
            try {
                value = field.get(thiz);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IllegalArgumentException(String.format(FIELD, thiz.getClass(), field.getName()), e);
            }
            hashCode += value != null ? seed ^ value.hashCode() : 0;
        }
        return hashCode;
    }

    public static int hashCode(Object thiz, Object ... ids) {
        int seed;
        AssertTools.assertNotNull(thiz);
        AssertTools.assertNotEmpty(ids);
        AssertTools.assertNotNull(ids);
        int hashCode = seed = thiz.getClass().hashCode();
        for (Object id : ids) {
            hashCode += id != null ? seed ^ id.hashCode() : 0;
        }
        return hashCode;
    }

    public static <A extends Annotation> boolean isAnnotationOnProperty(Class<?> beanClass, Class<A> annotation, String property) throws NoSuchFieldException {
        return BeanTools.getAnnotationOnProperty(beanClass, annotation, property) != null;
    }

    public static String toString(Object bean, String delimiter, AccessType accessType, String ... pathsToProperties) {
        AssertTools.assertNotNull(bean);
        AssertTools.assertNotEmpty(delimiter);
        AssertTools.assertArrayNotNull(pathsToProperties);
        Class<?> clazz = bean.getClass();
        StringBuilder builder = new StringBuilder(clazz.getName());
        for (String pathToProperty : pathsToProperties) {
            try {
                Object value = BeanTools.getValueFromPath(bean, accessType, pathToProperty);
                builder.append(delimiter + pathToProperty + ": " + (value != null ? value.toString() : "<null>"));
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IllegalArgumentException(String.format(FIELD, clazz, pathToProperty), e);
            }
        }
        return builder.toString();
    }

    public static String toString(Object bean, AccessType accessType, String ... properties) {
        return BeanTools.toString(bean, "\n- ", accessType, properties);
    }

    private BeanTools() {
    }

    public static String beanListToString(List<? extends Object> beansList, AccessType accessType, String ... pathsToProperties) {
        return BeanTools.beanListToString(beansList, "\n", ", ", accessType, pathsToProperties);
    }

    public static String beanListToString(List<? extends Object> beansList, String delimiterBeans, String delimiterProperties, AccessType accessType, String ... pathsToProperties) {
        AssertTools.assertNotNull(beansList);
        AssertTools.assertNotEmpty(delimiterProperties);
        AssertTools.assertNotEmpty(delimiterBeans);
        AssertTools.assertNotNull((Object)accessType);
        StringBuilder builder = new StringBuilder();
        Iterator<? extends Object> itBeans = beansList.iterator();
        while (itBeans.hasNext()) {
            Object bean = itBeans.next();
            builder.append(BeanTools.toString(bean, delimiterProperties, accessType, pathsToProperties));
            if (!itBeans.hasNext()) continue;
            builder.append(delimiterBeans);
        }
        return builder.toString();
    }

    public static <T> Comparator<T> createPropertyComparator(String propertyExpression) {
        return new BeanComparator(propertyExpression);
    }

    public static <T> Comparator<T> createPropertyComparator(String propertyExpression, Comparator<T> comparator) {
        return new BeanComparator(propertyExpression, comparator);
    }

    public static enum AccessType {
        FIELD,
        GETTER;

    }
}

