/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.utils;

import java.util.Arrays;
import java.util.Collection;

public final class AssertTools {
    private static final String CLASS = "Argument must be of type %s";
    private static final String EQUALS = "Argument must be equals to %s";
    private static final String GREATER = "Argument must be greater than %s";
    private static final String GREATER_OR_EQUALS = "Argument must be greater than or equals to %s";
    private static final String IN = "Argument must be in %s";
    private static final String LOWER = "Argument must be lower than %s";
    private static final String LOWER_OR_EQUALS = "Argument must be lower than or equals to %s";
    private static final String NOT_EMPTY = "Argument must not be empty";
    private static final String NOT_EQUALS = "Argument must not be equals to %s";
    private static final String NOT_NULL = "Argument must not be null";

    public static void assertArrayNotEmpty(String[] strings) {
        AssertTools.assertNotNull(strings);
        for (String string : strings) {
            AssertTools.assertNotEmpty(string);
        }
    }

    public static void assertArrayNotNull(Object[] objects) {
        AssertTools.assertNotNull(objects);
        for (Object object : objects) {
            AssertTools.assertNotNull(object);
        }
    }

    public static void assertClassOrInterface(Object object, Class<?> clazz) {
        AssertTools.assertNotNull(object);
        AssertTools.assertNotNull(clazz);
        assert (clazz.isAssignableFrom(object.getClass())) : String.format("Argument must be of type %s", clazz.getName());
    }

    public static void assertCollectionNotNull(Collection<?> objects) {
        AssertTools.assertNotNull(objects);
        for (Object object : objects) {
            AssertTools.assertNotNull(object);
        }
    }

    public static <N extends Number> void assertEquals(N value, N expectedValue) {
        assert (value.doubleValue() == expectedValue.doubleValue()) : String.format("Argument must be equals to %s", expectedValue);
    }

    public static <N extends Number> void assertGreater(N value, N bound) {
        assert (value.doubleValue() > bound.doubleValue()) : String.format("Argument must be greater than %s", bound);
    }

    public static <N extends Number> void assertGreaterOrEquals(N value, N bound) {
        assert (value.doubleValue() >= bound.doubleValue()) : String.format("Argument must be greater than or equals to %s", bound);
    }

    public static <O> void assertIn(O object, Collection<O> values) {
        AssertTools.assertNotNull(object);
        AssertTools.assertNotEmpty(values);
        assert (values.contains(object)) : String.format("Argument must be in %s", object);
    }

    @SafeVarargs
    public static <O> void assertIn(O object, O ... values) {
        AssertTools.assertNotEmpty(values);
        AssertTools.assertIn(object, Arrays.asList(values));
    }

    public static <N extends Number> void assertLower(N value, N bound) {
        assert (value.doubleValue() < bound.doubleValue()) : String.format("Argument must be lower than %s", bound);
    }

    public static <N extends Number> void assertLowerOrEquals(N value, N bound) {
        assert (value.doubleValue() <= bound.doubleValue()) : String.format("Argument must be lower than or equals to %s", bound);
    }

    public static void assertNotEmpty(Collection<?> collection) {
        AssertTools.assertNotNull(collection);
        assert (!collection.isEmpty()) : "Argument must not be empty";
    }

    public static void assertNotEmpty(Object[] array) {
        AssertTools.assertNotNull(array);
        assert (array.length > 0) : "Argument must not be empty";
    }

    public static void assertNotEmpty(String string) {
        AssertTools.assertNotNull(string);
        assert (!string.isEmpty()) : "Argument must not be empty";
    }

    public static <N extends Number> void assertNotEquals(N value, N unexpectedValue) {
        assert (value.doubleValue() != unexpectedValue.doubleValue()) : String.format("Argument must not be equals to %s", unexpectedValue);
    }

    public static <N extends Number> void assertNotNegative(N value) {
        AssertTools.assertGreaterOrEquals(value, 0);
    }

    public static void assertNotNull(Object object) {
        assert (object != null) : "Argument must not be null";
    }

    public static <N extends Number> void assertPositive(N value) {
        AssertTools.assertGreater(value, 0);
    }

    private AssertTools() {
    }
}

