/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.data.validation.utils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.validation.ConstraintViolation;
import javax.validation.MessageInterpolator;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.metadata.ConstraintDescriptor;
import nc.ird.cantharella.data.model.utils.AbstractModel;
import nc.ird.cantharella.data.validation.utils.ModelValidator;
import nc.ird.cantharella.utils.AssertTools;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.NoSuchMessageException;
import org.springframework.context.support.MessageSourceAccessor;

public final class ModelValidatorImpl
implements ModelValidator {
    private static final Logger LOG = LoggerFactory.getLogger(ModelValidatorImpl.class);
    private static final String PATTERN_ERROR_MESSAGE = "%s - %s";
    private static final String PATTERN_ERROR_PROPERTY = "%s.%s";
    private final MessageInterpolator messageInterpolator;
    private MessageSourceAccessor[] messageSources;
    private final Validator validator;

    public ModelValidatorImpl(ValidatorFactory validatorFactory, MessageSourceAccessor ... messageSourceAccessor) {
        AssertTools.assertNotNull((Object)validatorFactory);
        this.messageInterpolator = validatorFactory.getMessageInterpolator();
        this.validator = validatorFactory.getValidator();
        this.messageSources = messageSourceAccessor;
    }

    @Override
    public <M extends AbstractModel> void debug(Class<M> modelClass, M model) {
        if (LOG.isDebugEnabled()) {
            for (ConstraintViolation violation : this.validator.validate(model, new Class[0])) {
                LOG.debug(violation.getMessage());
            }
        }
    }

    @Override
    public <M> List<String> validate(M model, Locale locale, String ... properties) {
        Set<ConstraintViolation<M>> violations = this.validate(model, properties);
        ArrayList<String> violationMessages = new ArrayList<String>(violations.size());
        for (final ConstraintViolation<M> violation : violations) {
            Class clazz = violation.getRootBeanClass();
            String label = null;
            String labelDefault = StringUtils.isEmpty((CharSequence)violation.getPropertyPath().toString()) ? this.getMessage(clazz.getSimpleName(), locale) : String.format(PATTERN_ERROR_PROPERTY, clazz.getSimpleName(), violation.getPropertyPath());
            try {
                label = this.getMessage(labelDefault, locale);
            }
            catch (NoSuchMessageException e) {
                // empty catch block
            }
            while (label == null && !Object.class.equals((Object)clazz)) {
                clazz = clazz.getSuperclass();
                try {
                    if (StringUtils.isEmpty((CharSequence)violation.getPropertyPath().toString())) {
                        this.getMessage(clazz.getSimpleName(), locale);
                        continue;
                    }
                    this.getMessage(String.format(PATTERN_ERROR_PROPERTY, clazz.getSimpleName(), violation.getPropertyPath()), locale);
                }
                catch (NoSuchMessageException e) {}
            }
            if (label == null) {
                label = labelDefault;
            }
            violationMessages.add(String.format(PATTERN_ERROR_MESSAGE, label, this.messageInterpolator.interpolate(violation.getMessageTemplate(), new MessageInterpolator.Context(){

                public ConstraintDescriptor<?> getConstraintDescriptor() {
                    return violation.getConstraintDescriptor();
                }

                public Object getValidatedValue() {
                    return violation.getInvalidValue();
                }

                public <T> T unwrap(Class<T> type) {
                    if (type.isAssignableFrom(MessageInterpolator.Context.class)) {
                        return type.cast(this);
                    }
                    throw new ClassCastException();
                }
            }, locale)));
        }
        return violationMessages;
    }

    private <M> Set<ConstraintViolation<M>> validate(M model, String ... properties) {
        if (properties == null || properties.length == 0) {
            return this.validator.validate(model, new Class[0]);
        }
        HashSet<ConstraintViolation<M>> violations = new HashSet<ConstraintViolation<M>>();
        for (String property : properties) {
            violations.addAll(this.validator.validateProperty(model, property, new Class[0]));
        }
        return violations;
    }

    private String getMessage(String key, Locale locale) {
        String msg = null;
        for (int i = 0; msg == null && i < this.messageSources.length; ++i) {
            MessageSourceAccessor curMsgSource = this.messageSources[i];
            msg = curMsgSource.getMessage(key, null, null, locale);
        }
        return msg;
    }
}

