/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.data.validation;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import nc.ird.cantharella.data.validation.QueryConstraint;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.factory.annotation.Autowired;

public class QueryConstraintValidator
implements ConstraintValidator<QueryConstraint, String> {
    private static final Logger LOG = LoggerFactory.getLogger(QueryConstraintValidator.class);
    private String hql;
    private String[] params;
    @Autowired
    private SessionFactory sessionFactory;

    public void initialize(QueryConstraint queryConstraint) {
        this.hql = queryConstraint.hql();
        this.params = this.createParameterList(this.hql);
    }

    public boolean isValid(String domainObject, ConstraintValidatorContext context) {
        BeanWrapperImpl beanWrapper = new BeanWrapperImpl((Object)domainObject);
        if (this.sessionFactory != null) {
            LOG.debug("Enabled - Validating constraint with: ");
            LOG.debug(this.hql);
            Session session = this.sessionFactory.openSession();
            Transaction tx = session.beginTransaction();
            Query query = session.createQuery(this.hql);
            for (String parameterName : this.params) {
                query.setParameter(parameterName, beanWrapper.getPropertyValue(parameterName));
            }
            boolean result = (Long)query.uniqueResult() == 0L;
            tx.commit();
            session.close();
            return result;
        }
        return true;
    }

    private String[] createParameterList(String query) {
        Matcher matcher = Pattern.compile(":[^\\s]*").matcher(query);
        ArrayList<String> paramList = new ArrayList<String>();
        while (matcher.find()) {
            paramList.add(this.hql.substring(matcher.start() + 1, matcher.end()));
        }
        return paramList.toArray(new String[paramList.size()]);
    }
}

