/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.data.validation;

import java.io.Serializable;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import nc.ird.cantharella.data.dao.GenericDao;
import nc.ird.cantharella.data.exceptions.DataNotFoundException;
import nc.ird.cantharella.data.model.utils.AbstractModel;
import nc.ird.cantharella.data.validation.DbUniqueField;
import nc.ird.cantharella.utils.AssertTools;
import nc.ird.cantharella.utils.BeanTools;
import org.springframework.beans.factory.annotation.Autowired;

public final class DbUniqueFieldValidator
implements ConstraintValidator<DbUniqueField, Object> {
    String fieldName;
    Class<? extends AbstractModel> entity;
    @Autowired
    private GenericDao dao;

    public void initialize(DbUniqueField annotation) {
        this.fieldName = annotation.fieldName();
        this.entity = annotation.entity();
    }

    public boolean isValid(Object value, ConstraintValidatorContext constraintContext) {
        AbstractModel modelWithSameVal;
        AssertTools.assertNotNull((Object)value);
        Serializable fieldVal = (Serializable)BeanTools.getValue((Object)value, (BeanTools.AccessType)BeanTools.AccessType.GETTER, (String)this.fieldName);
        if (fieldVal == null) {
            return false;
        }
        if (!this.dao.exists(this.entity, this.fieldName, fieldVal)) {
            return true;
        }
        AbstractModel modelForm = (AbstractModel)value;
        try {
            modelWithSameVal = this.dao.read(this.entity, this.fieldName, fieldVal);
        }
        catch (DataNotFoundException e) {
            return true;
        }
        return modelForm.getIdValue().equals(modelWithSameVal.getIdValue());
    }
}

