/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.data.model;

import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.validation.constraints.NotNull;
import nc.ird.cantharella.data.model.MethodeExtraction;
import nc.ird.cantharella.data.model.utils.AbstractModel;
import nc.ird.cantharella.data.validation.CollectionUniqueField;
import org.apache.commons.beanutils.BeanComparator;
import org.hibernate.annotations.Type;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotEmpty;

@Entity
@CollectionUniqueField(fieldName="initiales", pathToCollection="methodeExtraction.typesEnSortie")
public class TypeExtrait
extends AbstractModel
implements Cloneable,
Comparable<TypeExtrait> {
    @Id
    @GeneratedValue
    private Integer idTypeExtrait;
    @Length(max=10)
    @NotEmpty
    private String initiales;
    @NotEmpty
    @Lob
    @Type(type="org.hibernate.type.StringClobType")
    private String description;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, optional=false)
    private MethodeExtraction methodeExtraction;

    public TypeExtrait clone() throws CloneNotSupportedException {
        TypeExtrait clone = (TypeExtrait)super.clone();
        clone.idTypeExtrait = this.idTypeExtrait;
        clone.initiales = this.initiales;
        clone.description = this.description;
        clone.methodeExtraction = this.methodeExtraction;
        return clone;
    }

    public String toString() {
        return this.initiales;
    }

    @Override
    public int compareTo(TypeExtrait typeExtrait) {
        return new BeanComparator("initiales").compare((Object)this, (Object)typeExtrait);
    }

    public Integer getIdTypeExtrait() {
        return this.idTypeExtrait;
    }

    public void setIdTypeExtrait(Integer idTypeExtrait) {
        this.idTypeExtrait = idTypeExtrait;
    }

    public String getInitiales() {
        return this.initiales;
    }

    public void setInitiales(String initiales) {
        this.initiales = initiales;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public MethodeExtraction getMethodeExtraction() {
        return this.methodeExtraction;
    }

    public void setMethodeExtraction(MethodeExtraction methodeExtraction) {
        this.methodeExtraction = methodeExtraction;
    }
}

