/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.data.model;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.Future;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import nc.ird.cantharella.data.model.Document;
import nc.ird.cantharella.data.model.MethodeTestBio;
import nc.ird.cantharella.data.model.Personne;
import nc.ird.cantharella.data.model.ResultatTestBio;
import nc.ird.cantharella.data.model.comparators.ResultatsOfTestBioComp;
import nc.ird.cantharella.data.model.utils.AbstractModel;
import nc.ird.cantharella.data.model.utils.DocumentAttachable;
import org.apache.commons.beanutils.BeanComparator;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.Type;
import org.hibernate.search.annotations.ContainedIn;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.IndexedEmbedded;
import org.hibernate.search.annotations.Store;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotEmpty;

@Entity
@Embeddable
public class TestBio
extends AbstractModel
implements Comparable<TestBio>,
DocumentAttachable {
    @Id
    @GeneratedValue
    private Integer idTestBio;
    @Length(max=60)
    @Column(unique=true)
    @NotEmpty
    @Field(store=Store.YES)
    private String ref;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, optional=false)
    private Personne manipulateur;
    @NotNull
    @Length(max=60)
    private String organismeTesteur;
    @NotNull
    @Temporal(value=TemporalType.DATE)
    private Date date;
    @NotNull
    @ManyToOne(fetch=FetchType.EAGER, optional=false)
    @IndexedEmbedded
    private MethodeTestBio methode;
    @Min(value=0L)
    @Max(value=99999L)
    @Column(precision=9, scale=4)
    private BigDecimal concMasseDefaut;
    @Enumerated(value=EnumType.ORDINAL)
    private ResultatTestBio.UniteConcMasse uniteConcMasseDefaut;
    private ResultatTestBio.Stade stadeDefaut;
    @Lob
    @Type(type="org.hibernate.type.StringClobType")
    private String complement;
    private boolean confidentiel;
    @Future
    @Temporal(value=TemporalType.DATE)
    private Date dateConfidentialite;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, optional=false)
    private Personne createur;
    @NotNull
    @OneToMany(mappedBy="testBio", fetch=FetchType.LAZY, orphanRemoval=true)
    @Cascade(value={CascadeType.SAVE_UPDATE})
    @ContainedIn
    private List<ResultatTestBio> resultats = new ArrayList<ResultatTestBio>();
    @OneToMany(fetch=FetchType.EAGER, orphanRemoval=true)
    @JoinColumn(name="resultatTestBio")
    @Cascade(value={CascadeType.SAVE_UPDATE})
    @Fetch(value=FetchMode.SUBSELECT)
    private List<Document> documents = new ArrayList<Document>();

    public String toString() {
        return this.ref;
    }

    @Override
    public int compareTo(TestBio testBio) {
        return new BeanComparator("ref").compare((Object)this, (Object)testBio);
    }

    public List<ResultatTestBio> getSortedResultats() {
        Collections.sort(this.resultats, new ResultatsOfTestBioComp());
        return this.resultats;
    }

    public Integer getIdTestBio() {
        return this.idTestBio;
    }

    public void setIdTestBio(Integer idTestBio) {
        this.idTestBio = idTestBio;
    }

    public String getRef() {
        return this.ref;
    }

    public void setRef(String ref) {
        this.ref = ref;
    }

    public Personne getManipulateur() {
        return this.manipulateur;
    }

    public void setManipulateur(Personne manipulateur) {
        this.manipulateur = manipulateur;
    }

    public String getOrganismeTesteur() {
        return this.organismeTesteur;
    }

    public void setOrganismeTesteur(String organismeTesteur) {
        this.organismeTesteur = organismeTesteur;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public MethodeTestBio getMethode() {
        return this.methode;
    }

    public void setMethode(MethodeTestBio methode) {
        this.methode = methode;
    }

    public BigDecimal getConcMasseDefaut() {
        return this.concMasseDefaut;
    }

    public void setConcMasseDefaut(BigDecimal concMasseDefaut) {
        this.concMasseDefaut = concMasseDefaut;
    }

    public ResultatTestBio.UniteConcMasse getUniteConcMasseDefaut() {
        return this.uniteConcMasseDefaut;
    }

    public void setUniteConcMasseDefaut(ResultatTestBio.UniteConcMasse uniteConcMasseDefaut) {
        this.uniteConcMasseDefaut = uniteConcMasseDefaut;
    }

    public ResultatTestBio.Stade getStadeDefaut() {
        return this.stadeDefaut;
    }

    public void setStadeDefaut(ResultatTestBio.Stade stadeDefaut) {
        this.stadeDefaut = stadeDefaut;
    }

    public String getComplement() {
        return this.complement;
    }

    public void setComplement(String complement) {
        this.complement = complement;
    }

    public boolean isConfidentiel() {
        return this.confidentiel;
    }

    public void setConfidentiel(boolean confidentiel) {
        this.confidentiel = confidentiel;
    }

    public Date getDateConfidentialite() {
        return this.dateConfidentialite;
    }

    public void setDateConfidentialite(Date dateConfidentialite) {
        this.dateConfidentialite = dateConfidentialite;
    }

    public Personne getCreateur() {
        return this.createur;
    }

    public void setCreateur(Personne createur) {
        this.createur = createur;
    }

    public List<ResultatTestBio> getResultats() {
        return this.resultats;
    }

    public void setResultats(List<ResultatTestBio> resultats) {
        this.resultats = resultats;
    }

    @Override
    public List<Document> getDocuments() {
        return this.documents;
    }

    public void setDocuments(List<Document> documents) {
        this.documents = documents;
    }

    @Override
    public void addDocument(Document document) {
        this.documents.add(document);
    }

    @Override
    public void removeDocument(Document document) {
        this.documents.remove(document);
    }
}

