/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.data.model;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.MapKey;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import javax.validation.constraints.NotNull;
import nc.ird.cantharella.data.model.Campagne;
import nc.ird.cantharella.data.model.CampagnePersonneDroits;
import nc.ird.cantharella.data.model.CampagnePersonneParticipant;
import nc.ird.cantharella.data.model.Document;
import nc.ird.cantharella.data.model.Extraction;
import nc.ird.cantharella.data.model.Lot;
import nc.ird.cantharella.data.model.LotPersonneDroits;
import nc.ird.cantharella.data.model.Purification;
import nc.ird.cantharella.data.model.Specimen;
import nc.ird.cantharella.data.model.Station;
import nc.ird.cantharella.data.model.TestBio;
import nc.ird.cantharella.data.model.utils.AbstractModel;
import nc.ird.cantharella.data.model.utils.DocumentAttachable;
import nc.ird.cantharella.data.validation.CountryCode;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.collections.comparators.ComparatorChain;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Type;
import org.hibernate.validator.constraints.Email;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotEmpty;

@Entity
@Table(uniqueConstraints={@UniqueConstraint(columnNames={"nom", "prenom"})})
@Inheritance(strategy=InheritanceType.JOINED)
public class Personne
extends AbstractModel
implements Comparable<Personne>,
DocumentAttachable {
    @Id
    @GeneratedValue
    private Integer idPersonne;
    @NotEmpty
    @Lob
    @Type(type="org.hibernate.type.StringClobType")
    private String adressePostale;
    @OneToMany(mappedBy="createur", fetch=FetchType.LAZY)
    @NotNull
    private List<Campagne> campagnesCreees = new ArrayList<Campagne>();
    @NotNull
    @OneToMany(mappedBy="id.pk2", fetch=FetchType.LAZY, orphanRemoval=true)
    @MapKey(name="id.pk1")
    @Cascade(value={CascadeType.SAVE_UPDATE})
    private Map<Campagne, CampagnePersonneDroits> campagnesDroits;
    @OneToMany(mappedBy="id.pk2", fetch=FetchType.LAZY)
    @NotNull
    private List<CampagnePersonneParticipant> campagnesParticipees = new ArrayList<CampagnePersonneParticipant>();
    @NotEmpty
    @Length(min=2, max=2)
    @CountryCode
    private String codePays;
    @Length(max=10)
    @NotEmpty
    private String codePostal;
    @Column(unique=true)
    @Length(max=60)
    @Email
    @NotEmpty
    @Index(name="courriel")
    private String courriel;
    @Length(max=60)
    private String fax;
    @Length(max=60)
    private String fonction;
    @OneToMany(mappedBy="createur", fetch=FetchType.LAZY)
    @NotNull
    private List<Lot> lotsCrees;
    @NotNull
    @OneToMany(mappedBy="id.pk2", fetch=FetchType.LAZY, orphanRemoval=true)
    @MapKey(name="id.pk1")
    @Cascade(value={CascadeType.SAVE_UPDATE})
    private Map<Lot, LotPersonneDroits> lotsDroits;
    @Length(max=60)
    @NotEmpty
    private String nom;
    @Length(max=60)
    @NotEmpty
    private String organisme;
    @Length(max=60)
    @NotEmpty
    private String prenom;
    @Length(max=60)
    private String tel;
    @Length(max=60)
    @NotEmpty
    private String ville;
    @OneToMany(mappedBy="createur", fetch=FetchType.LAZY)
    @NotNull
    private List<Station> stationsCrees;
    @OneToMany(mappedBy="createur", fetch=FetchType.LAZY)
    @NotNull
    private List<Specimen> specimensCrees;
    @OneToMany(mappedBy="createur", fetch=FetchType.LAZY)
    @NotNull
    private List<Extraction> extractionsCrees;
    @OneToMany(mappedBy="createur", fetch=FetchType.LAZY)
    @NotNull
    private List<Purification> purificationsCrees;
    @OneToMany(mappedBy="createur", fetch=FetchType.LAZY)
    @NotNull
    private List<TestBio> testsBioCrees;
    @OneToMany(fetch=FetchType.EAGER, orphanRemoval=true)
    @JoinColumn(name="personne")
    @Cascade(value={CascadeType.SAVE_UPDATE})
    @Fetch(value=FetchMode.SUBSELECT)
    private List<Document> documents;

    public Personne() {
        this.campagnesDroits = new HashMap<Campagne, CampagnePersonneDroits>();
        this.lotsCrees = new ArrayList<Lot>();
        this.lotsDroits = new HashMap<Lot, LotPersonneDroits>();
        this.stationsCrees = new ArrayList<Station>();
        this.specimensCrees = new ArrayList<Specimen>();
        this.extractionsCrees = new ArrayList<Extraction>();
        this.purificationsCrees = new ArrayList<Purification>();
        this.testsBioCrees = new ArrayList<TestBio>();
        this.documents = new ArrayList<Document>();
    }

    public String toString() {
        return this.prenom + " " + this.nom;
    }

    @Override
    public int compareTo(Personne personne) {
        ComparatorChain comparatorChain = new ComparatorChain();
        comparatorChain.addComparator((Comparator)new BeanComparator("nom"));
        comparatorChain.addComparator((Comparator)new BeanComparator("prenom"));
        return comparatorChain.compare((Object)this, (Object)personne);
    }

    public Integer getIdPersonne() {
        return this.idPersonne;
    }

    public void setIdPersonne(Integer idPersonne) {
        this.idPersonne = idPersonne;
    }

    public String getAdressePostale() {
        return this.adressePostale;
    }

    public void setAdressePostale(String adressePostale) {
        this.adressePostale = adressePostale;
    }

    public List<Campagne> getCampagnesCreees() {
        return this.campagnesCreees;
    }

    public void setCampagnesCreees(List<Campagne> campagnesCreees) {
        this.campagnesCreees = campagnesCreees;
    }

    public Map<Campagne, CampagnePersonneDroits> getCampagnesDroits() {
        return this.campagnesDroits;
    }

    public void setCampagnesDroits(Map<Campagne, CampagnePersonneDroits> campagnesDroits) {
        this.campagnesDroits = campagnesDroits;
    }

    public List<CampagnePersonneParticipant> getCampagnesParticipees() {
        return this.campagnesParticipees;
    }

    public void setCampagnesParticipees(List<CampagnePersonneParticipant> campagnesParticipees) {
        this.campagnesParticipees = campagnesParticipees;
    }

    public String getCodePays() {
        return this.codePays;
    }

    public void setCodePays(String codePays) {
        this.codePays = codePays;
    }

    public String getCodePostal() {
        return this.codePostal;
    }

    public void setCodePostal(String codePostal) {
        this.codePostal = codePostal;
    }

    public String getCourriel() {
        return this.courriel;
    }

    public void setCourriel(String courriel) {
        this.courriel = courriel;
    }

    public String getFax() {
        return this.fax;
    }

    public void setFax(String fax) {
        this.fax = fax;
    }

    public String getFonction() {
        return this.fonction;
    }

    public void setFonction(String fonction) {
        this.fonction = fonction;
    }

    public List<Lot> getLotsCrees() {
        return this.lotsCrees;
    }

    public void setLotsCrees(List<Lot> lotsCrees) {
        this.lotsCrees = lotsCrees;
    }

    public Map<Lot, LotPersonneDroits> getLotsDroits() {
        return this.lotsDroits;
    }

    public void setLotsDroits(Map<Lot, LotPersonneDroits> lotsDroits) {
        this.lotsDroits = lotsDroits;
    }

    public String getNom() {
        return this.nom;
    }

    public void setNom(String nom) {
        this.nom = nom;
    }

    public String getOrganisme() {
        return this.organisme;
    }

    public void setOrganisme(String organisme) {
        this.organisme = organisme;
    }

    public String getPrenom() {
        return this.prenom;
    }

    public void setPrenom(String prenom) {
        this.prenom = prenom;
    }

    public String getTel() {
        return this.tel;
    }

    public void setTel(String tel) {
        this.tel = tel;
    }

    public String getVille() {
        return this.ville;
    }

    public void setVille(String ville) {
        this.ville = ville;
    }

    public List<Station> getStationsCrees() {
        return this.stationsCrees;
    }

    public void setStationsCrees(List<Station> stationsCrees) {
        this.stationsCrees = stationsCrees;
    }

    public List<Specimen> getSpecimensCrees() {
        return this.specimensCrees;
    }

    public void setSpecimensCrees(List<Specimen> specimensCrees) {
        this.specimensCrees = specimensCrees;
    }

    public List<Extraction> getExtractionsCrees() {
        return this.extractionsCrees;
    }

    public void setExtractionsCrees(List<Extraction> extractionsCrees) {
        this.extractionsCrees = extractionsCrees;
    }

    public List<Purification> getPurificationsCrees() {
        return this.purificationsCrees;
    }

    public void setPurificationsCrees(List<Purification> purificationsCrees) {
        this.purificationsCrees = purificationsCrees;
    }

    public List<TestBio> getTestsBioCrees() {
        return this.testsBioCrees;
    }

    public void setTestsBioCrees(List<TestBio> testsBioCrees) {
        this.testsBioCrees = testsBioCrees;
    }

    @Override
    public List<Document> getDocuments() {
        return this.documents;
    }

    public void setDocuments(List<Document> documents) {
        this.documents = documents;
    }

    @Override
    public void addDocument(Document document) {
        this.documents.add(document);
    }

    @Override
    public void removeDocument(Document document) {
        this.documents.remove(document);
    }
}

