/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.data.model;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import nc.ird.cantharella.data.model.Campagne;
import nc.ird.cantharella.data.model.Document;
import nc.ird.cantharella.data.model.MoleculeProvenance;
import nc.ird.cantharella.data.model.Personne;
import nc.ird.cantharella.data.model.utils.AbstractModel;
import nc.ird.cantharella.data.model.utils.DocumentAttachable;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.Type;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.IndexedEmbedded;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotEmpty;

@Entity
@Indexed
public class Molecule
extends AbstractModel
implements DocumentAttachable {
    @Id
    @GeneratedValue(generator="molecule_sequence_gen")
    @SequenceGenerator(name="molecule_sequence_gen", sequenceName="molecule_sequence")
    private Integer idMolecule;
    @Length(max=100)
    @Field
    private String nomCommun;
    @Length(max=60)
    @Field
    private String familleChimique;
    @Lob
    @Type(type="org.hibernate.type.StringClobType")
    private String formuleDevMol;
    @Length(max=255)
    @Field
    private String nomIupca;
    @Length(max=60)
    @NotEmpty
    @Field
    private String formuleBrute;
    @Min(value=0L)
    @Max(value=99999L)
    @Column(precision=9, scale=4)
    private BigDecimal masseMolaire;
    private boolean nouvMolecul;
    @ManyToOne(fetch=FetchType.EAGER)
    @IndexedEmbedded
    private Campagne campagne;
    @Length(max=60)
    @Field
    private String identifieePar;
    @Lob
    @Type(type="org.hibernate.type.StringClobType")
    private String publiOrigine;
    @Lob
    @Type(type="org.hibernate.type.StringClobType")
    private String complement;
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, optional=false)
    private Personne createur;
    @OneToMany(mappedBy="molecule", fetch=FetchType.LAZY, orphanRemoval=true)
    @Cascade(value={CascadeType.SAVE_UPDATE})
    @IndexedEmbedded
    private List<MoleculeProvenance> provenances = new ArrayList<MoleculeProvenance>();
    @OneToMany(fetch=FetchType.EAGER, orphanRemoval=true)
    @JoinColumn(name="molecule")
    @Cascade(value={CascadeType.SAVE_UPDATE})
    @Fetch(value=FetchMode.SUBSELECT)
    private List<Document> documents = new ArrayList<Document>();

    public Integer getIdMolecule() {
        return this.idMolecule;
    }

    public void setIdMolecule(Integer idMolecule) {
        this.idMolecule = idMolecule;
    }

    public String getNomCommun() {
        return this.nomCommun;
    }

    public void setNomCommun(String nomCommun) {
        this.nomCommun = nomCommun;
    }

    public String getFamilleChimique() {
        return this.familleChimique;
    }

    public void setFamilleChimique(String familleChimique) {
        this.familleChimique = familleChimique;
    }

    public String getFormuleDevMol() {
        return this.formuleDevMol;
    }

    public void setFormuleDevMol(String formuleDevMol) {
        this.formuleDevMol = formuleDevMol;
    }

    public String getNomIupca() {
        return this.nomIupca;
    }

    public void setNomIupca(String nomIupca) {
        this.nomIupca = nomIupca;
    }

    public String getFormuleBrute() {
        return this.formuleBrute;
    }

    public void setFormuleBrute(String formuleBrute) {
        this.formuleBrute = formuleBrute;
    }

    public BigDecimal getMasseMolaire() {
        return this.masseMolaire;
    }

    public void setMasseMolaire(BigDecimal masseMolaire) {
        this.masseMolaire = masseMolaire;
    }

    public boolean isNouvMolecul() {
        return this.nouvMolecul;
    }

    public void setNouvMolecul(boolean nouvMolecul) {
        this.nouvMolecul = nouvMolecul;
    }

    public Campagne getCampagne() {
        return this.campagne;
    }

    public void setCampagne(Campagne campagne) {
        this.campagne = campagne;
    }

    public String getIdentifieePar() {
        return this.identifieePar;
    }

    public void setIdentifieePar(String identifieePar) {
        this.identifieePar = identifieePar;
    }

    public String getPubliOrigine() {
        return this.publiOrigine;
    }

    public void setPubliOrigine(String publiOrigine) {
        this.publiOrigine = publiOrigine;
    }

    public String getComplement() {
        return this.complement;
    }

    public void setComplement(String complement) {
        this.complement = complement;
    }

    public Personne getCreateur() {
        return this.createur;
    }

    public void setCreateur(Personne createur) {
        this.createur = createur;
    }

    public List<MoleculeProvenance> getProvenances() {
        return this.provenances;
    }

    public void setProvenances(List<MoleculeProvenance> provenances) {
        this.provenances = provenances;
    }

    @Override
    public List<Document> getDocuments() {
        return this.documents;
    }

    public void setDocuments(List<Document> documents) {
        this.documents = documents;
    }

    @Override
    public void addDocument(Document document) {
        this.documents.add(document);
    }

    @Override
    public void removeDocument(Document document) {
        this.documents.remove(document);
    }
}

