/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.data.dao.impl;

import java.io.Serializable;
import java.util.List;
import javax.annotation.Resource;
import nc.ird.cantharella.data.dao.GenericDao;
import nc.ird.cantharella.data.model.utils.AbstractModel;
import nc.ird.cantharella.utils.AssertTools;
import nc.ird.cantharella.utils.GenericsTools;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.springframework.orm.ObjectRetrievalFailureException;
import org.springframework.stereotype.Repository;

@Repository
public class HibernateTemplateDao
implements GenericDao {
    @Resource
    private SessionFactory sessionFactory;

    private static DetachedCriteria criteriaByProperty(Class<? extends AbstractModel> modelClass, String propertyName, Serializable value) {
        return DetachedCriteria.forClass(modelClass).add((Criterion)Restrictions.eq((String)propertyName, (Object)value));
    }

    @Override
    public long count(DetachedCriteria criteria) {
        AssertTools.assertNotNull((Object)criteria);
        return (Long)this.list(criteria.setProjection(Projections.rowCount())).get(0);
    }

    @Override
    public <M extends AbstractModel> long count(Class<M> modelClass) {
        AssertTools.assertNotNull(modelClass);
        return (Long)this.list(DetachedCriteria.forClass(modelClass).setProjection(Projections.rowCount())).get(0);
    }

    @Override
    public long count(String hqlQuery, Object ... parameters) {
        AssertTools.assertNotEmpty((String)hqlQuery);
        Query query = this.sessionFactory.getCurrentSession().createQuery(hqlQuery);
        for (int i = 0; i < parameters.length; ++i) {
            query.setParameter(i, parameters[i]);
        }
        return (Long)query.iterate().next();
    }

    @Override
    public <M extends AbstractModel> void create(M model) {
        AssertTools.assertNotNull(model);
        this.sessionFactory.getCurrentSession().save(model);
    }

    @Override
    public <M extends AbstractModel> void createOrUpdate(M model) {
        AssertTools.assertNotNull(model);
        this.sessionFactory.getCurrentSession().saveOrUpdate(model);
    }

    @Override
    public <M extends AbstractModel> void delete(Class<M> modelClass, Serializable id) {
        AssertTools.assertNotNull(modelClass);
        AssertTools.assertNotNull((Object)id);
        this.sessionFactory.getCurrentSession().delete(this.read(modelClass, id));
    }

    @Override
    public <M extends AbstractModel> void delete(M model) {
        AssertTools.assertNotNull(model);
        this.sessionFactory.getCurrentSession().delete(model);
    }

    @Override
    public List<?> list(DetachedCriteria criteria) {
        AssertTools.assertNotNull((Object)criteria);
        Criteria execCriteria = criteria.getExecutableCriteria(this.sessionFactory.getCurrentSession());
        return execCriteria.list();
    }

    @Override
    public List<?> list(String hqlQuery, Object ... parameters) {
        Query query = this.sessionFactory.getCurrentSession().createQuery(hqlQuery);
        for (int i = 0; i < parameters.length; ++i) {
            query.setParameter(i, parameters[i]);
        }
        return query.list();
    }

    @Override
    public int execute(String sqlQuery, Object ... parameters) {
        AssertTools.assertNotEmpty((String)sqlQuery);
        SQLQuery query = this.sessionFactory.getCurrentSession().createSQLQuery(sqlQuery);
        for (int i = 0; i < parameters.length; ++i) {
            query.setParameter(i, parameters[i]);
        }
        int nbLines = query.executeUpdate();
        this.sessionFactory.getCurrentSession().flush();
        this.sessionFactory.getCurrentSession().clear();
        return nbLines;
    }

    @Override
    public <M extends AbstractModel> boolean exists(Class<M> modelClass, Serializable id) {
        return this.count(HibernateTemplateDao.criteriaByProperty(modelClass, AbstractModel.getIdField(modelClass).getName(), id).setProjection(Projections.rowCount())) > 0L;
    }

    @Override
    public <M extends AbstractModel> boolean exists(Class<M> modelClass, String property, Serializable value) {
        return this.count(HibernateTemplateDao.criteriaByProperty(modelClass, property, value).setProjection(Projections.rowCount())) > 0L;
    }

    @Override
    public boolean exists(DetachedCriteria criteria) {
        return this.count(criteria) > 0L;
    }

    @Override
    public <M extends AbstractModel> List<M> readList(Class<M> modelClass) {
        AssertTools.assertNotNull(modelClass);
        Criteria criteria = this.sessionFactory.getCurrentSession().createCriteria(modelClass);
        criteria.addOrder(Order.asc((String)AbstractModel.getIdField(modelClass).getName()));
        return (List)GenericsTools.cast((Object)criteria.list());
    }

    @Override
    public <M extends AbstractModel> List<M> readList(Class<M> modelClass, String ... sortColumns) {
        AssertTools.assertNotNull(modelClass);
        AssertTools.assertNotEmpty((Object[])sortColumns);
        Criteria criteria = this.sessionFactory.getCurrentSession().createCriteria(modelClass);
        for (String sortCol : sortColumns) {
            criteria.addOrder(Order.asc((String)sortCol));
        }
        return (List)GenericsTools.cast((Object)criteria.list());
    }

    @Override
    public <M extends AbstractModel> List<M> readList(Class<M> modelClass, int firstResult, int maxResults) {
        AssertTools.assertNotNull(modelClass);
        AssertTools.assertPositive((Number)firstResult);
        AssertTools.assertPositive((Number)maxResults);
        Criteria criteria = this.sessionFactory.getCurrentSession().createCriteria(modelClass);
        criteria.addOrder(Order.asc((String)AbstractModel.getIdField(modelClass).getName()));
        criteria.setFirstResult(firstResult);
        criteria.setMaxResults(maxResults);
        return (List)GenericsTools.cast((Object)criteria.list());
    }

    @Override
    public <M extends AbstractModel> List<M> readList(Class<M> modelClass, int firstResult, int maxResults, String ... sortColumns) {
        AssertTools.assertNotNull(modelClass);
        AssertTools.assertNotEmpty((Object[])sortColumns);
        AssertTools.assertPositive((Number)firstResult);
        AssertTools.assertPositive((Number)maxResults);
        Criteria criteria = this.sessionFactory.getCurrentSession().createCriteria(modelClass);
        for (String sortCol : sortColumns) {
            criteria.addOrder(Order.asc((String)sortCol));
        }
        criteria.setFirstResult(firstResult);
        criteria.setMaxResults(maxResults);
        return (List)GenericsTools.cast((Object)criteria.list());
    }

    @Override
    public <M extends AbstractModel> M read(Class<M> modelClass, Serializable id) {
        AssertTools.assertNotNull(modelClass);
        AssertTools.assertNotNull((Object)id);
        AbstractModel m = (AbstractModel)modelClass.cast(this.sessionFactory.getCurrentSession().get(modelClass, id));
        if (m == null) {
            throw new ObjectRetrievalFailureException(modelClass, (Object)id);
        }
        return (M)m;
    }

    @Override
    public <M extends AbstractModel> M read(Class<M> modelClass, String uniqueProperty, Serializable value) {
        List<?> list = this.list(HibernateTemplateDao.criteriaByProperty(modelClass, uniqueProperty, value));
        if (list.size() != 1) {
            throw new ObjectRetrievalFailureException(modelClass, (Object)value);
        }
        return (M)((AbstractModel)list.get(0));
    }

    @Override
    public <M extends AbstractModel> void refresh(M model) {
        AssertTools.assertNotNull(model);
        this.sessionFactory.getCurrentSession().refresh(model);
    }

    @Override
    public <M extends AbstractModel> void update(M model) {
        AssertTools.assertNotNull(model);
        this.sessionFactory.getCurrentSession().update(model);
    }

    @Override
    public <M extends AbstractModel> void evict(M model) {
        AssertTools.assertNotNull(model);
        this.sessionFactory.getCurrentSession().evict(model);
    }

    @Override
    public <M extends AbstractModel> boolean contains(M model) {
        AssertTools.assertNotNull(model);
        return this.sessionFactory.getCurrentSession().contains(model);
    }

    @Override
    public <M extends AbstractModel> M merge(M model) {
        AssertTools.assertNotNull(model);
        return (M)((AbstractModel)this.sessionFactory.getCurrentSession().merge(model));
    }
}

