/*
 * Decompiled with CFR 0.152.
 */
package nc.ird.cantharella.data.config;

import com.mchange.v2.c3p0.ComboPooledDataSource;
import com.mchange.v2.c3p0.impl.DefaultConnectionTester;
import java.beans.PropertyVetoException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import javax.validation.Validation;
import javax.validation.ValidatorFactory;
import nc.ird.cantharella.data.exceptions.UnexpectedException;
import nc.ird.cantharella.data.model.search.CantharellaAnalyzer;
import nc.ird.cantharella.data.validation.utils.ModelValidator;
import nc.ird.cantharella.data.validation.utils.ModelValidatorImpl;
import nc.ird.cantharella.utils.CantharellaConfig;
import org.hibernate.SessionFactory;
import org.hibernate.cache.ehcache.SingletonEhCacheRegionFactory;
import org.hibernate.dialect.PostgreSQL82Dialect;
import org.nuiton.config.ArgumentsParserException;
import org.postgresql.Driver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportResource;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.orm.hibernate4.HibernateTransactionManager;
import org.springframework.orm.hibernate4.LocalSessionFactoryBean;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@ImportResource(value={"classpath:/dataContext.xml"})
@ComponentScan(basePackages={"nc.ird.cantharella.data.dao", "nc.ird.cantharella.data.validation.utils"})
@EnableTransactionManagement
@Configuration
public abstract class DataContext {
    private static final Logger LOG = LoggerFactory.getLogger(DataContext.class);
    public static final List<String> COUNTRY_CODES = Collections.unmodifiableList(Arrays.asList(Locale.getISOCountries()));
    public static final List<String> LANGUAGE_CODES = Collections.unmodifiableList(Arrays.asList(Locale.getISOLanguages()));
    private static final int DB_CONNECTION_ACQUIRE_RETRY_ATTEMPS = 30;
    private static final int DB_CONNECTION_ACQUIRE_RETRY_DELAY = 1000;
    private static final int DB_POOL_MIN_SIZE = 3;
    public static final String ENCODING = Charset.forName("UTF-8").name();
    public static final List<Locale> LOCALES;
    public static final int DECIMAL_PRECISION = 9;
    public static final int DECIMAL_SCALE = 4;
    public static final int DECIMAL_MAX = 99999;
    public static final Map<Integer, String> REFERENTIELS;
    @Value(value="${db.debug}")
    protected boolean dbDebugProperty;
    @Value(value="${db.password}")
    protected String dbPasswordProperty;
    @Value(value="${db.url}")
    protected String dbUrlProperty;
    @Value(value="${db.user}")
    protected String dbUserProperty;
    @Value(value="${db.hbm2ddl}")
    protected String hbm2ddl;
    @Value(value="${hibernate.search.indexBase}")
    protected String hibernateSearchIndexBase;

    @Bean
    public MessageSourceAccessor dataMessageSource() {
        ReloadableResourceBundleMessageSource dataMessageSource = new ReloadableResourceBundleMessageSource();
        dataMessageSource.setBasename("data");
        dataMessageSource.setDefaultEncoding(ENCODING);
        dataMessageSource.setCacheSeconds(-1);
        return new MessageSourceAccessor((MessageSource)dataMessageSource);
    }

    @Bean
    public DataSource dataSource() {
        ComboPooledDataSource dataSource = new ComboPooledDataSource();
        try {
            dataSource.setDriverClass(Driver.class.getName());
        }
        catch (PropertyVetoException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new UnexpectedException(e);
        }
        dataSource.setJdbcUrl(this.dbUrlProperty);
        dataSource.setPassword(this.dbPasswordProperty);
        dataSource.setUser(this.dbUserProperty);
        dataSource.setInitialPoolSize(3);
        dataSource.setMaxConnectionAge(0);
        dataSource.setMaxIdleTimeExcessConnections(0);
        dataSource.setAutomaticTestTable(null);
        try {
            dataSource.setConnectionTesterClassName(DefaultConnectionTester.class.getName());
        }
        catch (PropertyVetoException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new UnexpectedException(e);
        }
        dataSource.setPreferredTestQuery(null);
        dataSource.setTestConnectionOnCheckin(false);
        dataSource.setTestConnectionOnCheckout(false);
        dataSource.setMaxStatementsPerConnection(0);
        dataSource.setAcquireRetryAttempts(30);
        dataSource.setAcquireRetryDelay(1000);
        dataSource.setBreakAfterAcquireFailure(false);
        dataSource.setConnectionCustomizerClassName(null);
        dataSource.setAutoCommitOnClose(false);
        dataSource.setForceIgnoreUnresolvedTransactions(false);
        dataSource.setDebugUnreturnedConnectionStackTraces(false);
        dataSource.setUnreturnedConnectionTimeout(0);
        dataSource.setCheckoutTimeout(0);
        dataSource.setFactoryClassLocation(null);
        dataSource.setMaxAdministrativeTaskTime(0);
        dataSource.setUsesTraditionalReflectiveProxies(false);
        return dataSource;
    }

    @Bean
    public SessionFactory sessionFactory() {
        LocalSessionFactoryBean sessionFactoryBean = new LocalSessionFactoryBean();
        sessionFactoryBean.setDataSource(this.dataSource());
        sessionFactoryBean.setPackagesToScan(new String[]{"nc.ird.cantharella.data.model"});
        Properties hibernateProperties = new Properties();
        hibernateProperties.setProperty("hibernate.dialect", PostgreSQL82Dialect.class.getName());
        hibernateProperties.setProperty("hibernate.hbm2ddl.auto", this.hbm2ddl);
        hibernateProperties.setProperty("hibernate.generate_statistics", String.valueOf(this.dbDebugProperty));
        hibernateProperties.setProperty("hibernate.cache.use_structured_entries", String.valueOf(this.dbDebugProperty));
        hibernateProperties.setProperty("hibernate.show_sql", String.valueOf(false));
        hibernateProperties.setProperty("hibernate.format_sql", String.valueOf(false));
        hibernateProperties.setProperty("hibernate.use_sql_comments", String.valueOf(this.dbDebugProperty));
        hibernateProperties.setProperty("hibernate.cache.region.factory_class", SingletonEhCacheRegionFactory.class.getName());
        hibernateProperties.setProperty("hibernate.cache.use_query_cache", String.valueOf(true));
        hibernateProperties.setProperty("hibernate.cache.use_second_level_cache", String.valueOf(true));
        hibernateProperties.setProperty("hibernate.cache.use_structured_entries", String.valueOf(this.dbDebugProperty));
        hibernateProperties.setProperty("hibernate.connection.autocommit", String.valueOf(false));
        hibernateProperties.setProperty("hibernate.connection.release_mode", "on_close");
        hibernateProperties.setProperty("hibernate.search.default.directory_provider", "filesystem");
        hibernateProperties.setProperty("hibernate.search.default.indexBase", this.hibernateSearchIndexBase);
        hibernateProperties.setProperty("hibernate.search.analyzer", CantharellaAnalyzer.class.getName());
        hibernateProperties.setProperty("hibernate.search.enable_dirty_check", "false");
        hibernateProperties.setProperty("hibernate.search.lucene_version", "LUCENE_36");
        hibernateProperties.setProperty("hibernate.default_batch_fetch_size", String.valueOf(20));
        sessionFactoryBean.setHibernateProperties(hibernateProperties);
        try {
            sessionFactoryBean.afterPropertiesSet();
        }
        catch (Exception e) {
            throw new RuntimeException("SessionFactory misconfiguration", e);
        }
        return sessionFactoryBean.getObject();
    }

    @Bean
    public HibernateTransactionManager transactionManager() {
        return new HibernateTransactionManager(this.sessionFactory());
    }

    @Bean
    public ValidatorFactory validatorFactory() {
        return Validation.buildDefaultValidatorFactory();
    }

    @Bean
    public ModelValidator dataModelValidator() {
        return new ModelValidatorImpl(this.validatorFactory(), this.dataMessageSource());
    }

    @Bean
    public static PropertySourcesPlaceholderConfigurer properties() {
        PropertySourcesPlaceholderConfigurer pspc = new PropertySourcesPlaceholderConfigurer();
        try {
            pspc.setProperties(CantharellaConfig.getProperties());
        }
        catch (ArgumentsParserException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new UnexpectedException((Exception)((Object)e));
        }
        pspc.setIgnoreUnresolvablePlaceholders(true);
        return pspc;
    }

    static {
        ArrayList<Locale> locales = new ArrayList<Locale>();
        locales.add(Locale.FRENCH);
        locales.add(Locale.ENGLISH);
        LOCALES = Collections.unmodifiableList(locales);
        HashMap<Integer, String> referentiels = new HashMap<Integer, String>();
        referentiels.put(4326, "WGS84");
        REFERENTIELS = Collections.unmodifiableMap(referentiels);
    }
}

